/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.report.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import ro.amiq.vlogdt.linter.CheckStatus;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.report.VerissimoReportWriter;
import ro.amiq.vlogdt.linter.report.model.REdit;
import ro.amiq.vlogdt.linter.report.model.RHit;

public class RCheck {
    private String name;
    private String title;
    private String version;
    private Set<RuleLabel> labels;
    private String description;
    private Integer category;
    private Integer status;
    private Integer effort;
    private Set<RHit> hits;
    private List<REdit> autocorrectEdits;
    private List<List<String>> parameters;
    private List<List<String>> autocorrectParameters;
    private List<List<Integer>> annotationStringIndexes;
    private List<List<String>> annotationStringsValues;
    private long runTime;
    private boolean autocorrectable;
    private boolean manualCheck;
    private static int checkCounter;
    private int checkIndex;
    private Set<String> compareAnnotations;
    public static final String REMOVED_CHECKS = "Removed Checks";
    public static final String ADDED_CHECKS = "Added Checks";
    public static final String COMMON = "Common";
    public static final Map<String, Integer> ANNOTATION_STRING_2_INDEX;
    private CheckStatus severity;
    private String checkID;
    private boolean hasAutocorrectEnabled;

    static {
        ANNOTATION_STRING_2_INDEX = new HashMap<String, Integer>();
        ANNOTATION_STRING_2_INDEX.put(REMOVED_CHECKS, 0);
        ANNOTATION_STRING_2_INDEX.put(ADDED_CHECKS, 1);
        ANNOTATION_STRING_2_INDEX.put(COMMON, 2);
    }

    public RCheck(String checkName, String checkTitle, String checkVersion, Set<RuleLabel> checkLabels, String checkDescription, Integer checkEffort, Integer categoryIndex, Integer checkStatus, String checkID, CheckStatus severity, long runTime, boolean autocorrectable, boolean manualCheck, boolean hasAutocorrectEnabled) {
        this.name = checkName;
        this.title = checkTitle;
        this.version = checkVersion;
        this.labels = checkLabels;
        this.description = checkDescription;
        this.effort = checkEffort;
        this.category = categoryIndex;
        this.status = checkStatus;
        this.hits = new LinkedHashSet<RHit>();
        this.autocorrectEdits = new ArrayList<REdit>();
        this.parameters = new ArrayList<List<String>>();
        this.autocorrectParameters = new ArrayList<List<String>>();
        this.annotationStringIndexes = new ArrayList<List<Integer>>();
        this.annotationStringsValues = new ArrayList<List<String>>();
        this.checkID = checkID;
        this.severity = severity;
        this.runTime = runTime;
        this.autocorrectable = autocorrectable;
        this.manualCheck = manualCheck;
        this.hasAutocorrectEnabled = hasAutocorrectEnabled;
        this.checkIndex = checkCounter++;
        this.compareAnnotations = new LinkedHashSet<String>();
    }

    public RCheck(RCheck check) {
        this.name = check.name;
        this.title = check.title;
        this.version = check.version;
        this.description = check.description;
        this.category = check.category;
        this.status = check.status;
        this.effort = check.effort;
        this.hits = new LinkedHashSet<RHit>();
        check.hits.stream().forEach(x -> {
            boolean bl = this.hits.add(new RHit((RHit)x));
        });
        this.runTime = check.runTime;
        this.autocorrectable = check.autocorrectable;
        this.manualCheck = check.manualCheck;
        this.checkIndex = check.checkIndex;
        this.severity = check.severity;
        this.checkID = check.checkID;
        this.hasAutocorrectEnabled = check.hasAutocorrectEnabled;
        this.annotationStringIndexes = check.annotationStringIndexes;
        this.annotationStringsValues = check.annotationStringsValues;
        this.parameters = new ArrayList<List<String>>();
        check.parameters.stream().forEach(x -> {
            boolean bl = this.parameters.add((List<String>)x);
        });
        this.autocorrectParameters = new ArrayList<List<String>>();
        check.autocorrectParameters.stream().forEach(x -> {
            boolean bl = this.autocorrectParameters.add((List<String>)x);
        });
        this.autocorrectEdits = new ArrayList<REdit>();
        check.autocorrectEdits.stream().forEach(x -> {
            boolean bl = this.autocorrectEdits.add((REdit)x);
        });
        this.compareAnnotations = new LinkedHashSet<String>();
        check.compareAnnotations.stream().forEach(x -> {
            boolean bl = this.compareAnnotations.add((String)x);
        });
        this.labels = new LinkedHashSet<RuleLabel>();
        check.labels.stream().forEach(x -> {
            boolean bl = this.labels.add((RuleLabel)((Object)x));
        });
    }

    public String getCheckID() {
        return this.checkID;
    }

    public void setCheckID(String checkID) {
        this.checkID = checkID;
    }

    public CheckStatus getSeverity() {
        return this.severity;
    }

    public void setSeverity(CheckStatus severity) {
        this.severity = severity;
    }

    public RCheck getSelf() {
        return this;
    }

    public String getCheckName() {
        return this.name;
    }

    public String getCheckTitle() {
        return this.title;
    }

    public String getCheckVersion() {
        return this.version;
    }

    public String getCheckDescription() {
        return this.description;
    }

    public Integer getEffort() {
        return this.effort;
    }

    public Integer getCategoryIndex() {
        return this.category;
    }

    public void setCategoryIndex(Integer categoryIndex) {
        this.category = categoryIndex;
    }

    public Integer getCheckStatus() {
        return this.status;
    }

    public void setCheckStatus(int status) {
        this.status = status;
    }

    public Set<RHit> getHits() {
        return this.hits;
    }

    public boolean addHit(RHit hit) {
        return this.hits.add(hit);
    }

    public void setHits(Set<RHit> hits) {
        this.hits = hits;
    }

    public int getCheckIndex() {
        return this.checkIndex;
    }

    public void setEffort(Integer effort) {
        this.effort = effort;
    }

    public void setCheckIndex(int checkIndex) {
        this.checkIndex = checkIndex;
    }

    public static void setCheckCounter(int checkCounter) {
        RCheck.checkCounter = checkCounter;
    }

    public void addCompareAnnotation(String compareAnnotation) {
        this.compareAnnotations.add(compareAnnotation);
    }

    public void addCompareAnnotationBasedOnIndex(Integer annotationIndex) {
        Optional<Map.Entry> foundAnnotation = ANNOTATION_STRING_2_INDEX.entrySet().parallelStream().filter(entry -> annotationIndex.equals(entry.getValue())).findFirst();
        if (foundAnnotation.isPresent()) {
            String compareAnnotation = (String)foundAnnotation.get().getKey();
            this.compareAnnotations.add(compareAnnotation);
        }
    }

    public Set<String> getCompareAnnotations() {
        return this.compareAnnotations;
    }

    public List<Integer> getCompareAnnotationsIndexes() {
        return this.compareAnnotations.stream().map(annotation -> ANNOTATION_STRING_2_INDEX.get(annotation)).collect(Collectors.toList());
    }

    public String getCompareAnnotationsIndexesAsString() {
        StringBuilder indexes = new StringBuilder();
        if (this.compareAnnotations == null || this.compareAnnotations.isEmpty()) {
            indexes.append("[]");
        } else {
            indexes.append('[');
            for (Integer index : this.getCompareAnnotationsIndexes()) {
                indexes.append(index).append(',');
            }
            VerissimoReportWriter.removeLastChar(indexes);
            indexes.append("]");
        }
        return indexes.toString();
    }

    public String getParametersAsString() {
        return this.getParametersAsString(this.parameters);
    }

    public String getAutocorrectParametersAsString() {
        return this.getParametersAsString(this.autocorrectParameters);
    }

    public String getParametersAsString(List<List<String>> parameters) {
        StringBuilder result = new StringBuilder();
        if (parameters == null || parameters.isEmpty()) {
            result.append("[]");
        } else {
            result.append('[');
            for (List<String> parameterElements : parameters) {
                result.append(VerissimoReportWriter.esc(parameterElements.get(0))).append(',').append(VerissimoReportWriter.esc(parameterElements.get(1))).append(',').append(VerissimoReportWriter.esc(parameterElements.get(2))).append(',').append(VerissimoReportWriter.esc(parameterElements.get(3))).append(',');
            }
            VerissimoReportWriter.removeLastChar(result);
            result.append("]");
        }
        return result.toString();
    }

    public long getRunTime() {
        return this.runTime;
    }

    public void setRunTime(long runTime) {
        this.runTime = runTime;
    }

    public boolean isAutocorrectable() {
        return this.autocorrectable;
    }

    public boolean isManualCheck() {
        return this.manualCheck;
    }

    public void setManualCheck(boolean manualCheck) {
        this.manualCheck = manualCheck;
    }

    public String getHitIndexesAsString() {
        StringBuilder indexes = new StringBuilder("[");
        for (RHit hitWrapper : this.hits) {
            if (hitWrapper.isFixed() || hitWrapper.isHidden() || hitWrapper.isHiddenCompare()) continue;
            indexes.append(hitWrapper.getHitIndex()).append(',');
        }
        VerissimoReportWriter.removeLastChar(indexes);
        indexes.append("]");
        return indexes.toString();
    }

    public String getLabelIndexesAsString(Map<RuleLabel, Integer> allLabelsMap) {
        StringBuilder indexes = new StringBuilder("[");
        if (this.labels != null) {
            for (RuleLabel label : this.labels) {
                Integer index = allLabelsMap.get((Object)label);
                if (index == null) continue;
                indexes.append(index).append(',');
            }
            VerissimoReportWriter.removeLastChar(indexes);
        }
        indexes.append("]");
        return indexes.toString();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.checkID == null ? 0 : this.checkID.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.severity == null ? 0 : this.severity.hashCode());
        result = 31 * result + (this.status == null ? 0 : this.status.hashCode());
        result = 31 * result + (this.title == null ? 0 : this.title.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RCheck other = (RCheck)obj;
        if (this.checkID == null ? other.checkID != null : !this.checkID.equals(other.checkID)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.severity != other.severity) {
            return false;
        }
        if (this.status == null ? other.status != null : !this.status.equals(other.status)) {
            return false;
        }
        return !(this.title == null ? other.title != null : !this.title.equals(other.title));
    }

    public String toString() {
        return this.name;
    }

    public int getNofWaivedHits() {
        int nOfWaivedHits = 0;
        for (RHit hit : this.hits) {
            if (hit.getHitSeverity().intValue() != CheckStatus.DISABLED.ordinal()) continue;
            ++nOfWaivedHits;
        }
        return nOfWaivedHits;
    }

    public int getNofFixedHits() {
        int nOfFixedHits = 0;
        for (RHit hit : this.hits) {
            if (!hit.isFixed()) continue;
            ++nOfFixedHits;
        }
        return nOfFixedHits;
    }

    public List<REdit> getAutocorrectEdits() {
        return this.autocorrectEdits;
    }

    public void addAutocorrectEdits(List<REdit> edits) {
        this.autocorrectEdits.addAll(edits);
    }

    public void setParameters(List<List<String>> params) {
        this.parameters = params;
    }

    public void setAutocorrectParameters(List<List<String>> params) {
        this.autocorrectParameters = params;
    }

    public void addParameter(List<String> parameterFields) {
        if ("null".equals(parameterFields.get(3))) {
            return;
        }
        this.parameters.add(parameterFields);
    }

    public List<List<String>> getParameters() {
        return this.parameters;
    }

    public void addAutocorrectParameter(List<String> parameterFields) {
        if ("null".equals(parameterFields.get(3))) {
            return;
        }
        this.autocorrectParameters.add(parameterFields);
    }

    public List<List<String>> getAutocorrectParameters() {
        return this.autocorrectParameters;
    }

    public boolean isAutocorrectEnabled() {
        return this.hasAutocorrectEnabled;
    }

    public void setAutocorrectEnabled(boolean hasAutocorrectEnabled) {
        this.hasAutocorrectEnabled = hasAutocorrectEnabled;
    }

    public Set<RuleLabel> getLabels() {
        return this.labels;
    }

    public void setLabels(Set<RuleLabel> labels) {
        this.labels = labels;
    }

    public List<List<Integer>> getAnnotationStringIndexes() {
        return this.annotationStringIndexes;
    }

    public void addAnnotationStringIndex(List<Integer> annotationStringIndex) {
        this.annotationStringIndexes.add(annotationStringIndex);
    }

    public void setAnnotationStringIndex(int listIndex, int annotationIndex, int element) {
        if (listIndex < this.annotationStringIndexes.size()) {
            List<Integer> list = this.annotationStringIndexes.get(listIndex);
            if (annotationIndex < list.size()) {
                list.set(annotationIndex, element);
            } else {
                list.add(element);
            }
        }
    }

    public boolean populateAnnotationStringsValues(List<Set<String>> allAnnotationStrings) {
        if (!this.annotationStringsValues.isEmpty()) {
            return true;
        }
        if (allAnnotationStrings == null || this.annotationStringIndexes == null || allAnnotationStrings.size() != this.annotationStringIndexes.size()) {
            return false;
        }
        int i = 0;
        while (i < this.annotationStringIndexes.size()) {
            ArrayList<String> resolvedAnnotationValues = new ArrayList<String>();
            this.annotationStringsValues.add(resolvedAnnotationValues);
            Set<String> annotationStringsSet = allAnnotationStrings.get(i);
            List<Integer> annotationIndexes = this.annotationStringIndexes.get(i);
            if (annotationIndexes != null && annotationStringsSet != null) {
                ArrayList<String> annotationStrings = new ArrayList<String>(annotationStringsSet);
                int j = 0;
                while (j < annotationIndexes.size()) {
                    resolvedAnnotationValues.add((String)annotationStrings.get(annotationIndexes.get(j)));
                    ++j;
                }
            }
            ++i;
        }
        return true;
    }

    public void initAnnotationStringIndex(int size) {
        this.annotationStringIndexes = new ArrayList<List<Integer>>(size);
        int i = 0;
        while (i < size) {
            this.annotationStringIndexes.add(new ArrayList());
            ++i;
        }
    }

    public List<List<String>> getAnnotationStringsValues() {
        return this.annotationStringsValues;
    }

    public boolean addAnnotationStringsValues(List<String> element) {
        return this.annotationStringsValues.add(element);
    }

    public void clearAnnotationValues() {
        this.annotationStringsValues = new ArrayList<List<String>>();
    }
}

