/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.report.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import ro.amiq.vlogdt.linter.CheckStatus;
import ro.amiq.vlogdt.linter.report.model.REdit;
import ro.amiq.vlogdt.linter.report.model.RError;

public class RHit {
    private Integer hitSeverity;
    private Integer checkIndex;
    private Integer indexPath;
    private String file;
    private Integer hitLine;
    private List<MacroPathWrapper> macroParts;
    private String hitDetails;
    private String macroDetails;
    private List<DetailsLinkWrapper> detailsLinks;
    private List<List<Integer>> annotationStringIndexes;
    private List<List<String>> annotationStringsValues;
    private List<Integer> hitSources;
    private long creationDate;
    private String compareHitOrigin;
    private boolean fixed;
    private String checkName;
    private static int hitCounter = 0;
    private int hitIndex;
    private Set<String> compareAnnotations;
    private Integer compareModifiedStatus = -1;
    private boolean isHidden;
    private List<REdit> rEdits;
    private RError rError;
    private boolean isHiddenCompare;
    public static final String NEW_FIXES = "New Fixes";
    public static final String REMOVED_RULES = "Removed Rules";
    public static final String NEW_FAILURES = "New Failures";
    public static final String ADDED_RULES = "Added Rules";
    public static final String COMMON = "Common";
    public static final String HIDDEN = "Hidden";
    public static final String BASELINE = "Baseline";
    public static final String CURRENT = "Current";
    public static final Map<String, Integer> ANNOTATION_STRING_2_INDEX = new HashMap<String, Integer>();
    public static final Map<String, Integer> HIT_ORIGIN_2_INDEX;

    static {
        ANNOTATION_STRING_2_INDEX.put(NEW_FAILURES, 0);
        ANNOTATION_STRING_2_INDEX.put(NEW_FIXES, 1);
        ANNOTATION_STRING_2_INDEX.put(ADDED_RULES, 2);
        ANNOTATION_STRING_2_INDEX.put(REMOVED_RULES, 3);
        ANNOTATION_STRING_2_INDEX.put(COMMON, 4);
        ANNOTATION_STRING_2_INDEX.put(HIDDEN, 5);
        HIT_ORIGIN_2_INDEX = new HashMap<String, Integer>();
        HIT_ORIGIN_2_INDEX.put(CURRENT, 0);
        HIT_ORIGIN_2_INDEX.put(BASELINE, 1);
    }

    public RHit(Integer hitSeverity, Integer checkIndex, Integer indexPath, Integer hitLine, String hitDetails, String macroDetails, boolean fixed, boolean isHidden) {
        this.hitSeverity = hitSeverity;
        this.checkIndex = checkIndex;
        this.indexPath = indexPath;
        this.hitLine = hitLine;
        this.hitDetails = hitDetails;
        this.macroDetails = macroDetails;
        this.macroParts = new ArrayList<MacroPathWrapper>();
        this.detailsLinks = new ArrayList<DetailsLinkWrapper>();
        this.annotationStringIndexes = new ArrayList<List<Integer>>();
        this.annotationStringsValues = new ArrayList<List<String>>();
        this.hitSources = new ArrayList<Integer>();
        this.compareAnnotations = new LinkedHashSet<String>();
        this.fixed = fixed;
        this.isHidden = isHidden;
        this.hitIndex = hitCounter++;
        if (isHidden || !fixed) {
            // empty if block
        }
    }

    public RHit(RHit hit) {
        this.hitSeverity = hit.hitSeverity;
        this.checkIndex = hit.checkIndex;
        this.indexPath = hit.indexPath;
        this.file = hit.file;
        this.hitLine = hit.hitLine;
        this.macroParts = new ArrayList<MacroPathWrapper>();
        hit.macroParts.stream().forEach(x -> {
            boolean bl = this.macroParts.add(new MacroPathWrapper(x.macroName, x.index, x.file, x.line));
        });
        this.hitDetails = hit.hitDetails;
        this.detailsLinks = new ArrayList<DetailsLinkWrapper>();
        hit.detailsLinks.stream().forEach(x -> {
            boolean bl = this.detailsLinks.add(new DetailsLinkWrapper(x.offset, x.length, x.index, x.line));
        });
        this.annotationStringIndexes = hit.annotationStringIndexes;
        this.annotationStringsValues = hit.annotationStringsValues;
        this.hitSources = new ArrayList<Integer>();
        hit.hitSources.stream().forEach(x -> {
            boolean bl = this.hitSources.add((Integer)x);
        });
        this.creationDate = hit.creationDate;
        this.compareHitOrigin = hit.compareHitOrigin;
        this.fixed = hit.fixed;
        this.checkName = hit.checkName;
        this.hitIndex = hit.hitIndex;
        this.compareAnnotations = new LinkedHashSet<String>();
        hit.compareAnnotations.stream().forEach(x -> {
            boolean bl = this.compareAnnotations.add((String)x);
        });
        this.compareModifiedStatus = hit.compareModifiedStatus;
        this.isHidden = hit.isHidden;
        this.rEdits = hit.rEdits;
        this.rError = hit.rError;
        this.isHiddenCompare = hit.isHiddenCompare;
    }

    public Integer getHitSeverity() {
        return this.hitSeverity;
    }

    public CheckStatus getSeverity() {
        return CheckStatus.getCheckStatus(this.hitSeverity);
    }

    public Integer getCheckIndex() {
        return this.checkIndex;
    }

    public void setCheckIndex(Integer checkIndex) {
        this.checkIndex = checkIndex;
    }

    public Integer getIndexPath() {
        return this.indexPath;
    }

    public List<Integer> getHitSources() {
        return this.hitSources;
    }

    public void setIndexPath(Integer indexPath) {
        this.indexPath = indexPath;
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public void setHitSources(List<Integer> hitSources) {
        this.hitSources = hitSources;
    }

    public void addHitSources(int hitSource) {
        this.hitSources.add(hitSource);
    }

    public Integer getHitLine() {
        return this.hitLine;
    }

    public String getHitDetails() {
        return this.hitDetails;
    }

    public String getMacroDetails() {
        return this.macroDetails;
    }

    public List<MacroPathWrapper> getMacroParts() {
        return this.macroParts;
    }

    public void addMacroPath(MacroPathWrapper mp) {
        this.macroParts.add(mp);
    }

    public List<DetailsLinkWrapper> getDetailsLinks() {
        return this.detailsLinks;
    }

    public void addDetailsLinkWrapper(DetailsLinkWrapper detailsLink) {
        this.detailsLinks.add(detailsLink);
    }

    public void addCreationDate(long creationDate) {
        this.creationDate = creationDate;
    }

    public long getCreationDate() {
        return this.creationDate;
    }

    public void addCompareAnnotation(String compareAnnotation) {
        this.compareAnnotations.add(compareAnnotation);
    }

    public void addCompareAnnotationBasedOnIndex(Integer annotationIndex) {
        Optional<Map.Entry> foundedAnnotation = ANNOTATION_STRING_2_INDEX.entrySet().parallelStream().filter(entry -> annotationIndex.equals(entry.getValue())).findFirst();
        if (foundedAnnotation.isPresent()) {
            String compareAnnotation = (String)foundedAnnotation.get().getKey();
            this.compareAnnotations.add(compareAnnotation);
        }
    }

    public void setCompareAnnotations(Set<String> compareAnnotations) {
        this.compareAnnotations = compareAnnotations;
    }

    public Set<String> getCompareAnnotations() {
        return this.compareAnnotations;
    }

    public List<Integer> getCompareAnnotationsIndexes() {
        return this.compareAnnotations.stream().map(annotation -> ANNOTATION_STRING_2_INDEX.get(annotation)).collect(Collectors.toList());
    }

    public Integer getCompareModifiedStatus() {
        return this.compareModifiedStatus;
    }

    public void setCompareModifiedStatus(Integer compareModifiedStatus) {
        this.compareModifiedStatus = compareModifiedStatus;
    }

    public List<List<Integer>> getAnnotationStringIndexes() {
        return this.annotationStringIndexes;
    }

    public RHit getSelf() {
        return this;
    }

    public void addAnnotationStringIndex(List<Integer> annotationStringIndex) {
        this.annotationStringIndexes.add(annotationStringIndex);
    }

    public void setAnnotationStringIndex(int listIndex, int annotationIndex, int element) {
        if (listIndex < this.annotationStringIndexes.size()) {
            List<Integer> list = this.annotationStringIndexes.get(listIndex);
            if (annotationIndex < list.size()) {
                list.set(annotationIndex, element);
            } else {
                list.add(element);
            }
        }
    }

    public void initAnnotationStringIndex(int size) {
        this.annotationStringIndexes = new ArrayList<List<Integer>>(size);
        int i = 0;
        while (i < size) {
            this.annotationStringIndexes.add(new ArrayList());
            ++i;
        }
    }

    public List<List<String>> getAnnotationStringsValues() {
        return this.annotationStringsValues;
    }

    public int getHitIndex() {
        return this.hitIndex;
    }

    public void setHitIndex(int hitIndex) {
        this.hitIndex = hitIndex;
    }

    public boolean addAnnotationStringsValues(List<String> element) {
        return this.annotationStringsValues.add(element);
    }

    public static void setHitCounter(int hitCounter) {
        RHit.hitCounter = hitCounter;
    }

    public void clearAnnotationValues() {
        this.annotationStringsValues = new ArrayList<List<String>>();
    }

    public boolean populateAnnotationStringsValues(List<Set<String>> allAnnotationStrings) {
        if (!this.annotationStringsValues.isEmpty()) {
            return true;
        }
        if (allAnnotationStrings == null || this.annotationStringIndexes == null || allAnnotationStrings.size() != this.annotationStringIndexes.size()) {
            return false;
        }
        int i = 0;
        while (i < this.annotationStringIndexes.size()) {
            ArrayList<String> resolvedAnnotationValues = new ArrayList<String>();
            this.annotationStringsValues.add(resolvedAnnotationValues);
            Set<String> annotationStringsSet = allAnnotationStrings.get(i);
            List<Integer> annotationIndexes = this.annotationStringIndexes.get(i);
            if (annotationIndexes != null && annotationStringsSet != null) {
                ArrayList<String> annotationStrings = new ArrayList<String>(annotationStringsSet);
                int j = 0;
                while (j < annotationIndexes.size()) {
                    resolvedAnnotationValues.add((String)annotationStrings.get(annotationIndexes.get(j)));
                    ++j;
                }
            }
            ++i;
        }
        return true;
    }

    public String getCompareHitOrigin() {
        return this.compareHitOrigin;
    }

    public Integer getCompareHitOriginIndex() {
        return HIT_ORIGIN_2_INDEX.get(this.compareHitOrigin);
    }

    public void setCompareHitOrigin(String compareHitOrigin) {
        this.compareHitOrigin = compareHitOrigin;
    }

    public void setCompareHitOriginBasedOnIndex(Integer compareHitOriginIndex) {
        Optional<Map.Entry> foundedHitOrigin = HIT_ORIGIN_2_INDEX.entrySet().parallelStream().filter(entry -> compareHitOriginIndex.equals(entry.getValue())).findFirst();
        if (foundedHitOrigin.isPresent()) {
            String compareHitOrigin;
            this.compareHitOrigin = compareHitOrigin = (String)foundedHitOrigin.get().getKey();
        }
    }

    public boolean isFixed() {
        return this.fixed;
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public boolean isHiddenCompare() {
        return this.isHiddenCompare;
    }

    public void setHiddenCompare(boolean isHiddenCompare) {
        this.isHiddenCompare = isHiddenCompare;
    }

    public String toString() {
        return this.hitDetails;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.file == null ? 0 : this.file.hashCode());
        result = 31 * result + (this.hitDetails == null ? 0 : this.hitDetails.hashCode());
        result = 31 * result + (this.macroDetails == null ? 0 : this.macroDetails.hashCode());
        result = 31 * result + (this.hitLine == null ? 0 : this.hitLine.hashCode());
        result = 31 * result + (this.hitSeverity == null ? 0 : this.hitSeverity.hashCode());
        result = 31 * result + (this.macroParts == null ? 0 : this.macroParts.hashCode());
        result = 31 * result + (this.compareHitOrigin == null ? 0 : this.compareHitOrigin.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RHit other = (RHit)obj;
        if (this.file == null ? other.file != null : !this.file.equals(other.file)) {
            return false;
        }
        if (this.hitDetails == null ? other.hitDetails != null : !this.hitDetails.equals(other.hitDetails)) {
            return false;
        }
        if (this.macroDetails == null ? other.macroDetails != null : !this.macroDetails.equals(other.macroDetails)) {
            return false;
        }
        if (this.hitLine == null ? other.hitLine != null : !this.hitLine.equals(other.hitLine)) {
            return false;
        }
        if (this.compareHitOrigin == null ? other.compareHitOrigin != null : !this.compareHitOrigin.equals(other.compareHitOrigin)) {
            return false;
        }
        if (this.hitSeverity == null ? other.hitSeverity != null : !this.hitSeverity.equals(other.hitSeverity)) {
            return false;
        }
        return !(this.macroParts == null ? other.macroParts != null : !this.macroParts.equals(other.macroParts));
    }

    public boolean hasAutocorrectEdits() {
        return this.rEdits != null && !this.rEdits.isEmpty();
    }

    public List<REdit> getAutocorrectEdits() {
        return this.rEdits;
    }

    public void setAutocorrectEdits(List<REdit> rEdits) {
        this.rEdits = rEdits;
    }

    public boolean hasAutocorrectError() {
        return this.rError != null;
    }

    public RError getAutocorrectError() {
        return this.rError;
    }

    public void setAutocorrectError(RError rError) {
        this.rError = rError;
    }

    public void setCheckName(String checkName) {
        this.checkName = checkName;
    }

    public String getCheckName() {
        return this.checkName;
    }

    public static class DetailsLinkWrapper {
        private int offset;
        private int length;
        private int index;
        private String line;

        public DetailsLinkWrapper(int offset, int length, int index, String line) {
            this.offset = offset;
            this.length = length;
            this.index = index;
            this.line = line;
        }

        public int getOffset() {
            return this.offset;
        }

        public int getLength() {
            return this.length;
        }

        public int getIndex() {
            return this.index;
        }

        public String getLine() {
            return this.line;
        }

        public void setIndex(int index) {
            this.index = index;
        }
    }

    public static class MacroPathWrapper {
        private String macroName;
        private int index;
        private String file;
        private String line;

        public MacroPathWrapper(String macroName, int index, String file, String line) {
            this.macroName = macroName;
            this.index = index;
            this.file = file;
            this.line = line;
        }

        public String getMacroName() {
            return this.macroName;
        }

        public int getIndex() {
            return this.index;
        }

        public String getFile() {
            return this.file;
        }

        public String getLine() {
            return this.line;
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.file == null ? 0 : this.file.hashCode());
            result = 31 * result + (this.line == null ? 0 : this.line.hashCode());
            result = 31 * result + (this.macroName == null ? 0 : this.macroName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MacroPathWrapper other = (MacroPathWrapper)obj;
            if (this.file == null ? other.file != null : !this.file.equals(other.file)) {
                return false;
            }
            if (this.line == null ? other.line != null : !this.line.equals(other.line)) {
                return false;
            }
            return !(this.macroName == null ? other.macroName != null : !this.macroName.equals(other.macroName));
        }
    }
}

