/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.report.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RInfo {
    private String UUID;
    private String version;
    private String userName;
    private String date;
    private String commiterDate;
    private String ruleSet;
    private String project;
    private List<String> commonSegmentsInfo;
    private String dataFilesSize;
    private boolean hasEffortEstimation;
    private int nofCompiledLines;
    private Map<String, Integer> nofCompiledLinesPerFile;
    private long lintRunTime;
    private long buildRunTime;
    private long licenseWaitTime;
    private boolean timedOutSession;
    private boolean timedOutChecks;
    private boolean isCompareReport;
    private String baselineReportUUID;
    private String currentReportUUID;
    private boolean includeCreationDate;
    private boolean hasCompilationErrors;

    public RInfo() {
    }

    public RInfo(RInfo info) {
        this.UUID = info.UUID;
        this.version = info.version;
        this.userName = info.userName;
        this.date = info.date;
        this.commiterDate = info.commiterDate;
        this.ruleSet = info.ruleSet;
        this.project = info.project;
        this.commonSegmentsInfo = info.commonSegmentsInfo;
        this.dataFilesSize = info.dataFilesSize;
        this.hasEffortEstimation = info.hasEffortEstimation;
        this.nofCompiledLines = info.nofCompiledLines;
        this.nofCompiledLinesPerFile = info.nofCompiledLinesPerFile;
        this.lintRunTime = info.lintRunTime;
        this.buildRunTime = info.buildRunTime;
        this.licenseWaitTime = info.licenseWaitTime;
        this.timedOutSession = info.timedOutSession;
        this.timedOutChecks = info.timedOutChecks;
        this.isCompareReport = info.isCompareReport;
        this.baselineReportUUID = info.baselineReportUUID;
        this.currentReportUUID = info.currentReportUUID;
        this.includeCreationDate = info.includeCreationDate;
        this.hasCompilationErrors = info.hasCompilationErrors;
    }

    public void setUUID(String value) {
        this.UUID = value;
    }

    public String getUUID() {
        return this.UUID;
    }

    public String getBaselineReportUUID() {
        return this.baselineReportUUID != null ? this.baselineReportUUID : "";
    }

    public String getCurrentReportUUID() {
        return this.currentReportUUID != null ? this.currentReportUUID : "";
    }

    public void setBaselineReportUUID(String baselineReportUUID) {
        this.baselineReportUUID = baselineReportUUID;
    }

    public void setCurrentReportUUID(String currentReportUUID) {
        this.currentReportUUID = currentReportUUID;
    }

    public String getVersion() {
        return this.version;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getDate() {
        return this.date;
    }

    public void setCommiterDate(String commiterDate) {
        this.commiterDate = commiterDate == null ? "" : commiterDate;
    }

    public String getCommiterDate() {
        return this.commiterDate;
    }

    public String getRuleSet() {
        return this.ruleSet;
    }

    public String getProject() {
        return this.project;
    }

    public List<String> getCommonSegmentsInfo() {
        return this.commonSegmentsInfo;
    }

    public void setCommonSegmentsInfo(List<String> commonSegmentsInfo) {
        this.commonSegmentsInfo = commonSegmentsInfo;
    }

    public String getDataFilesSize() {
        return this.dataFilesSize;
    }

    public void setDataFilesSize(String dataFilesSize) {
        this.dataFilesSize = dataFilesSize;
    }

    public boolean hasEffortEstimation() {
        return this.hasEffortEstimation;
    }

    public void setHasEffortEstimation(boolean hasEffortEstimation) {
        this.hasEffortEstimation = hasEffortEstimation;
    }

    public int getNofCompiledLines() {
        return this.nofCompiledLines;
    }

    public void setNofCompiledLines(int nofCompiledLines) {
        this.nofCompiledLines = nofCompiledLines;
    }

    public Map<String, Integer> getNofCompiledLinesPerFile() {
        return this.nofCompiledLinesPerFile;
    }

    public void setNofCompiledLinesPerFile(Map<String, Integer> nofCompiledLinesPerFile) {
        this.nofCompiledLinesPerFile = nofCompiledLinesPerFile;
    }

    public long getLintRunTime() {
        return this.lintRunTime;
    }

    public void setLintRunTime(long lintRunTime) {
        this.lintRunTime = lintRunTime;
    }

    public long getBuildRunTime() {
        return this.buildRunTime;
    }

    public void setBuildRunTime(long buildRunTime) {
        this.buildRunTime = buildRunTime;
    }

    public long getLicenseWaitTime() {
        return this.licenseWaitTime;
    }

    public void setLicenseWaitTime(long licenseWaitTime) {
        this.licenseWaitTime = licenseWaitTime;
    }

    public boolean isTimedOutSession() {
        return this.timedOutSession;
    }

    public void setTimedOutSession(boolean timedOutSession) {
        this.timedOutSession = timedOutSession;
    }

    public boolean isTimedOutChecks() {
        return this.timedOutChecks;
    }

    public void setTimedOutChecks(boolean timedOutCheck) {
        this.timedOutChecks = timedOutCheck;
    }

    public boolean isCompareReport() {
        return this.isCompareReport;
    }

    public void setCompareReport(boolean isCompareReport) {
        this.isCompareReport = isCompareReport;
    }

    public boolean setIncludeCreationDate() {
        return this.includeCreationDate;
    }

    public void includeCreationDate(boolean hasCreationDate) {
        this.includeCreationDate = hasCreationDate;
    }

    public void setCompilationErrors(boolean hasCompilationErrors) {
        this.hasCompilationErrors = hasCompilationErrors;
    }

    public boolean hasCompilationErrors() {
        return this.hasCompilationErrors;
    }

    public static class Builder {
        private static String UNDEFINED = "undefined";
        private RInfo infoWrapper = new RInfo();

        public Builder withUUID(String UUID2) {
            this.infoWrapper.UUID = UUID2 == null ? UNDEFINED : UUID2;
            return this;
        }

        public Builder withVersion(String version) {
            this.infoWrapper.version = version == null ? UNDEFINED : version;
            return this;
        }

        public Builder withUserName(String userName) {
            this.infoWrapper.userName = userName == null ? UNDEFINED : userName;
            return this;
        }

        public Builder withDate(String date) {
            this.infoWrapper.date = date == null ? UNDEFINED : date;
            return this;
        }

        public Builder withCommiterDate(String commiterDate) {
            this.infoWrapper.commiterDate = commiterDate == null ? UNDEFINED : commiterDate;
            return this;
        }

        public Builder withRuleSet(String ruleSet) {
            this.infoWrapper.ruleSet = ruleSet == null ? UNDEFINED : ruleSet;
            return this;
        }

        public Builder withProject(String project) {
            this.infoWrapper.project = project == null ? UNDEFINED : project;
            return this;
        }

        public Builder withCommonSegmentsInfo(List<String> commonSegmentsInfo) {
            this.infoWrapper.commonSegmentsInfo = new ArrayList<String>(commonSegmentsInfo == null ? Arrays.asList(UNDEFINED) : commonSegmentsInfo);
            return this;
        }

        public Builder withDataFilesSize(String dataFilesSize) {
            this.infoWrapper.dataFilesSize = dataFilesSize == null ? UNDEFINED : dataFilesSize;
            return this;
        }

        public Builder withEffortEstimation(String hasEffortEstimation) {
            this.infoWrapper.hasEffortEstimation = hasEffortEstimation == null ? false : Boolean.parseBoolean(hasEffortEstimation);
            return this;
        }

        public Builder withNofCompiledLines(int nofCompiledLines) {
            this.infoWrapper.nofCompiledLines = nofCompiledLines;
            return this;
        }

        public Builder withNofCompiledLinesPerFile(Map<String, Integer> nofCompiledLinesPerFile) {
            this.infoWrapper.nofCompiledLinesPerFile = nofCompiledLinesPerFile != null ? nofCompiledLinesPerFile : new HashMap();
            return this;
        }

        public Builder withLintRunTime(long lintRunTime) {
            this.infoWrapper.lintRunTime = lintRunTime;
            return this;
        }

        public Builder withBuildRunTime(long buildRunTime) {
            this.infoWrapper.buildRunTime = buildRunTime;
            return this;
        }

        public Builder withLicenseWaitTime(long licenseWaitTime) {
            this.infoWrapper.licenseWaitTime = licenseWaitTime;
            return this;
        }

        public Builder withTimedOutSession(boolean timedOutSession) {
            this.infoWrapper.timedOutSession = timedOutSession;
            return this;
        }

        public Builder withTimedOutChecks(boolean timedOutCheck) {
            this.infoWrapper.timedOutChecks = timedOutCheck;
            return this;
        }

        public Builder withIsCompareReport(boolean isCompareReport) {
            this.infoWrapper.isCompareReport = isCompareReport;
            return this;
        }

        public Builder withCreationDate(boolean includeCreationDate) {
            this.infoWrapper.includeCreationDate = includeCreationDate;
            return this;
        }

        public Builder withCompilationErrors(boolean compilationErrors) {
            this.infoWrapper.hasCompilationErrors = compilationErrors;
            return this;
        }

        public RInfo build() {
            return this.infoWrapper;
        }
    }
}

