/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.report.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.mutable.MutableInt;
import org.eclipse.core.runtime.IPath;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vlogdt.linter.annotations.AnnotationResults;
import ro.amiq.vlogdt.linter.annotations.AnnotationType;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.report.model.RCategory;
import ro.amiq.vlogdt.linter.report.model.RCheck;
import ro.amiq.vlogdt.linter.report.model.RHit;
import ro.amiq.vlogdt.linter.report.model.RInfo;
import ro.amiq.vlogdt.linter.report.model.RPreWaiver;
import ro.amiq.vlogdt.linter.report.model.RWaiver;
import ro.amiq.vlogdt.linter.ruleset.RulesetKind;

public class RReport {
    private RInfo infoWrapper;
    private List<RCategory> categories;
    private List<RCheck> checks;
    private List<RuleLabel> labels;
    private List<RHit> hits;
    private Set<String> files;
    private List<AnnotationResults.AnnotationInfo> annotationInfos;
    private List<Set<String>> annotationStrings;
    private List<RWaiver> postWaivers;
    private List<RPreWaiver> preWaivers;
    private String buildFile;
    private String waiversFile;
    private RulesetKind rulesetKind;
    private String rulesetFile;
    private LinkedHashMap<String, String> allFilesHashesMap;
    private LinkedHashMap<String, String> allBaselineFilesHashesMap;
    private LinkedHashMap<String, String> allFilesWithBaselineFilesMap;
    private Set<String> allImportedFilesSet;
    private String baselineReportLocation;
    private List<String> infoKeyValues;
    private Map<Integer, String> sourcesLocations;
    private int maxSourcesLocationsIndex;
    private String location;
    private Map<IPath, Integer> paths;
    private MutableInt commonSegments;
    private LinkedHashMap<String, Set<RCheck>> preWaivedFilesForChecksMap;

    public RReport() {
        this.infoWrapper = new RInfo();
        this.categories = new ArrayList<RCategory>();
        this.checks = new ArrayList<RCheck>();
        this.labels = new ArrayList<RuleLabel>();
        this.hits = new LinkedList<RHit>();
        this.files = new LinkedHashSet<String>();
        this.sourcesLocations = new HashMap<Integer, String>();
        this.allFilesHashesMap = new LinkedHashMap();
        this.allBaselineFilesHashesMap = new LinkedHashMap();
        this.allFilesWithBaselineFilesMap = new LinkedHashMap();
        this.paths = new LinkedHashMap<IPath, Integer>();
        this.commonSegments = new MutableInt(0);
        this.preWaivedFilesForChecksMap = new LinkedHashMap();
        this.allImportedFilesSet = new LinkedHashSet<String>();
    }

    public RReport(RReport report) {
        this.buildFile = report.buildFile;
        this.waiversFile = report.waiversFile;
        this.baselineReportLocation = report.baselineReportLocation;
        this.maxSourcesLocationsIndex = report.maxSourcesLocationsIndex;
        this.location = report.location;
        this.commonSegments = new MutableInt((Number)report.commonSegments);
        this.rulesetKind = report.rulesetKind;
        this.files = new LinkedHashSet<String>();
        report.files.stream().forEach(x -> {
            boolean bl = this.files.add((String)x);
        });
        this.allImportedFilesSet = new LinkedHashSet<String>();
        report.allImportedFilesSet.stream().forEach(x -> {
            boolean bl = this.allImportedFilesSet.add((String)x);
        });
        this.allFilesHashesMap = new LinkedHashMap();
        report.allFilesHashesMap.entrySet().stream().forEach(x -> {
            String string = this.allFilesHashesMap.put((String)x.getKey(), (String)x.getValue());
        });
        this.allBaselineFilesHashesMap = new LinkedHashMap();
        report.allBaselineFilesHashesMap.entrySet().stream().forEach(x -> {
            String string = this.allBaselineFilesHashesMap.put((String)x.getKey(), (String)x.getValue());
        });
        this.allFilesWithBaselineFilesMap = new LinkedHashMap();
        report.allFilesWithBaselineFilesMap.entrySet().stream().forEach(x -> {
            String string = this.allFilesWithBaselineFilesMap.put((String)x.getKey(), (String)x.getValue());
        });
        this.paths = new LinkedHashMap<IPath, Integer>();
        report.paths.entrySet().stream().forEach(x -> {
            Integer n = this.paths.put((IPath)x.getKey(), (Integer)x.getValue());
        });
        this.labels = new ArrayList<RuleLabel>();
        report.labels.stream().forEach(x -> {
            boolean bl = this.labels.add((RuleLabel)((Object)x));
        });
        this.infoWrapper = new RInfo(report.infoWrapper);
        this.categories = new ArrayList<RCategory>();
        report.categories.stream().forEach(x -> {
            boolean bl = this.categories.add(new RCategory((RCategory)x));
        });
        this.checks = new ArrayList<RCheck>();
        this.categories.stream().forEach(x -> {
            boolean bl = this.checks.addAll(x.getChecks());
        });
        this.hits = new LinkedList<RHit>();
        report.hits.stream().forEach(x -> {
            boolean bl = this.hits.add(new RHit((RHit)x));
        });
        this.sourcesLocations = report.sourcesLocations;
        this.infoKeyValues = report.infoKeyValues;
        this.annotationInfos = report.annotationInfos;
        this.annotationStrings = report.annotationStrings;
        this.preWaivedFilesForChecksMap = report.preWaivedFilesForChecksMap;
        this.preWaivers = report.preWaivers;
        this.postWaivers = report.postWaivers;
    }

    public String getCheckNameFromHit(RHit hit) {
        String checkName = "";
        if (!this.checks.isEmpty()) {
            RCheck rCheck = this.checks.get(hit.getCheckIndex());
            checkName = rCheck.getCheckName();
        }
        return checkName;
    }

    public Set<String> getAllImportedFiles() {
        if (this.allImportedFilesSet.isEmpty()) {
            this.allImportedFilesSet.addAll(this.allFilesHashesMap.keySet());
        }
        return this.allImportedFilesSet;
    }

    public LinkedHashMap<String, String> getAllFilesHashesMap() {
        return this.allFilesHashesMap;
    }

    public LinkedHashMap<String, String> getAllBaselineFilesHashesMap() {
        return this.allBaselineFilesHashesMap;
    }

    public LinkedHashMap<String, String> getAllFilesWithBaselineFilesMap() {
        return this.allFilesWithBaselineFilesMap;
    }

    public void putFileHash(String filename, byte[] md5) {
        if (md5 == null) {
            this.allFilesHashesMap.putIfAbsent(filename, "NULLHASH");
        } else {
            this.allFilesHashesMap.put(filename, DVTStringUtil.bytes2hex((byte[])md5).toUpperCase());
        }
    }

    public void putFileHash(String filename, String hash) {
        if (hash.equals("NULLHASH")) {
            this.allFilesHashesMap.putIfAbsent(filename, "NULLHASH");
        } else {
            this.allFilesHashesMap.put(filename, hash);
        }
    }

    public void setAllFilesHashesMap(LinkedHashMap<String, String> allFilesHashesMap) {
        this.allFilesHashesMap = allFilesHashesMap;
    }

    public void setAllBaselineFilesHashesMap(LinkedHashMap<String, String> allBaselineFilesHashesMap) {
        this.allBaselineFilesHashesMap = allBaselineFilesHashesMap;
    }

    public void setAllFilesWithBaselineFilesMap(LinkedHashMap<String, String> allBaselineOriginFilesHashesMap) {
        this.allFilesWithBaselineFilesMap = allBaselineOriginFilesHashesMap;
    }

    public RInfo getInfoWrapper() {
        return this.infoWrapper;
    }

    public void setInfoWrapper(RInfo infoWrapper) {
        this.infoWrapper = infoWrapper;
    }

    public List<RCategory> getCategories() {
        return this.categories;
    }

    public boolean addCategory(RCategory category) {
        return this.categories.add(category);
    }

    public void setCategories(List<RCategory> categories) {
        this.categories = categories;
    }

    public List<RCheck> getChecks() {
        return this.checks;
    }

    public boolean addCheck(RCheck check) {
        return this.checks.add(check);
    }

    public void setChecks(List<RCheck> checks) {
        this.checks = checks;
    }

    public List<RHit> getHits() {
        return this.hits;
    }

    public void appendHits(List<RHit> hits) {
        this.hits.addAll(hits);
    }

    public void addHit(RHit hit) {
        this.hits.add(hit);
    }

    public Set<String> getFiles() {
        return this.files;
    }

    public void setFiles(Set<String> files) {
        this.files = files;
    }

    public List<AnnotationResults.AnnotationInfo> getAnnotationInfos() {
        return this.annotationInfos;
    }

    public void addAnnotationInfo(String title, Set<Integer> location, int type) {
        this.annotationInfos.add(new AnnotationResults.AnnotationInfo(title, location, type));
    }

    public void setAnnotationInfos(List<AnnotationResults.AnnotationInfo> annotationInfos) {
        this.annotationInfos = annotationInfos;
    }

    public List<Set<String>> getAnnotationStrings() {
        return this.annotationStrings;
    }

    public void addAnnotationString(Set<String> annotationString) {
        this.annotationStrings.add(annotationString);
    }

    public void setAnnotationStrings(List<Set<String>> annotationStrings) {
        this.annotationStrings = annotationStrings;
    }

    public Map<Integer, String> getSourcesLocations() {
        return this.sourcesLocations;
    }

    public void addSourceLocation(int index, String location) {
        this.sourcesLocations.put(index, location);
    }

    public void setSourcesLocations(Map<Integer, String> sourcesLocations) {
        this.sourcesLocations = sourcesLocations;
    }

    public int getMaxSourceCode() {
        return this.maxSourcesLocationsIndex;
    }

    public void setMaxSourceCode(int maxSourceCode) {
        this.maxSourcesLocationsIndex = maxSourceCode;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public List<String> getInfoKeyValues() {
        return this.infoKeyValues;
    }

    public void setInfoKeyValues(List<String> infoKeyValues) {
        this.infoKeyValues = infoKeyValues;
    }

    public Map<IPath, Integer> getPaths() {
        return this.paths;
    }

    public void setPaths(Map<IPath, Integer> paths) {
        this.paths = paths;
    }

    public MutableInt getCommonSegments() {
        return this.commonSegments;
    }

    public void setCommonSegments(MutableInt commonSegments) {
        this.commonSegments = commonSegments;
    }

    public void putFilePrewaivedFilesForChecks(String key, Set<RCheck> value) {
        this.preWaivedFilesForChecksMap.put(key, value);
    }

    public void setPrewaivedFilesForChecks(LinkedHashMap<String, Set<RCheck>> preWaivedFilesToCheckMap) {
        this.preWaivedFilesForChecksMap = preWaivedFilesToCheckMap;
    }

    public LinkedHashMap<String, Set<RCheck>> getPrewaivedFilesForChecks() {
        return this.preWaivedFilesForChecksMap;
    }

    public void setPostWaivers(List<RWaiver> postWaivers) {
        this.postWaivers = postWaivers;
    }

    public List<RWaiver> getPostWaivers() {
        return this.postWaivers;
    }

    public void setPreWaivers(List<RPreWaiver> preWaivers) {
        this.preWaivers = preWaivers;
    }

    public List<RPreWaiver> getPreWaivers() {
        return this.preWaivers;
    }

    public String getBuildFile() {
        return this.buildFile;
    }

    public void setBuildFile(String buildFile) {
        this.buildFile = buildFile;
    }

    public String getWaiversFile() {
        return this.waiversFile;
    }

    public void setWaiversFile(String waiversFile) {
        this.waiversFile = waiversFile;
    }

    public String getRulesetFile() {
        return this.rulesetFile;
    }

    public void setRulesetFile(String rulesetFile) {
        this.rulesetFile = rulesetFile;
    }

    public RulesetKind getRulesetKind() {
        return this.rulesetKind;
    }

    public void setRulesetKind(RulesetKind rulesetKind) {
        this.rulesetKind = rulesetKind;
    }

    public String getBaselineReportLocation() {
        return this.baselineReportLocation;
    }

    public void setBaselineReportLocation(String baselineReportLocation) {
        this.baselineReportLocation = baselineReportLocation;
    }

    public List<RuleLabel> getLabels() {
        return this.labels;
    }

    public void setLabels(List<RuleLabel> labels) {
        this.labels = labels;
    }

    public List<RuleLabel> getLabelsFromAnnotation() {
        int i = 0;
        while (i < this.annotationInfos.size()) {
            if (this.annotationInfos.get(i).getType() == AnnotationType.LABEL.ordinal()) {
                return this.annotationStrings.get(i).stream().map(x -> RuleLabel.valueOfString(x)).collect(Collectors.toList());
            }
            ++i;
        }
        return new LinkedList<RuleLabel>();
    }
}

