/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.linter.utils.OVMUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.parser.ReparseInfo;

public abstract class AbstractAnalysisPortCheck
extends OVMComplianceCheck {
    protected RfClass portBaseClass;
    protected String declarationMacroName;

    protected AbstractAnalysisPortCheck(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        String portBaseName = String.valueOf(OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_pkg::")) + OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_port_base");
        this.portBaseClass = this.fOVMProject.getRfProject().getClass(portBaseName, true);
        this.declarationMacroName = OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_analysis_imp_decl");
        if (this.fOVMProject.fOvmScoreboard == null || this.portBaseClass == null) {
            return;
        }
        Set<RfClass> classes = this.getClasses();
        if (classes == null || classes.isEmpty()) {
            return;
        }
        for (RfClass clazz : classes) {
            if (clazz.getDeclaration() != null && this.checkPreWaivers(clazz.getDeclaration().getParserPath())) continue;
            this.notifyCheckAlive();
            this.analyzeClass(clazz);
        }
    }

    protected boolean checkFieldTypeIsValid(RfClass type) {
        RfDefElement declaration = type.getDeclaration();
        if (declaration == null) {
            return false;
        }
        ReparseInfo reparseInfo = declaration.getReparseInfo();
        if (reparseInfo == null) {
            return false;
        }
        ReparseInfo.ReparseElement[] reparseStack = reparseInfo.getReparseStack();
        if (reparseStack == null || reparseStack.length == 0) {
            return false;
        }
        ReparseInfo.ReparseElement[] reparseElementArray = reparseStack;
        int n = reparseStack.length;
        int n2 = 0;
        while (n2 < n) {
            ReparseInfo.ReparseElement element = reparseElementArray[n2];
            if (this.declarationMacroName.equals(element.getReparseMacroName())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected Map<RfField, RfClass> getAnalysisImplementations(RfClass clazz) {
        HashMap<RfField, RfClass> fields = new HashMap<RfField, RfClass>();
        List<RfField> localFields = clazz.getLocalFields();
        if (localFields == null) {
            return fields;
        }
        for (RfField field : localFields) {
            RfClass fieldType = LintUtils.getFieldFinalClassTypeOrNull(field);
            if (fieldType == null || !LintUtils.isSubClassOf(fieldType, this.portBaseClass)) continue;
            fields.put(field, fieldType);
        }
        return fields;
    }

    protected boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    protected abstract Set<RfClass> getClasses();

    protected abstract void analyzeClass(RfClass var1);
}

