/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import ro.amiq.dvt.elaboration.ELConstants;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.elaboration.core.ELSpecializationWrapper;
import ro.amiq.dvt.elaboration.model.ELParamValueScope;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.elaboration.model.ELParamValuesHidEvaluator;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.interpreter.XUtils;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.RfMixedLangProject;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluationGuardian;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.utils.DVTNumber;
import ro.amiq.dvt.utils.VlogBitVector;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfAbstractBlock;
import ro.amiq.vlogdt.model.reflection.RfAssertExpect;
import ro.amiq.vlogdt.model.reflection.RfAssociatedType;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfGenerateBlock;
import ro.amiq.vlogdt.model.reflection.RfListType;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfStruct;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;

public abstract class AbstractBoundsCheck
extends OVMComplianceCheck {
    private static final Pattern GENERATE_BLOCK_PATH_SEPARATOR = Pattern.compile(", ");
    @CheckParameter(defaultValue="false", description="When true, selects guarded by conditionals on the select variable are skipped.", name="skipGuardedSelects", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pSkipGuardedSelects;
    @CheckParameter(defaultValue="false", description="When true, selects done with variables are skipped. Only parameters and literals used for selects will be checked.", name="skipVariablesInSelects", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    protected boolean pSkipVariablesInSelects;
    @CheckParameter(defaultValue="false", description="When true, selects inside inactive generate blocks will be skipped.", name="skipInactiveGenerateBlocks", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pSkipInactiveGenerateBlocks;

    protected AbstractBoundsCheck(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        RfProject rfProject = this.fOVMProject.getRfProject();
        final HashMap checkedHidsMap = new HashMap();
        if (this.pSkipGuardedSelects) {
            HidOperatorVisitor conditionalTernaryVisitor = new HidOperatorVisitor(null){

                public boolean visit(HidOperator conditionalTernaryOperator) {
                    if (!conditionalTernaryOperator.isConditionalTernary()) {
                        return true;
                    }
                    if (AbstractBoundsCheck.this.checkPreWaivers(this.parserPath)) {
                        return true;
                    }
                    AbstractBoundsCheck.this.notifyCheckAlive();
                    if (checkedHidsMap.get(this.parserPath) == null) {
                        checkedHidsMap.put(this.parserPath, new HashMap());
                    }
                    Map variableToGuardedSelects = (Map)checkedHidsMap.get(this.parserPath);
                    ArrayList conditionalHids = new ArrayList();
                    Predicate<IHidObject> cons = element -> {
                        if (!(element instanceof RfHidOperator)) {
                            conditionalHids.add(element);
                        }
                        return true;
                    };
                    IHidObject lhValue = conditionalTernaryOperator.getLHValue();
                    HidUtils.flattenToObjects(cons, (IHidObject)lhValue, EnumSet.of(HidFlatteningOption.IGNORE_METHOD_CALLS, HidFlatteningOption.IGNORE_OBJECTS_IN_SELECTS));
                    for (IHid rhHid : conditionalTernaryOperator.getRHHids(EnumSet.of(HidFlatteningOption.IGNORE_IMPLICITS))) {
                        List selects;
                        ListContainer accesses;
                        if (!(rhHid instanceof RfHid) || (accesses = ((RfHid)rhHid).getAccesses()) == null || accesses.isEmpty() || (selects = ((HidAccess)accesses.get(0)).getSelects()) == null) continue;
                        ArrayList<IHidObject> guardedSelects = new ArrayList<IHidObject>();
                        for (IHidObject select : selects) {
                            if (!conditionalHids.contains(select)) continue;
                            guardedSelects.add(select);
                        }
                        if (guardedSelects.isEmpty()) continue;
                        variableToGuardedSelects.put(rhHid.getOccurrence(), guardedSelects);
                    }
                    return true;
                }
            };
            rfProject.visitHidObject(rfProject, (IHidVisitor<?>)conditionalTernaryVisitor);
        }
        final ELManager manager = rfProject.getELManager();
        final ELParamValuesHidEvaluator emptyEvaluator = ELParamValues.EMPTY.getHidEvaluator(manager);
        RfMixedLangProject mixedLangProject = rfProject.getMixedLangProjectParent();
        final Map specsPerElement = mixedLangProject.getLinterElabSpecs();
        RfHidVisitor hidVisitor = new RfHidVisitor(){
            private IRfNamedElement scope;

            @Override
            public void setHolder(IHidHolder holder) {
                if (holder instanceof RfHidHolder) {
                    this.scope = ((RfHidHolder)holder).getScope();
                }
            }

            public boolean visit(RfHid hid) {
                RfGenerateBlock generateBlockScope;
                if (AbstractBoundsCheck.this.checkPreWaivers(this.parserPath)) {
                    return true;
                }
                AbstractBoundsCheck.this.notifyCheckAlive();
                ListContainer accesses = hid.getAccesses();
                if (accesses == null || accesses.get(0) == null || ((HidAccess)accesses.get(0)).getSelects() == null) {
                    return true;
                }
                ArrayList<IHidObject> selects = new ArrayList<IHidObject>(((HidAccess)accesses.get(0)).getSelects());
                if (selects.isEmpty()) {
                    return true;
                }
                IRfNamedElement arrayElement = hid.getElement();
                if (arrayElement == null || !(arrayElement instanceof RfField)) {
                    return true;
                }
                RfNamedElement arrayElementType = LintUtils.getAssociatedFinalType((RfField)arrayElement);
                if (arrayElementType != null && "string".equals(arrayElementType.getName())) {
                    return true;
                }
                if (AbstractBoundsCheck.this.pSkipGuardedSelects) {
                    Map variableToGuardedSelects = (Map)checkedHidsMap.get(this.parserPath);
                    if (variableToGuardedSelects == null || variableToGuardedSelects.isEmpty()) {
                        return true;
                    }
                    List guardedSelects = (List)variableToGuardedSelects.get(hid.getOccurrence());
                    if (guardedSelects != null && !guardedSelects.isEmpty()) {
                        selects.removeAll(guardedSelects);
                    }
                    if (selects.isEmpty()) {
                        return true;
                    }
                    IRfNamedElement scopeaux = this.scope;
                    while (scopeaux != null) {
                        if (scopeaux instanceof RfAssertExpect ? AbstractBoundsCheck.this.hasAllSelectsGuarded(((RfAssertExpect)scopeaux).getExpression(), selects) : scopeaux instanceof RfAbstractBlock && ((RfAbstractBlock)scopeaux).isConditionalWithExpression() && AbstractBoundsCheck.this.hasAllSelectsGuarded((IHidObject)((ListContainer)((RfAbstractBlock)scopeaux).getHidHolder().getHidObjectsMap().get(this.parserPath)).get(0), selects)) {
                            return true;
                        }
                        scopeaux = (IRfNamedElement)scopeaux.getEnclosingScope();
                    }
                    if (selects.isEmpty()) {
                        return true;
                    }
                }
                String[] generateBlockPath = null;
                if (this.scope != null && this.scope instanceof RfGenerateBlock && ((generateBlockScope = (RfGenerateBlock)this.scope).isIfGenerate() || generateBlockScope.isElseGenerate() || generateBlockScope.isCaseItemGenerate() || generateBlockScope.isCaseOthersGenerate())) {
                    Map.Entry entry;
                    ELSpecializationWrapper generateBlockWrapper;
                    Map generateBlock = (Map)specsPerElement.get(this.scope);
                    if (generateBlock != null && !generateBlock.isEmpty() && (generateBlockWrapper = (ELSpecializationWrapper)(entry = generateBlock.entrySet().iterator().next()).getKey()) != null) {
                        generateBlockPath = GENERATE_BLOCK_PATH_SEPARATOR.split(generateBlockWrapper.getPathsText());
                    }
                    if (AbstractBoundsCheck.this.pSkipInactiveGenerateBlocks && generateBlockPath == null) {
                        return true;
                    }
                }
                AbstractBoundsCheck.this.checkBounds(hid, this.scope, selects, arrayElement, manager, emptyEvaluator, specsPerElement, generateBlockPath, this.parserPath);
                return true;
            }
        };
        rfProject.visitHidObject(rfProject, hidVisitor);
    }

    protected abstract void checkBounds(RfHid var1, IRfNamedElement var2, List<IHidObject> var3, IRfNamedElement var4, ELManager var5, ELParamValuesHidEvaluator var6, Map<IRfNamedElement, Map<ELSpecializationWrapper, ELSpecializationWrapper>> var7, String[] var8, ParserPath var9);

    protected void checkDimensions(RfHid hid, IRfNamedElement arrayElement, ELManager elManager, ELParamValuesHidEvaluator evaluator, int i, IHidObject currentSelect, int smallDimension, int bigDimension, ParserPath parserPath, String paths, IRfNamedElement scope) {
        if (smallDimension > bigDimension) {
            int aux = smallDimension;
            smallDimension = bigDimension;
            bigDimension = aux;
        }
        if (currentSelect instanceof RfHid) {
            String type;
            RfNamedElement assocType;
            RfHid select = (RfHid)currentSelect;
            IRfNamedElement counterElement = select.getElement();
            if (!(counterElement instanceof RfField)) {
                return;
            }
            if (ELUtils.isVLOGConstant((IRfNamedElement)counterElement)) {
                IHidEvaluationGuardian guardianForEval = ELUtils.getEvalGuardian((ELConstants.EvalExceptionZone)ELConstants.EvalExceptionZone.RANGE, (IRfNamedElement)counterElement, null, (boolean)false, (ELManager)elManager);
                guardianForEval.updateElements(arrayElement, scope);
                IELParamValue value = XUtils.getValue((ELParamValueScope)ELUtils.evaluate((IHidObject)select, (IHidEvaluator)evaluator, null, (IHidEvaluationGuardian)guardianForEval));
                if (!ELUtils.isUnsuccessfulEval((IELParamValue)value) && value instanceof ELParamValues.ParamValueNumber) {
                    if (value.intValue() > bigDimension || value.intValue() < smallDimension) {
                        this.addHit(parserPath, hid, "Size " + (i + 1) + " of array '" + LintUtils.getNamedElementFullName((RfNamedElement)arrayElement) + "' has range " + smallDimension + " : " + bigDimension + ", but " + counterElement.getName() + " value is " + value.intValue() + "!" + (paths != null ? "\nHierarchy Paths: " + paths : ""));
                    }
                    return;
                }
            }
            if ((assocType = LintUtils.getAssociatedFinalType((RfAssociatedType)counterElement)) == null) {
                return;
            }
            if (assocType instanceof RfStruct && ((RfStruct)assocType).isEnum()) {
                assocType = ((RfStruct)assocType).getEnumBaseType();
            }
            if (assocType instanceof RfListType) {
                assocType = ((RfListType)assocType).getAssociatedBaseType();
            }
            if (!((type = assocType.getName()).equals("bit") || type.equals("logic") || type.equals("reg"))) {
                return;
            }
            int maxValueOfCounter = (int)Math.pow(2.0, this.getMaxSize((IHidObject)select, counterElement, elManager, evaluator, scope)) - 1;
            if (maxValueOfCounter == -1) {
                return;
            }
            if (maxValueOfCounter > bigDimension || smallDimension > 0) {
                this.addHit(parserPath, hid, "Size " + (i + 1) + " of array '" + LintUtils.getNamedElementFullName((RfNamedElement)arrayElement) + "' has range " + smallDimension + " : " + bigDimension + ", but index '" + select.getName() + "' can have " + (maxValueOfCounter + 1) + " values!" + (paths != null ? "\nHierarchy Paths: " + paths : ""));
            }
        } else if (currentSelect instanceof RfHidImplicit && ((RfHidImplicit)currentSelect).isNumber()) {
            RfHidImplicit select = (RfHidImplicit)currentSelect;
            ELParamValueScope numberSelect = ELUtils.evaluate((IHidObject)select, (IHidEvaluator)new IHidEvaluator.NullHidEvaluator(), null, (IHidEvaluationGuardian)IHidEvaluationGuardian.DUMMY_EVAL_GUARDIAN);
            if (ELUtils.isUnsuccessfulEval((ELParamValueScope)numberSelect)) {
                return;
            }
            DVTNumber numberForSize2 = numberSelect.getDVTNumber();
            if (!(numberForSize2 instanceof VlogBitVector)) {
                return;
            }
            int maxValueOfCounter = numberForSize2.intValue();
            if (maxValueOfCounter > bigDimension || maxValueOfCounter < smallDimension) {
                this.addHit(parserPath, hid, "Size " + (i + 1) + " of array '" + LintUtils.getNamedElementFullName((RfNamedElement)arrayElement) + "' has range " + smallDimension + " : " + bigDimension + ", but the index is " + maxValueOfCounter + "!" + (paths != null ? "\nHierarchy Paths: " + paths : ""));
            }
        } else if (currentSelect instanceof RfHidAccess) {
            RfHidAccess select = (RfHidAccess)currentSelect;
            IRfNamedElement counterElement = select.getParentHid().getElement();
            if (!(counterElement instanceof RfField) && !(counterElement instanceof RfFunction)) {
                return;
            }
            RfNamedElement assocType = LintUtils.getAssociatedFinalType((RfAssociatedType)counterElement);
            if (assocType == null) {
                return;
            }
            String type = assocType.getName();
            if (!(type.equals("bit") || type.equals("logic") || type.equals("reg"))) {
                return;
            }
            int maxValueOfCounter = (int)Math.pow(2.0, this.getMaxSize((IHidObject)select, null, elManager, evaluator, scope)) - 1;
            if (maxValueOfCounter == -1) {
                return;
            }
            if (maxValueOfCounter > bigDimension || smallDimension > 0) {
                this.addHit(parserPath, hid, "Size " + (i + 1) + " of array '" + LintUtils.getNamedElementFullName((RfNamedElement)arrayElement) + "' has range " + smallDimension + " : " + bigDimension + ", but index '" + HidUtils.toNiceString((IHidObject)select) + "' can have " + (maxValueOfCounter + 1) + " values!" + (paths != null ? "\nHierarchy Paths: " + paths : ""));
            }
        } else if (currentSelect instanceof RfHidOperator) {
            RfHidOperator operator = (RfHidOperator)currentSelect;
            IHidEvaluationGuardian guardianForEval = ELUtils.getEvalGuardian((ELConstants.EvalExceptionZone)ELConstants.EvalExceptionZone.RANGE, (IRfNamedElement)arrayElement, null, (boolean)false, (ELManager)elManager);
            guardianForEval.updateElements(arrayElement, scope);
            IELParamValue value = XUtils.getValue((ELParamValueScope)ELUtils.evaluate((IHidObject)operator, (IHidEvaluator)evaluator, null, (IHidEvaluationGuardian)guardianForEval));
            if (!ELUtils.isUnsuccessfulEval((IELParamValue)value) && value instanceof ELParamValues.ParamValueNumber && (value.intValue() > bigDimension || value.intValue() < smallDimension)) {
                this.addHit(parserPath, hid, "Size " + (i + 1) + " of array '" + LintUtils.getNamedElementFullName((RfNamedElement)arrayElement) + "' has range " + smallDimension + " : " + bigDimension + ", but " + HidUtils.toNiceString((IHidObject)operator) + " expression value is " + value.intValue() + "!" + (paths != null ? "\nHierarchy Paths: " + paths : ""));
            }
        }
    }

    protected int getMaxSize(IHidObject select, IRfNamedElement element, ELManager elManager, ELParamValuesHidEvaluator evaluator, IRfNamedElement scope) {
        IHidEvaluationGuardian guardianForSize = ELUtils.getEvalGuardian((ELConstants.EvalExceptionZone)ELConstants.EvalExceptionZone.RANGE, (IRfNamedElement)element, null, (boolean)true, (ELManager)elManager);
        guardianForSize.updateElements(element, scope);
        ELParamValueScope paramValueForSize = ELUtils.evaluateForSize((IHidObject)select, (IHidEvaluator)evaluator, (IRfNamedElement)element, (IHidEvaluationGuardian)guardianForSize);
        if (ELUtils.isUnsuccessfulEval((ELParamValueScope)paramValueForSize)) {
            return -1;
        }
        DVTNumber numberForSize = paramValueForSize.getDVTNumber();
        if (!(numberForSize instanceof VlogBitVector)) {
            return -1;
        }
        if (numberForSize.hasSign()) {
            return numberForSize.getSize() - 1;
        }
        return numberForSize.getSize();
    }

    protected boolean shouldBeEvaluatedForActualValue(IHidObject currentSelect) {
        if (currentSelect instanceof RfHid) {
            if (!(((RfHid)currentSelect).getElement() instanceof RfField)) {
                return false;
            }
            RfField field = (RfField)((RfHid)currentSelect).getElement();
            if (!field.isAnyParameter()) {
                return false;
            }
        } else if (!(currentSelect instanceof RfHidImplicit)) {
            return false;
        }
        return true;
    }

    private boolean hasAllSelectsGuarded(IHidObject expression, List<IHidObject> selects) {
        ArrayList expressionHids = new ArrayList();
        Predicate<IHidObject> cons = element -> {
            if (!(element instanceof RfHidOperator)) {
                expressionHids.add(element);
            }
            return true;
        };
        HidUtils.flattenToObjects(cons, (IHidObject)expression, EnumSet.of(HidFlatteningOption.IGNORE_METHOD_CALLS, HidFlatteningOption.IGNORE_OBJECTS_IN_SELECTS));
        for (IHidObject hid : expressionHids) {
            selects.remove(hid);
        }
        return selects.isEmpty();
    }

    private boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }
}

