/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.svtb.AbstractNamePatternParametersCheck;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.linter.utils.OVMUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;

public abstract class AbstractConfigClassCheck
extends AbstractNamePatternParametersCheck {
    protected RfClass uvmObjectClass;
    protected Set<RfClass> visitedClasses;
    protected Set<RfClass> configClasses;

    protected AbstractConfigClassCheck(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        String objectClassName = String.valueOf(OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_pkg")) + "::" + OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_object");
        this.uvmObjectClass = this.fOVMProject.getRfProject().getClass(objectClassName, true);
        this.visitedClasses = new HashSet<RfClass>();
        this.configClasses = new HashSet<RfClass>();
        if (this.uvmObjectClass == null) {
            this.addHit(null, "Class '" + objectClassName + "' not found!");
            return;
        }
    }

    protected boolean checkConfigClass(RfClass configClass) {
        if (this.visitedClasses.contains(configClass)) {
            return this.configClasses.contains(configClass);
        }
        this.visitedClasses.add(configClass);
        if (!this.isDirectSubClassOfXVMObject(configClass)) {
            return false;
        }
        List<RfField> fields = configClass.getFieldsWithPrefix("", 2, 2, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
        if (fields == null || fields.isEmpty()) {
            return false;
        }
        boolean hasNonOvmFields = false;
        for (RfField rfField : fields) {
            RfNamedElement associatedType;
            if (this.fOVMProject.isOVMElement(rfField)) continue;
            hasNonOvmFields = true;
            if (rfField.isVirtualInterface() || !((associatedType = LintUtils.getAssociatedFinalType(rfField)) instanceof RfClass) || this.checkConfigClass((RfClass)associatedType)) continue;
            return false;
        }
        if (!hasNonOvmFields) {
            return false;
        }
        this.configClasses.add(configClass);
        return true;
    }

    protected String removeTicks(String description) {
        if (description == null || description.length() < 2) {
            return null;
        }
        if (description.charAt(0) == '\"' && description.charAt(description.length() - 1) == '\"') {
            return description.substring(1, description.length() - 1);
        }
        return description;
    }

    protected boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    public boolean isDirectSubClassOfXVMObject(RfClass child) {
        if (child == null || this.uvmObjectClass == null) {
            return false;
        }
        RfClass parent = child;
        do {
            if (parent.equals(this.uvmObjectClass) || parent.getGenericClass().equals(this.uvmObjectClass)) {
                return true;
            }
            if (!this.fOVMProject.isOVMElement(parent)) continue;
            return false;
        } while ((parent = parent.getParent()) != null);
        return false;
    }
}

