/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.model.reflection.IRfNamedElementVisitor;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;

public abstract class AbstractForLoopCheck
extends OVMComplianceCheck {
    protected boolean addHitOnMissingLoopHids = true;

    protected AbstractForLoopCheck(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.fOVMProject.getRfProject().accept(new NamedElementVisitor());
    }

    protected abstract boolean checkLoopOperators(ListContainer<IHidObject> var1);

    protected abstract String getHitMessage();

    protected abstract void addHits(RfNamedElement var1);

    private boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    class NamedElementVisitor
    implements IRfNamedElementVisitor {
        NamedElementVisitor() {
        }

        @Override
        public boolean visit(RfNamedElement namedElement) {
            if (!(namedElement instanceof RfActionBlock)) {
                return true;
            }
            RfActionBlock loopActionBlock = (RfActionBlock)namedElement;
            if (!loopActionBlock.isFor()) {
                return true;
            }
            AbstractForLoopCheck.this.notifyCheckAlive();
            if (loopActionBlock.getDeclaration() == null || loopActionBlock.getDeclaration().getParserPath() == null) {
                return true;
            }
            ParserPath loopDeclaration = loopActionBlock.getDeclaration().getParserPath();
            if (AbstractForLoopCheck.this.checkPreWaivers(loopDeclaration)) {
                return true;
            }
            RfHidHolder hidHolder = loopActionBlock.getHidHolder();
            if (hidHolder == null || hidHolder.getHidObjectsMap() == null) {
                if (AbstractForLoopCheck.this.addHitOnMissingLoopHids) {
                    AbstractForLoopCheck.this.addHit(namedElement, AbstractForLoopCheck.this.getHitMessage());
                }
                return true;
            }
            ListContainer loopOperators = (ListContainer)hidHolder.getHidObjectsMap().get(loopDeclaration);
            if (loopOperators != null && !loopOperators.isEmpty() && AbstractForLoopCheck.this.checkLoopOperators((ListContainer<IHidObject>)loopOperators)) {
                AbstractForLoopCheck.this.addHits(namedElement);
            }
            return true;
        }
    }
}

