/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTPair;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixAdditionalInfo;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.svtb.AbstractFormattingDisabledCheck;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.linter.utils.LiteralToken;
import ro.amiq.vlogdt.linter.utils.SVTBWhitespaceParser;
import ro.amiq.vlogdt.model.reflection.IRfDefElementVisitor;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfCheckerDef;
import ro.amiq.vlogdt.model.reflection.RfClassDef;
import ro.amiq.vlogdt.model.reflection.RfClockingBlockDef;
import ro.amiq.vlogdt.model.reflection.RfConfigurationDef;
import ro.amiq.vlogdt.model.reflection.RfCovercrossDef;
import ro.amiq.vlogdt.model.reflection.RfCovergroupDef;
import ro.amiq.vlogdt.model.reflection.RfCoverpointDef;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfFieldDef;
import ro.amiq.vlogdt.model.reflection.RfFunctionDef;
import ro.amiq.vlogdt.model.reflection.RfInterfaceDef;
import ro.amiq.vlogdt.model.reflection.RfModportDef;
import ro.amiq.vlogdt.model.reflection.RfModuleDef;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPackageDef;
import ro.amiq.vlogdt.model.reflection.RfProgramDef;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfStructDef;
import ro.amiq.vlogdt.parser.CodePreprocFileInfo;
import ro.amiq.vlogdt.parser.CodePreprocLineInfo;
import ro.amiq.vlogdt.parser.ReparseInfo;
import ro.amiq.vlogdt.parser.SVTBIssues;

public abstract class AbstractIndentationCheck
extends AbstractFormattingDisabledCheck {
    @CheckParameter(defaultValue="2", description="Number of spaces used for indentation", name="numberOfWhitespaces", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.INTEGER)
    protected int pNumberOfWhitespaces;
    @CheckParameter(defaultValue="false", description="When true, only the indentation of the first line of a multiline declaration or statement is checked.", name="skipMultilineStatementsAndDeclarations", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    protected boolean pSkipMultilineStatementsAndDeclarations;
    @CheckParameter(defaultValue="false", description="When true, the identation of conditional compiler directives(`ifdef, `ifndef, `elsif, `else, `endif) is not checked.", name="skipConditionalCompilerDirectives", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pSkipConditionalCompilerDirectives;
    @CheckParameter(defaultValue="false", description="When true, the code inside conditional compiler directives is also indented. This parameter is always false when skipConditionalCompilerDirectives is true.", name="indentInsideConditionalCompilerDirectives", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    protected boolean pIndentInsideConditionalCompilerDirectives;
    @CheckParameter(defaultValue="false", description="When true, the code inside comments is not checked.", name="skipComments", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    protected boolean pSkipComments;
    protected String[] operatorsStrings = new String[]{"if", "while", "for", "foreach", "begin", "repeat", "fork", "else", "case", "casex", "casez", "initial", "final", "assert", "do", "with"};
    protected String[] alwaysStrings = new String[]{"always_comb", "always_ff", "always_latch", "always", "forever"};
    protected Set<String> conditionOperatorsStrings = new HashSet<String>(Arrays.asList("if", "while", "for", "foreach", "case", "casex", "casez", "assert"));
    protected Set<String> openCompilerDirectives = new HashSet<String>(Arrays.asList("`ifdef", "`ifndef", "`elsif", "`else"));
    Map<ParserPath, List<Offset>> blockOffsets = new HashMap<ParserPath, List<Offset>>();
    Map<ParserPath, List<DVTPair<Integer, Integer>>> multilineStatements = new HashMap<ParserPath, List<DVTPair<Integer, Integer>>>();

    protected AbstractIndentationCheck(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void preBuildNotification(RfProject aRfProject) {
        aRfProject.lintTrackP2LInfo(114);
    }

    @Override
    public void configure() {
        super.configure();
        if (this.pSkipConditionalCompilerDirectives && this.pIndentInsideConditionalCompilerDirectives) {
            this.signalParamError("Parameter 'indentInsideConditionalCompilerDirectives' must be false when 'skipConditionalCompilerDirectives' is true!", true);
        }
    }

    @Override
    public void performCheckImpl() {
        this.blockOffsets.clear();
        this.multilineStatements.clear();
        if (this.pSkipMultilineStatementsAndDeclarations) {
            this.calculateMultilineStatementAndDeclarations();
        }
        ArrayList<RfNamedElement> namedElements = new ArrayList<RfNamedElement>();
        this.populateElementsArray(namedElements);
        for (RfNamedElement rfNamedElement : namedElements) {
            ParserPath parserPath;
            if (rfNamedElement == null || rfNamedElement.getDeclaration() == null || this.checkPreWaivers(parserPath = rfNamedElement.getDeclaration().getParserPath()) || rfNamedElement.getDeclaration().getReparseInfo() != null) continue;
            int start = rfNamedElement.getStartOffset();
            int end = rfNamedElement.getEndOffset();
            if (rfNamedElement instanceof RfActionBlock) {
                LiteralToken nextToken;
                RfActionBlock enclosingScope;
                LiteralToken literalToken;
                RfActionBlock actionBlock = (RfActionBlock)rfNamedElement;
                end = this.adjustEndForActionBlock(end, actionBlock);
                if (actionBlock.isWith() || actionBlock.isIfStatementLabel() || actionBlock.isLoopStatementLabel()) {
                    if (!actionBlock.isForOrForeach()) continue;
                    literalToken = this.getWSParser().getToken(start, parserPath);
                    while (literalToken != null && !this.isFor(literalToken)) {
                        literalToken = this.getWSParser().getNextToken(literalToken, parserPath);
                    }
                    if (literalToken == null) continue;
                    start = literalToken.getOffsetFile();
                }
                if (actionBlock.getEnclosingScope() instanceof RfActionBlock && actionBlock.getExpression() == null && (enclosingScope = (RfActionBlock)actionBlock.getEnclosingScope()).isForOrForeach()) continue;
                if (actionBlock.isDoWhile()) {
                    LiteralToken token = this.getWSParser().getTokenContainingOffset(end, parserPath);
                    while (token != null && token.getOffsetFile() > start) {
                        int indexOf;
                        String tokenValue = token.getStringToken();
                        if (tokenValue != null && token.getZone() == SVTBWhitespaceParser.ZoneType.CODE && (indexOf = tokenValue.indexOf("while")) != -1) {
                            end = token.getOffsetFile() + indexOf - 1;
                            break;
                        }
                        token = this.getWSParser().getPrevToken(token, parserPath);
                    }
                }
                if (actionBlock.isElsIf()) {
                    literalToken = this.getWSParser().getTokenByEnding(start, parserPath);
                    LiteralToken ifToken = null;
                    while (literalToken != null && !this.isElse(literalToken)) {
                        if (this.isIf(literalToken)) {
                            ifToken = literalToken;
                        }
                        literalToken = this.getWSParser().getPrevToken(literalToken, parserPath);
                    }
                    if (literalToken != null && ifToken != null && literalToken.getLineNumber() != ifToken.getLineNumber()) {
                        this.addToBlockOffsets(parserPath, literalToken.getOffsetFile() + 4, end);
                    }
                }
                if ((literalToken = this.getWSParser().getToken(start - 4, parserPath)) != null && literalToken.toString().equals("else") && literalToken.getZone() == SVTBWhitespaceParser.ZoneType.CODE && (nextToken = this.getWSParser().getNextToken(literalToken, parserPath)) != null && this.isIf(nextToken) && nextToken.getZone() == SVTBWhitespaceParser.ZoneType.CODE && literalToken.getLineNumber() == nextToken.getLineNumber()) continue;
            }
            this.addToBlockOffsets(parserPath, start, end);
        }
        if (this.pIndentInsideConditionalCompilerDirectives) {
            Map<ParserPath, CodePreprocFileInfo> map = this.fOVMProject.getRfProject().getPreprocessingTable().getCodePreprocFileInfos();
            for (Map.Entry entry : map.entrySet()) {
                TreeSet<Integer> lines;
                CodePreprocFileInfo preprocInfo;
                ParserPath path = (ParserPath)entry.getKey();
                if (path == null || this.checkPreWaivers(path) || (preprocInfo = (CodePreprocFileInfo)entry.getValue()) == null || (lines = preprocInfo.getLines()) == null) continue;
                ArrayDeque<LintUtils.DirectiveInfo> openConditionalDirectives = new ArrayDeque<LintUtils.DirectiveInfo>();
                for (Integer line : lines) {
                    LintUtils.DirectiveInfo directive;
                    CodePreprocLineInfo info = preprocInfo.getInfo(line);
                    if (info == null || (directive = LintUtils.getDirective(this.getWSParser(), path, info, false)) == null || directive.getDirectiveType() == null) continue;
                    if (directive.getDirectiveType().equals("ifdef") || directive.getDirectiveType().equals("ifndef")) {
                        openConditionalDirectives.push(directive);
                        continue;
                    }
                    if (openConditionalDirectives.isEmpty()) continue;
                    LintUtils.DirectiveInfo currentDirective = (LintUtils.DirectiveInfo)openConditionalDirectives.pop();
                    currentDirective.setEndOffset(directive.getStartOffset());
                    if (currentDirective.isSkipDirective()) {
                        this.checkNestedDirectives(path, currentDirective.getDirectiveToken(), currentDirective.getEndOffset());
                    }
                    if (this.isDirectiveInsideActionBlock(currentDirective)) {
                        this.addToBlockOffsets(currentDirective.getDirectivePath(), currentDirective.getStartOffset(), currentDirective.getEndOffset());
                    }
                    if (!directive.getDirectiveType().equals("else") && !directive.getDirectiveType().equals("elsif")) continue;
                    openConditionalDirectives.push(directive);
                }
            }
        }
        block6: for (Map.Entry<ParserPath, List<Offset>> entry : this.blockOffsets.entrySet()) {
            ParserPath path = entry.getKey();
            if (!this.blockOffsets.containsKey(path)) continue;
            List<Offset> fileBlockOffsets = entry.getValue();
            Collections.sort(fileBlockOffsets);
            int offsetIndex = 0;
            block7: while (offsetIndex < fileBlockOffsets.size() - 1) {
                int blockDepth = 1;
                int currentBlockOffset = fileBlockOffsets.get((int)offsetIndex).elementOffset;
                LiteralToken literalToken = this.getWSParser().getTokenByEnding(currentBlockOffset, path);
                if (literalToken == null) {
                    literalToken = this.getWSParser().getTokenContainingOffset(currentBlockOffset, path);
                }
                if (literalToken == null) continue block6;
                int currentLine = literalToken.getLineNumber();
                while (!(literalToken.isFirstTokenOnLine() || this.isEnd(literalToken) || this.isBlockStart(literalToken, path))) {
                    literalToken = this.getWSParser().getPrevToken(literalToken, path);
                    if (literalToken == null) continue block6;
                }
                if (this.isEnd(literalToken)) {
                    literalToken = this.getWSParser().getNextToken(literalToken, path);
                }
                if (literalToken == null) continue block6;
                LiteralToken literalTokenIterator = literalToken;
                while (!this.isBlockStart(literalTokenIterator, path)) {
                    literalTokenIterator = this.getWSParser().getPrevToken(literalTokenIterator, path);
                    if (literalTokenIterator == null) continue block6;
                }
                while (!literalTokenIterator.isFirstTokenOnLine()) {
                    literalTokenIterator = this.getWSParser().getPrevToken(literalTokenIterator, path);
                    if (literalTokenIterator == null) continue block6;
                }
                int currentBlockIndentation = literalTokenIterator.getNoSpacesBefore() + this.pNumberOfWhitespaces;
                boolean shouldCheck = true;
                if (this.startFromZero() && blockDepth == 1 && literalTokenIterator.getNoSpacesBefore() != 0) {
                    currentBlockIndentation = this.pNumberOfWhitespaces;
                    this.addLocalHitGeneral(path, currentLine, false, null, 0);
                }
                if (literalTokenIterator.getNoTabsBefore() != 0) {
                    this.addLocalHitGeneral(path, currentLine, true, null, 0);
                    shouldCheck = false;
                }
                ArrayDeque<Integer> beginIndentationHistory = new ArrayDeque<Integer>();
                LiteralToken conditionStartToken = null;
                int paranthesesBalance = 0;
                while (blockDepth != 0) {
                    this.notifyCheckAlive();
                    boolean hitOnLine = false;
                    if (literalToken == null) {
                        ++offsetIndex;
                        continue block7;
                    }
                    String token = literalToken.toString();
                    if (this.isConditionStart(literalToken, path) && paranthesesBalance == 0) {
                        conditionStartToken = literalToken;
                        paranthesesBalance = this.countTokenParanthesesBalance(conditionStartToken);
                    }
                    while (this.nextOffsetCondition(offsetIndex, fileBlockOffsets, literalToken)) {
                        if (fileBlockOffsets.get((int)(++offsetIndex)).isStart) {
                            ++blockDepth;
                            currentBlockIndentation += this.pNumberOfWhitespaces;
                            continue;
                        }
                        currentBlockIndentation -= this.pNumberOfWhitespaces;
                        if (!this.startFromZero() || --blockDepth != 0 || literalToken.getNoSpacesBefore() == 0) continue;
                        if (literalToken.getLineNumber() > this.getWSParser().getPrevToken(literalToken, path).getLineNumber()) {
                            this.addLocalHitGeneral(path, literalToken.getLineNumber(), false, null, 0);
                        }
                        hitOnLine = true;
                    }
                    if (blockDepth == 0) {
                        ++offsetIndex;
                        continue block7;
                    }
                    if (literalToken.getLineNumber() != currentLine) {
                        int nOfWhiteSpaces = literalToken.getNoTabsBefore() == 0 ? literalToken.getNoSpacesBefore() : -1;
                        currentLine = literalToken.getLineNumber();
                        if (this.isBegin(literalToken)) {
                            if (this.getBeginBlockOffset(literalToken, path) == fileBlockOffsets.get((int)(offsetIndex + 1)).elementOffset) {
                                beginIndentationHistory.push(0);
                                if (nOfWhiteSpaces != currentBlockIndentation && !hitOnLine && shouldCheck) {
                                    this.addLocalHitGeneral(path, currentLine, literalToken.getNoTabsBefore() != 0, null, currentBlockIndentation);
                                }
                            } else if (nOfWhiteSpaces == currentBlockIndentation) {
                                currentBlockIndentation += this.pNumberOfWhitespaces;
                                beginIndentationHistory.push(this.pNumberOfWhitespaces);
                            } else {
                                beginIndentationHistory.push(0);
                                if (nOfWhiteSpaces != currentBlockIndentation - this.pNumberOfWhitespaces && !hitOnLine && shouldCheck) {
                                    this.addLocalHitGeneral(path, currentLine, literalToken.getNoTabsBefore() != 0, null, currentBlockIndentation - this.pNumberOfWhitespaces);
                                }
                            }
                        } else if (this.isEnd(literalToken)) {
                            if (beginIndentationHistory.isEmpty()) continue block6;
                            int beginIndentation = (Integer)beginIndentationHistory.pop();
                            if (nOfWhiteSpaces != (currentBlockIndentation -= beginIndentation) - this.pNumberOfWhitespaces + beginIndentation && !hitOnLine && shouldCheck) {
                                int indentation = currentBlockIndentation - this.pNumberOfWhitespaces + beginIndentation;
                                this.addLocalHitGeneral(path, currentLine, literalToken.getNoTabsBefore() != 0, null, indentation);
                            }
                        } else if (nOfWhiteSpaces != currentBlockIndentation && !this.isConditionExtraLine(currentLine, conditionStartToken) && !hitOnLine && shouldCheck) {
                            LiteralToken nextToken;
                            String tokenString = literalToken.toString();
                            if (this.pIndentInsideConditionalCompilerDirectives && (nextToken = this.getWSParser().getNextToken(literalToken, path)) != null) {
                                tokenString = String.valueOf(tokenString) + nextToken.toString();
                            }
                            if (this.checkOtherEndBlocks(token, literalToken) || this.pIndentInsideConditionalCompilerDirectives && (tokenString.startsWith("`else") || tokenString.startsWith("`elsif") || tokenString.startsWith("`endif"))) {
                                if (nOfWhiteSpaces != currentBlockIndentation - this.pNumberOfWhitespaces) {
                                    int indentation = this.otherEndBlocksindentation(currentBlockIndentation);
                                    this.addLocalHitGeneral(path, currentLine, literalToken.getNoTabsBefore() != 0, null, indentation);
                                }
                            } else if (!this.pSkipComments || !literalToken.isComment()) {
                                this.addLocalHitGeneral(path, currentLine, literalToken.getNoTabsBefore() != 0, null, currentBlockIndentation);
                            }
                        }
                    } else {
                        if (this.isBegin(literalToken)) {
                            beginIndentationHistory.push(0);
                        }
                        if (this.isEnd(literalToken)) {
                            if (beginIndentationHistory.isEmpty()) continue block6;
                            int beginIndentation = (Integer)beginIndentationHistory.pop();
                            currentBlockIndentation -= beginIndentation;
                        }
                    }
                    if (this.reachedConditionEnd(literalToken, conditionStartToken, paranthesesBalance)) {
                        conditionStartToken = null;
                        paranthesesBalance = 0;
                    } else if (conditionStartToken != null && literalToken != conditionStartToken) {
                        paranthesesBalance += this.countTokenParanthesesBalance(literalToken);
                    }
                    literalToken = this.getWSParser().getNextToken(literalToken, path);
                }
            }
        }
    }

    private boolean isConditionExtraLine(int currentLine, LiteralToken conditionStartToken) {
        if (conditionStartToken == null) {
            return false;
        }
        return currentLine != conditionStartToken.getLineNumber();
    }

    protected abstract int adjustEndForActionBlock(int var1, RfActionBlock var2);

    protected abstract boolean checkOtherEndBlocks(String var1, LiteralToken var2);

    protected abstract int otherEndBlocksindentation(int var1);

    protected abstract boolean nextOffsetCondition(int var1, List<Offset> var2, LiteralToken var3);

    protected abstract boolean isBlockStart(LiteralToken var1, ParserPath var2);

    protected abstract boolean isConditionStart(LiteralToken var1, ParserPath var2);

    protected abstract boolean reachedConditionEnd(LiteralToken var1, LiteralToken var2, int var3);

    protected abstract boolean startFromZero();

    protected void populateElementsArray(List<RfNamedElement> namedElements) {
        namedElements.addAll(this.fOVMProject.getRfProject().getAllActionBlocks());
    }

    private void addToBlockOffsets(ParserPath parserPath, int start, int end) {
        List<Offset> fileBlockOffsets = this.blockOffsets.get(parserPath);
        if (fileBlockOffsets == null) {
            fileBlockOffsets = new ArrayList<Offset>();
            fileBlockOffsets.add(new Offset(start, true));
            fileBlockOffsets.add(new Offset(end, false));
            this.blockOffsets.put(parserPath, fileBlockOffsets);
        } else {
            fileBlockOffsets.add(new Offset(start, true));
            fileBlockOffsets.add(new Offset(end, false));
        }
    }

    public boolean checkPreWaivers(ParserPath parserPath) {
        if (parserPath == null) {
            return true;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    private boolean isBegin(LiteralToken literalToken) {
        if (literalToken.getZone() != SVTBWhitespaceParser.ZoneType.CODE) {
            return false;
        }
        String text = literalToken.toString();
        return text.equals("begin") || text.endsWith(":begin") || text.endsWith(")begin") || text.contains("begin:") || text.contains("begin;");
    }

    private boolean isEnd(LiteralToken literalToken) {
        if (literalToken.getZone() != SVTBWhitespaceParser.ZoneType.CODE) {
            return false;
        }
        String text = literalToken.toString();
        return text.equals("end") || text.endsWith(")end");
    }

    private boolean isIf(LiteralToken literalToken) {
        if (literalToken.getZone() != SVTBWhitespaceParser.ZoneType.CODE) {
            return false;
        }
        String text = literalToken.toString();
        return text.equals("if") || text.startsWith("if(");
    }

    private boolean isFor(LiteralToken literalToken) {
        if (literalToken.getZone() != SVTBWhitespaceParser.ZoneType.CODE) {
            return false;
        }
        String text = literalToken.toString();
        return text.equals("for") || text.startsWith("for(") || text.equals("foreach") || text.startsWith("foreach(");
    }

    private boolean isElse(LiteralToken literalToken) {
        if (literalToken.getZone() != SVTBWhitespaceParser.ZoneType.CODE) {
            return false;
        }
        String text = literalToken.toString();
        return text.equals("else");
    }

    private int getBeginBlockOffset(LiteralToken literalToken, ParserPath path) {
        LiteralToken nextToken = this.getWSParser().getNextToken(literalToken, path);
        if (nextToken == null) {
            return -1;
        }
        if (literalToken.toString().equals("begin")) {
            if (nextToken.toString().equals(":")) {
                return this.getWSParser().getNextToken(nextToken, path).getOffsetFile();
            }
            if (nextToken.toString().startsWith(":")) {
                return nextToken.getOffsetFile() + 1;
            }
            return literalToken.getOffsetFile() + 5;
        }
        if (literalToken.toString().startsWith("begin:")) {
            return this.getWSParser().getNextToken(nextToken, path).getOffsetFile();
        }
        return -1;
    }

    protected void calculateMultilineStatementAndDeclarations() {
        Map<ParserPath, List<SVTBIssues>> multilineIssues = this.fOVMProject.getSVTBIssuesWithKind(114);
        for (Map.Entry<ParserPath, List<SVTBIssues>> entry : multilineIssues.entrySet()) {
            ParserPath path = entry.getKey();
            if (this.fOVMProject.getProjectWaivers().pathIsPrewaived(path, this)) continue;
            this.notifyCheckAlive();
            List<SVTBIssues> issues = entry.getValue();
            block3: for (SVTBIssues currentIssue : issues) {
                LiteralToken currentToken;
                String[] stringArray = this.operatorsStrings;
                int n = this.operatorsStrings.length;
                int n2 = 0;
                while (n2 < n) {
                    String opString = stringArray[n2];
                    if (currentIssue.getInfo().equals(opString) || currentIssue.getInfo().startsWith(opString)) continue block3;
                    ++n2;
                }
                stringArray = this.alwaysStrings;
                n = this.alwaysStrings.length;
                n2 = 0;
                while (n2 < n) {
                    String alwaysStr = stringArray[n2];
                    if (currentIssue.getInfo().equals(alwaysStr) || currentIssue.getInfo().startsWith(alwaysStr)) continue block3;
                    ++n2;
                }
                if (currentIssue.getInfo().equals("join") || currentIssue.getInfo().startsWith("join") || currentIssue.getInfo().contains("@") || currentIssue.getInfo().contains("#")) continue;
                boolean isMacroCall = false;
                if (currentIssue.getReparseInfo() != null) {
                    String[] reparseMacroParams;
                    ReparseInfo reparseInfo = currentIssue.getReparseInfo();
                    ReparseInfo.ReparseElement reparseElement = reparseInfo.getLastReparseElement();
                    if (reparseElement == null || (reparseMacroParams = reparseElement.getReparseMacroParams()).length == 0) continue;
                    isMacroCall = true;
                }
                if ((currentToken = this.getWSParser().getTokenContainingOffset(currentIssue.getOffset(), path)) == null) continue;
                int startLineNo = currentToken.getLineNumber();
                if (!isMacroCall) {
                    while (this.checkCurrentToken(currentToken)) {
                        currentToken = this.getWSParser().getNextToken(currentToken, path);
                        if (currentToken == null) continue block3;
                    }
                } else {
                    int paranthesesBalance = this.countTokenParanthesesBalance(currentToken);
                    if (paranthesesBalance == 0 && !currentToken.getStringToken().contains("(")) {
                        currentToken = this.getWSParser().getNextToken(currentToken, path);
                        if (currentToken == null) continue;
                        paranthesesBalance += this.countTokenParanthesesBalance(currentToken);
                    }
                    while (this.checkCurrentMacroToken(currentToken, paranthesesBalance)) {
                        currentToken = this.getWSParser().getNextToken(currentToken, path);
                        if (currentToken == null) continue block3;
                        paranthesesBalance += this.countTokenParanthesesBalance(currentToken);
                    }
                }
                int endLineNo = currentToken.getLineNumber();
                if (startLineNo == endLineNo) continue;
                List<DVTPair<Integer, Integer>> statements = this.multilineStatements.get(path);
                if (statements == null) {
                    statements = new ArrayList<DVTPair<Integer, Integer>>();
                    statements.add((DVTPair<Integer, Integer>)new DVTPair((Object)startLineNo, (Object)endLineNo));
                    this.multilineStatements.put(path, statements);
                    continue;
                }
                statements.add((DVTPair<Integer, Integer>)new DVTPair((Object)startLineNo, (Object)endLineNo));
            }
        }
        try {
            this.fOVMProject.getRfProject().accept(new DeclarationVisitor());
        }
        catch (Exception e) {
            this.fOVMProject.notifyCheckException(this, e);
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private boolean checkCurrentToken(LiteralToken currentToken) {
        return !currentToken.getZone().equals((Object)SVTBWhitespaceParser.ZoneType.CODE) || !currentToken.getStringToken().contains(";");
    }

    protected int countTokenParanthesesBalance(LiteralToken currentToken) {
        if (!currentToken.getZone().equals((Object)SVTBWhitespaceParser.ZoneType.CODE)) {
            return 0;
        }
        String text = currentToken.getStringToken();
        int countOpen = (int)text.chars().filter(c -> c == 40).count();
        int countClosed = (int)text.chars().filter(c -> c == 41).count();
        return countOpen - countClosed;
    }

    private boolean checkCurrentMacroToken(LiteralToken currentToken, int paranthesesBalance) {
        return !currentToken.getZone().equals((Object)SVTBWhitespaceParser.ZoneType.CODE) || paranthesesBalance != 0;
    }

    private void addLocalHitGeneral(ParserPath file, int line, boolean wereTabsUsed, ReparseInfo reparseInfo, int newIndent) {
        String message = "";
        message = wereTabsUsed ? "Tabs were used for indentation!" : "Wrong indentation! You should use " + String.valueOf(newIndent) + " whitespaces!";
        this.addLocalHit(file, line, message, reparseInfo, new VerissimoAutofixAdditionalInfo(newIndent));
    }

    private void addLocalHit(ParserPath file, int line, String details, ReparseInfo reparseInfo, VerissimoAutofixAdditionalInfo autofixAdditionalInfo) {
        List<DVTPair<Integer, Integer>> statements;
        if (this.pSkipMultilineStatementsAndDeclarations && (statements = this.multilineStatements.get(file)) != null && !statements.isEmpty()) {
            boolean multilineHit = false;
            for (DVTPair<Integer, Integer> statement : statements) {
                if (line == (Integer)statement.getKey()) {
                    LiteralToken firstToken;
                    if (!(autofixAdditionalInfo.getElement() instanceof Integer) || (firstToken = this.getWSParser().getFirstTokenOnLine(file, line)) == null) continue;
                    int nofSpacesBeforeFirstTokenOnFirstLine = firstToken.getNoSpacesBefore();
                    Integer nofSpaces = (Integer)autofixAdditionalInfo.getElement();
                    ArrayList<Integer> info = new ArrayList<Integer>();
                    info.add((Integer)statement.getKey());
                    info.add((Integer)statement.getValue());
                    info.add(nofSpaces);
                    int i = line + 1;
                    while (i <= (Integer)statement.getValue()) {
                        firstToken = this.getWSParser().getFirstTokenOnLine(file, i);
                        if (firstToken != null) {
                            int nofSpacesBeforeFirstTokenOnCurrentLine = firstToken.getNoSpacesBefore();
                            int spacesBetween = nofSpacesBeforeFirstTokenOnCurrentLine - nofSpacesBeforeFirstTokenOnFirstLine;
                            info.add(nofSpaces + spacesBetween);
                        }
                        ++i;
                    }
                    autofixAdditionalInfo = new VerissimoAutofixAdditionalInfo(info);
                }
                if (line <= (Integer)statement.getKey() || line > (Integer)statement.getValue()) continue;
                multilineHit = true;
                break;
            }
            if (multilineHit) {
                return;
            }
        }
        if (this.pSkipConditionalCompilerDirectives) {
            boolean shouldHit;
            LiteralToken firstToken = this.getWSParser().getFirstTokenOnLine(file, line);
            if (firstToken == null) {
                return;
            }
            String firstTokenString = firstToken.getStringToken();
            LiteralToken secondToken = this.getWSParser().getNextToken(firstToken, file);
            String secondTokenString = secondToken == null ? "" : secondToken.getStringToken();
            String finalToken = firstTokenString.concat(secondTokenString);
            boolean bl = shouldHit = !finalToken.startsWith("`ifdef") && !finalToken.startsWith("`ifndef") && !finalToken.startsWith("`else") && !finalToken.startsWith("`elsif") && !finalToken.startsWith("`endif");
            if (!shouldHit) {
                return;
            }
        }
        this.addHit(file, line, details, reparseInfo, false, autofixAdditionalInfo);
    }

    @Override
    public boolean requiresLineEndings() {
        return true;
    }

    public void checkNestedDirectives(ParserPath path, LiteralToken token, int endOffset) {
        LiteralToken currentToken = this.getWSParser().getNextToken(token, path);
        ArrayDeque<LintUtils.DirectiveInfo> openConditionalDirectives = new ArrayDeque<LintUtils.DirectiveInfo>();
        while (currentToken != null && currentToken.getOffsetFile() < endOffset) {
            LiteralToken nextToken = this.getWSParser().getNextToken(currentToken, path);
            if (nextToken == null) {
                return;
            }
            String directive = currentToken.getStringToken();
            if (!directive.contains("`")) {
                currentToken = nextToken;
                continue;
            }
            if (directive.equals("`") || directive.endsWith("`")) {
                directive = String.valueOf(directive) + nextToken.toString();
            }
            String directiveType = "";
            for (String compilerDirective : LintUtils.ALL_COMPILER_DIRECTIVES) {
                if (!directive.contains(compilerDirective)) continue;
                directiveType = compilerDirective;
            }
            if ("".equals(directiveType)) {
                currentToken = nextToken;
                continue;
            }
            if (directiveType.equals("ifdef") || directiveType.equals("ifndef")) {
                openConditionalDirectives.push(new LintUtils.DirectiveInfo(path, directiveType, null, currentToken, false, false));
                currentToken = nextToken;
                continue;
            }
            if (openConditionalDirectives.isEmpty()) {
                currentToken = nextToken;
                continue;
            }
            LintUtils.DirectiveInfo currentDirective = (LintUtils.DirectiveInfo)openConditionalDirectives.pop();
            currentDirective.setEndOffset(currentToken.getOffsetFile());
            if (this.isDirectiveInsideActionBlock(currentDirective)) {
                this.addToBlockOffsets(currentDirective.getDirectivePath(), currentDirective.getStartOffset(), currentDirective.getEndOffset());
            }
            if (directiveType.equals("else") || directiveType.equals("elsif")) {
                openConditionalDirectives.push(new LintUtils.DirectiveInfo(path, directiveType, null, currentToken, false, false));
            }
            currentToken = nextToken;
        }
    }

    private boolean isDirectiveInsideActionBlock(LintUtils.DirectiveInfo directive) {
        List<Offset> offsets = this.blockOffsets.get(directive.getDirectivePath());
        if (offsets == null) {
            return false;
        }
        int i = 0;
        while (i < offsets.size()) {
            Offset startOffset = offsets.get(i);
            Offset endOffset = offsets.get(i + 1);
            if (startOffset.elementOffset < directive.getStartOffset() && directive.getStartOffset() < endOffset.elementOffset && startOffset.elementOffset < directive.getEndOffset() && directive.getEndOffset() < endOffset.elementOffset) {
                return true;
            }
            i += 2;
        }
        return false;
    }

    private final class DeclarationVisitor
    implements IRfDefElementVisitor {
        private DeclarationVisitor() {
        }

        @Override
        public boolean visit(RfDefElement defElement) throws Exception {
            return false;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void preVisit(RfDefElement defElement) throws Exception {
            block9: {
                block8: {
                    path = defElement.getParserPath();
                    if (!(defElement instanceof RfFieldDef)) break block8;
                    if (defElement instanceof RfCoverpointDef || defElement instanceof RfCovercrossDef) {
                        return;
                    }
                    if (defElement.getStartLine() == defElement.getEndLine()) {
                        return;
                    }
                    statements = AbstractIndentationCheck.this.multilineStatements.get(path);
                    if (statements == null) {
                        statements = new ArrayList<DVTPair<Integer, Integer>>();
                        statements.add((DVTPair<Integer, Integer>)new DVTPair((Object)defElement.getStartLine(), (Object)defElement.getEndLine()));
                        AbstractIndentationCheck.this.multilineStatements.put(path, statements);
                    } else {
                        statements.add((DVTPair<Integer, Integer>)new DVTPair((Object)defElement.getStartLine(), (Object)defElement.getEndLine()));
                    }
                    break block9;
                }
                if (!(defElement instanceof RfClassDef) && !(defElement instanceof RfClockingBlockDef) && !(defElement instanceof RfFunctionDef) && !(defElement instanceof RfInterfaceDef) && !(defElement instanceof RfModuleDef) && !(defElement instanceof RfProgramDef) && !(defElement instanceof RfCheckerDef) && !(defElement instanceof RfConfigurationDef) && !(defElement instanceof RfCovergroupDef) && !(defElement instanceof RfModportDef) && !(defElement instanceof RfPackageDef) && !(defElement instanceof RfStructDef)) break block9;
                currentToken = AbstractIndentationCheck.this.getWSParser().getTokenContainingOffset(defElement.getStartOffset(), path);
                if (currentToken != null) ** GOTO lbl26
                return;
lbl-1000:
                // 1 sources

                {
                    currentToken = AbstractIndentationCheck.this.getWSParser().getNextToken(currentToken, path);
                    if (currentToken != null) continue;
                    return;
lbl26:
                    // 2 sources

                    ** while (AbstractIndentationCheck.this.checkCurrentToken((LiteralToken)currentToken))
                }
lbl27:
                // 1 sources

                startLineNo = defElement.getStartLine();
                if (startLineNo == (endLineNo = currentToken.getLineNumber())) {
                    return;
                }
                statements = AbstractIndentationCheck.this.multilineStatements.get(path);
                if (statements == null) {
                    statements = new ArrayList<DVTPair<Integer, Integer>>();
                    statements.add((DVTPair<Integer, Integer>)new DVTPair((Object)startLineNo, (Object)endLineNo));
                    AbstractIndentationCheck.this.multilineStatements.put(path, statements);
                } else {
                    statements.add((DVTPair<Integer, Integer>)new DVTPair((Object)startLineNo, (Object)endLineNo));
                }
            }
        }

        @Override
        public void postVisit(RfDefElement defElement) throws Exception {
        }
    }

    protected static class Offset
    implements Comparable<Offset> {
        public int elementOffset;
        boolean isStart;

        Offset(int offset, boolean isStart) {
            this.elementOffset = offset;
            this.isStart = isStart;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Offset)) {
                return false;
            }
            Offset o = (Offset)obj;
            return this.elementOffset == o.elementOffset && this.isStart == o.isStart;
        }

        public int hashCode() {
            return this.elementOffset;
        }

        @Override
        public int compareTo(Offset o) {
            return this.elementOffset - o.elementOffset;
        }
    }
}

