/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.svtb.ModuleMembersIterator;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;

public abstract class AbstractInstanceNamingCheck
extends OVMComplianceCheck {
    protected final String ELEMENT_NAME_PLACEHOLDER = "$type_name";
    @CheckParameter(defaultValue="", description="The member name pattern. Alternatively, the '$type_name' can be used as placeholder for the instance type name.", name="namePattern", required=CheckParameterRequired.MANDATORY, type=CheckParameterType.STRING)
    protected String pNamePatternValue;
    @CheckParameter(defaultValue="", description="Comma separated list of legal name exceptions.", name="nameExceptions", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    protected HashSet<String> pNameExceptionsValue;

    protected AbstractInstanceNamingCheck(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    protected abstract boolean hasRightType(RfNamedElement var1);

    protected abstract void addLocalHit(RfNamedElement var1, String var2, String var3);

    @Override
    public void performCheckImpl() {
        HashSet<String> moduleMembersIteratorKeys = new HashSet<String>();
        moduleMembersIteratorKeys.add("instance");
        for (RfNamedElement eachModule : this.fOVMProject.getAllModules()) {
            this.notifyCheckAlive();
            if (eachModule == null || !(eachModule instanceof RfModule)) continue;
            ModuleMembersIterator moduleMembersIterator = new ModuleMembersIterator((RfModule)eachModule, moduleMembersIteratorKeys, true, null, null);
            while (moduleMembersIterator.hasNext()) {
                Matcher m;
                RfField eachField;
                RfNamedElement fieldType;
                RfNamedElement eachMember = moduleMembersIterator.next();
                if (eachMember == null || !(eachMember instanceof RfField) || (fieldType = LintUtils.getAssociatedFinalType(eachField = (RfField)eachMember)) == null || !this.hasRightType(fieldType)) continue;
                String fieldTypeName = fieldType.getName();
                Pattern namePattern = Pattern.compile(this.pNamePatternValue.replace("$type_name", fieldTypeName));
                String memberName = eachMember.getName();
                if (memberName == null || namePattern.pattern().isEmpty() || this.pNameExceptionsValue.contains(memberName) || (m = namePattern.matcher(memberName)).matches()) continue;
                this.addLocalHit(eachMember, eachModule.getName(), memberName);
            }
        }
    }
}

