/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifierCache;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.IndexType;
import ro.amiq.vlogdt.model.reflection.RfAssociatedType;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfModportPort;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

public abstract class AbstractLiteralCheck
extends OVMComplianceCheck {
    protected NumericalLiteralVisitor visitor;

    protected AbstractLiteralCheck(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.visitor = new NumericalLiteralVisitor();
        this.fOVMProject.getRfProject().visitHidObject(null, this.visitor);
        this.fOVMProject.getRfProject().accept(namedElement -> {
            if (!(namedElement instanceof RfField) && !(namedElement instanceof RfTypeAlias)) {
                return true;
            }
            RfAssociatedType field = (RfAssociatedType)namedElement;
            RfDefElement fieldDeclaration = field.getDeclaration();
            if (fieldDeclaration == null || fieldDeclaration.getParserPath() == null) {
                return true;
            }
            if (field.isPredefined() || field instanceof RfModportPort) {
                return true;
            }
            if (field instanceof RfField && ((RfField)field).isEnumElement()) {
                return true;
            }
            if (this.fOVMProject.isOVMFile(field.getFile().getName())) {
                return true;
            }
            if (this.checkPreWaivers(fieldDeclaration.getParserPath())) {
                return true;
            }
            this.notifyCheckAlive();
            DataType dataType = field.getDataType();
            if (dataType == null) {
                return true;
            }
            List<IndexType> dimensions = this.getDimensions(dataType);
            if (dimensions.isEmpty()) {
                return true;
            }
            for (IndexType dimension : dimensions) {
                IHidObject rangeObj = dimension.getRangeObject();
                if (rangeObj == null || !(rangeObj instanceof RfHidImplicit)) continue;
                this.analyzeImplicit((RfHidImplicit)rangeObj, namedElement.getDeclaration().getParserPath(), namedElement.getLine(), namedElement.getOffset());
            }
            return true;
        });
    }

    private List<IndexType> getDimensions(DataType dataType) {
        ArrayList<IndexType> result = new ArrayList<IndexType>();
        if (dataType.hasPackedDimension()) {
            result.addAll(dataType.getPackedDimension());
        }
        if (dataType.hasUnpackedDimension()) {
            result.addAll(dataType.getUnpackedDimension());
        }
        return result;
    }

    private boolean hasNestedOperators(IHidObject lh, ListContainer<IHidObject> rhValues) {
        if (lh instanceof RfHidOperator) {
            return true;
        }
        if (rhValues != null && !rhValues.isEmpty()) {
            for (IHidObject rh : rhValues) {
                if (!(rh instanceof RfHidOperator)) continue;
                return true;
            }
        }
        return false;
    }

    private void analyzeImplicitsInOperatorComponent(RfHidOperator operator, IHidObject component, ParserPath parserPath) {
        Set flattenHids = HidUtils.flattenToHids((IHidObject)component, EnumSet.of(HidFlatteningOption.IGNORE_HIDS));
        if (flattenHids == null || flattenHids.isEmpty()) {
            return;
        }
        for (IHid hid : flattenHids) {
            if (!(hid instanceof RfHidImplicit)) continue;
            this.analyzeImplicit((RfHidImplicit)hid, parserPath, operator.getOccurrence().getLine(), operator.getOccurrence().getOffset());
        }
    }

    protected abstract void analyzeImplicit(RfHidImplicit var1, ParserPath var2, int var3, int var4);

    protected abstract boolean checkParameterAndConst();

    protected abstract boolean skipFunction(String var1);

    protected abstract boolean skipOperator(RfHidOperator var1, ParserPath var2);

    public boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    protected class NumericalLiteralVisitor
    implements IHidVisitor<IHidObject> {
        private ParserPath parserPath;
        private RfNamedElement scope;

        protected NumericalLiteralVisitor() {
        }

        public boolean visit(IHidObject hidObject) {
            if (AbstractLiteralCheck.this.checkPreWaivers(this.parserPath)) {
                return true;
            }
            AbstractLiteralCheck.this.notifyCheckAlive();
            if (hidObject instanceof RfHidOperator) {
                return this.checkOperator((RfHidOperator)hidObject);
            }
            if (hidObject instanceof RfHidAccess) {
                return this.checkAccess((RfHidAccess)hidObject);
            }
            if (hidObject instanceof RfHid) {
                return this.checkRfHid((RfHid)hidObject);
            }
            return true;
        }

        private boolean checkRfHid(RfHid rfHid) {
            if (!(rfHid.getElement() instanceof RfFunction)) {
                return true;
            }
            RfFunction function = (RfFunction)rfHid.getElement();
            if (AbstractLiteralCheck.this.skipFunction(function.getFullName())) {
                return true;
            }
            List methodCalls = MethodCallUtils.getMethodCalls((IHid)rfHid);
            if (methodCalls == null || methodCalls.isEmpty()) {
                return true;
            }
            for (MethodCall methodCall : methodCalls) {
                if (methodCall == null || methodCall.argumentValuesMapRaw == null || methodCall.argumentValuesMapRaw.isEmpty()) continue;
                for (Map.Entry entry : methodCall.argumentValuesMapRaw.entrySet()) {
                    Set hids = HidUtils.flattenToHids((IHidObject)((IHidObject)entry.getValue()), EnumSet.of(HidFlatteningOption.IGNORE_HIDS));
                    if (hids == null || hids.isEmpty()) continue;
                    for (IHid hid : hids) {
                        if (!(hid instanceof RfHidImplicit)) continue;
                        AbstractLiteralCheck.this.analyzeImplicit((RfHidImplicit)hid, this.parserPath, rfHid.getOccurrence().getLine(), rfHid.getOccurrence().getOffset());
                    }
                }
            }
            return true;
        }

        private boolean checkAccess(RfHidAccess hidAccess) {
            List selects = hidAccess.getSelects();
            if (selects == null || selects.isEmpty()) {
                return true;
            }
            for (IHidObject select : selects) {
                if (!(select instanceof RfHidImplicit)) continue;
                AbstractLiteralCheck.this.analyzeImplicit((RfHidImplicit)select, this.parserPath, hidAccess.getOccurrence().getLine(), hidAccess.getOccurrence().getOffset());
            }
            return true;
        }

        private boolean checkOperator(RfHidOperator hidOperator) {
            ListContainer rhValues;
            RfField member;
            IHidObject lhValue;
            if (this.scope != null && this.scope.isPredefined()) {
                return true;
            }
            if (AbstractLiteralCheck.this.skipOperator(hidOperator, this.parserPath)) {
                return true;
            }
            if (hidOperator.hasQualifier(HidQualifierCache.IS_GENERIC_VALUE_QUALIFIER) && (lhValue = hidOperator.getLHValue()) instanceof RfHidImplicit) {
                AbstractLiteralCheck.this.analyzeImplicit((RfHidImplicit)lhValue, this.parserPath, hidOperator.getLine(), hidOperator.getOffset());
            }
            if (AbstractLiteralCheck.this.checkParameterAndConst() && hidOperator.hasQualifier(HidOperatorQualifier.IS_DECLARATION_ASSIGN.value()) && (lhValue = hidOperator.getLHValue()) instanceof RfHidImplicit && (member = this.scope.getLocalMember(RfField.class, ((RfHidImplicit)lhValue).getName(), false)) != null && (member.isParameter() || member.isConst())) {
                return true;
            }
            IHidObject lh = hidOperator.getLHValue();
            if (AbstractLiteralCheck.this.hasNestedOperators(lh, (ListContainer<IHidObject>)(rhValues = hidOperator.getRHValues()))) {
                if (!(lh instanceof RfHidOperator)) {
                    AbstractLiteralCheck.this.analyzeImplicitsInOperatorComponent(hidOperator, lh, this.parserPath);
                }
                if (rhValues != null && !rhValues.isEmpty()) {
                    for (IHidObject rh : rhValues) {
                        if (rh instanceof RfHidOperator) continue;
                        AbstractLiteralCheck.this.analyzeImplicitsInOperatorComponent(hidOperator, rh, this.parserPath);
                    }
                }
            } else {
                AbstractLiteralCheck.this.analyzeImplicitsInOperatorComponent(hidOperator, (IHidObject)hidOperator, this.parserPath);
            }
            return true;
        }

        public void setHolder(IHidHolder holder) {
            this.scope = (RfNamedElement)((RfHidHolder)holder).getScope();
        }

        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }

        public Class<IHidObject> getType() {
            return IHidObject.class;
        }
    }
}

