/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.Collection;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;

public abstract class AbstractMethodsCheck
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="", description="Check all methods with the specified prefix.", name="prefix", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.STRING)
    protected String methodPrefix;

    protected AbstractMethodsCheck(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        for (RfNamedElement classs : this.fOVMProject.getAllNonXVMClasses()) {
            this.checkClass((RfClass)classs);
        }
    }

    private void checkClass(RfClass classs) {
        if (classs == null) {
            return;
        }
        this.notifyCheckAlive();
        RfFileDef file = classs.getFile();
        if (file == null) {
            return;
        }
        if (this.checkPreWaivers(file.getParserPath())) {
            return;
        }
        this.checkMethods(classs.getLocalMembers(RfFunction.class), file.getParserPath());
    }

    private void checkMethods(Collection<RfFunction> methods, ParserPath parserPath) {
        if (methods == null || methods.isEmpty()) {
            return;
        }
        for (RfFunction method : methods) {
            if (method == null || method.isPredefined() || !method.getName().startsWith(this.methodPrefix)) continue;
            this.checkMethod(method, parserPath);
        }
    }

    protected abstract void checkMethod(RfFunction var1, ParserPath var2);

    protected boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }
}

