/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import ro.amiq.dvt.elaboration.core.ELSpecializationWrapper;
import ro.amiq.dvt.elaboration.model.ELParamValuesHidEvaluator;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifierCache;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension2.ISDataAbstract;
import ro.amiq.dvt.model.reflection.semantic.extension2.SDataVariable;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.rules.AbstractMultipleOperandsWidthMissmatchCheck;
import ro.amiq.vlogdt.linter.rules.AbstractWidthMissmatchCheck;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccessArgs;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;
import ro.amiq.vlogdt.model.reflection.semantic.extension2.STransformer;

public abstract class AbstractMultipleOperandsAllAssignmentsWidthMissmatchCheck
extends AbstractMultipleOperandsWidthMissmatchCheck {
    private final String ASSIGNMENT_TYPE = "assignment";
    private final String ARGUMENT_TYPE = "argument";

    protected AbstractMultipleOperandsAllAssignmentsWidthMissmatchCheck(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        super.performCheckImpl();
        this.fOVMProject.getRfProject().visitHidObject(null, new AssignmentOperatorVisitor());
        this.fOVMProject.getRfProject().visitHidObject(null, new MethodArgumentsVisitor());
    }

    private void analyzeOperator(RfHidOperator operator, RfNamedElement scope, ParserPath parserPath, String operatorOriginType) {
        Collection<IHidObject> flattenedRhHids;
        Object lhValueHidObject;
        IHidObject rhHidObject = operator.getFirstRHValue();
        if (rhHidObject == null || !this.checkRhSideHid(rhHidObject)) {
            return;
        }
        ArrayList<IHidObject> hidObjects = new ArrayList<IHidObject>();
        ArrayList<RfHid> valueRfHids = new ArrayList<RfHid>();
        ArrayList<IRfNamedElement> elements = new ArrayList<IRfNamedElement>();
        ArrayList<RfNamedElement> elementTypes = new ArrayList<RfNamedElement>();
        ArrayList<IRfNamedElement> ancestorElements = new ArrayList<IRfNamedElement>();
        ArrayList<Hid> instanceHids = new ArrayList<Hid>();
        ArrayList<IRfNamedElement> instanceFieldOrFunctions = new ArrayList<IRfNamedElement>();
        ArrayList<IRfScopeElement> ancestorElementEnclosingScopes = new ArrayList<IRfScopeElement>();
        ArrayList<IRfScopeElement> elementEnclosingScopes = new ArrayList<IRfScopeElement>();
        ArrayList<Boolean> isElementTypeParameter = new ArrayList<Boolean>();
        if (operator.isReturnStatement()) {
            RfFunction enclosingFunc = scope.getEnclosingScope(RfFunction.class);
            if (enclosingFunc == null) {
                return;
            }
            lhValueHidObject = STransformer.makeStandInHid(enclosingFunc.getName(), enclosingFunc, new HidOccurrence(operator.getOccurrence().getOffset(), operator.getOccurrence().getVirtualOffset(), operator.getOccurrence().getLine(), 0L, null), 0L);
        } else if (operator.hasOccurrence(HidQualifierCache.IS_DECLARATION_ASSIGN_QUALIFIER)) {
            ISDataAbstract resolvedType = operator.getOperatorResolvedType();
            if (resolvedType == null) {
                return;
            }
            if (!(resolvedType instanceof SDataVariable)) {
                return;
            }
            IRfNamedElement declarationAssignElement = ((SDataVariable)resolvedType).getVariable();
            if (declarationAssignElement == null) {
                return;
            }
            if (!(declarationAssignElement instanceof RfField)) {
                return;
            }
            RfField declarationAssignmentField = (RfField)declarationAssignElement;
            if (declarationAssignmentField.isParameter() || declarationAssignmentField.isEnumElement()) {
                return;
            }
            lhValueHidObject = STransformer.makeStandInHid(declarationAssignmentField.getName(), declarationAssignmentField, new HidOccurrence(operator.getOccurrence().getOffset(), operator.getOccurrence().getVirtualOffset(), operator.getOccurrence().getLine(), 0L, null), 0L);
        } else {
            lhValueHidObject = operator.getLHValue();
            if ("argument".equals(operatorOriginType)) {
                if (!(lhValueHidObject instanceof RfHid)) {
                    return;
                }
                RfHid lhHid = (RfHid)((Object)lhValueHidObject);
                if (!(lhHid.getElement() instanceof RfField)) {
                    return;
                }
                RfField lhField = (RfField)lhHid.getElement();
                lhValueHidObject = STransformer.makeStandInHid(lhField.getName(), lhField, new HidOccurrence(operator.getOccurrence().getOffset(), operator.getOccurrence().getVirtualOffset(), operator.getOccurrence().getLine(), 0L, null), 0L);
            }
        }
        if (!this.checkHidAndPopulateArrays((IHidObject)lhValueHidObject, (List<IHidObject>)hidObjects, (List<RfHid>)valueRfHids, (List<IRfNamedElement>)elements, (List<RfNamedElement>)elementTypes, (List<Hid>)instanceHids, (List<IRfNamedElement>)ancestorElements, (List<IRfNamedElement>)instanceFieldOrFunctions, (List<IRfScopeElement>)ancestorElementEnclosingScopes, (List<IRfScopeElement>)elementEnclosingScopes, (List<Boolean>)isElementTypeParameter)) {
            return;
        }
        if (rhHidObject instanceof RfHidOperator) {
            flattenedRhHids = this.flattenToHidsFromOperator((RfHidOperator)rhHidObject);
            if (flattenedRhHids == null) {
                return;
            }
        } else {
            flattenedRhHids = Arrays.asList(rhHidObject);
        }
        List<RfHidImplicit> implicitsInRightHSide = flattenedRhHids.stream().filter(RfHidImplicit.class::isInstance).map(RfHidImplicit.class::cast).collect(Collectors.toList());
        List<IHidObject> nonImplicitsInRightHSide = flattenedRhHids.stream().filter(hid -> !(hid instanceof RfHidImplicit)).collect(Collectors.toList());
        for (IHidObject rhHidObjectOperator : nonImplicitsInRightHSide) {
            if (this.checkHidAndPopulateArrays(rhHidObjectOperator, hidObjects, valueRfHids, elements, elementTypes, instanceHids, ancestorElements, instanceFieldOrFunctions, ancestorElementEnclosingScopes, elementEnclosingScopes, isElementTypeParameter)) continue;
            return;
        }
        ArrayList<ELParamValuesHidEvaluator> hidEvaluators = new ArrayList<ELParamValuesHidEvaluator>();
        HashMap<IHidObject, String> pathsText = new HashMap<IHidObject, String>();
        if (ancestorElementEnclosingScopes.contains(null) || elementEnclosingScopes.contains(null) || ancestorElementEnclosingScopes.stream().anyMatch(ancestorElement -> this.specsPerElement.get(ancestorElement) == null) || ancestorElementEnclosingScopes.stream().distinct().count() != 1L || IntStream.range(0, elements.size()).allMatch(index -> !this.shouldEvaluateWithNonEmptyEvaluator((IRfNamedElement)elements.get(index), (IRfNamedElement)elementTypes.get(index), true))) {
            elements.forEach(element -> {
                boolean bl = hidEvaluators.add(this.emptyEvaluator);
            });
            this.checkSizes(implicitsInRightHSide, (IHidObject)lhValueHidObject, nonImplicitsInRightHSide, rhHidObject, (List<IHidObject>)hidObjects, (List<IRfNamedElement>)elements, (List<RfNamedElement>)elementTypes, (List<ELParamValuesHidEvaluator>)hidEvaluators, parserPath, operator, (Map<IHidObject, String>)pathsText, false, null, operatorOriginType, scope);
            return;
        }
        Map specializationWrappers = (Map)this.specsPerElement.get(ancestorElementEnclosingScopes.get(0));
        block1: for (ELSpecializationWrapper ancestorFieldWrapper : specializationWrappers.values()) {
            hidEvaluators.clear();
            pathsText.clear();
            IHidEvaluator defaultEvaluator = ancestorFieldWrapper.getHidEvaluator(this.elManager);
            if (!(defaultEvaluator instanceof ELParamValuesHidEvaluator) || ancestorFieldWrapper.paths == null) continue;
            int index2 = 0;
            while (index2 < elementEnclosingScopes.size()) {
                Map fieldSpecializationWrappers = (Map)this.specsPerElement.get(elementEnclosingScopes.get(index2));
                AbstractWidthMissmatchCheck.SpecInfo specInfo = this.getWrapperForInstance((Hid)instanceHids.get(index2), (IRfNamedElement)instanceFieldOrFunctions.get(index2), fieldSpecializationWrappers, defaultEvaluator, ancestorFieldWrapper.paths);
                IHidEvaluator fieldSpecializationEvaluator = specInfo.getEvaluator();
                if (!(fieldSpecializationEvaluator instanceof ELParamValuesHidEvaluator)) continue block1;
                hidEvaluators.add((ELParamValuesHidEvaluator)fieldSpecializationEvaluator);
                String pathText = specInfo.getPath() == null ? ancestorFieldWrapper.getPathsText() : specInfo.getPath();
                pathsText.put((IHidObject)hidObjects.get(index2), pathText);
                ++index2;
            }
            this.checkSizes(implicitsInRightHSide, (IHidObject)lhValueHidObject, nonImplicitsInRightHSide, rhHidObject, (List<IHidObject>)hidObjects, (List<IRfNamedElement>)elements, (List<RfNamedElement>)elementTypes, (List<ELParamValuesHidEvaluator>)hidEvaluators, parserPath, operator, (Map<IHidObject, String>)pathsText, true, ancestorFieldWrapper, operatorOriginType, scope);
            if (IntStream.range(0, elements.size()).allMatch(index -> !this.shouldEvaluateWithNonEmptyEvaluator((IRfNamedElement)elements.get(index), (IRfNamedElement)elementTypes.get(index), true))) break;
        }
    }

    protected abstract void checkSizes(List<RfHidImplicit> var1, IHidObject var2, List<IHidObject> var3, IHidObject var4, List<IHidObject> var5, List<IRfNamedElement> var6, List<RfNamedElement> var7, List<ELParamValuesHidEvaluator> var8, ParserPath var9, RfHidOperator var10, Map<IHidObject, String> var11, boolean var12, ELSpecializationWrapper var13, String var14, IRfNamedElement var15);

    protected abstract boolean checkRhSideHid(IHidObject var1);

    protected class AssignmentOperatorVisitor
    implements IHidVisitor<RfHidOperator> {
        private ParserPath parserPath;
        private RfNamedElement scope;

        protected AssignmentOperatorVisitor() {
        }

        public boolean visit(RfHidOperator operator) {
            if (AbstractMultipleOperandsAllAssignmentsWidthMissmatchCheck.this.checkPreWaivers(this.parserPath)) {
                return true;
            }
            AbstractMultipleOperandsAllAssignmentsWidthMissmatchCheck.this.notifyCheckAlive();
            if (!AbstractMultipleOperandsAllAssignmentsWidthMissmatchCheck.this.checkOperator(operator)) {
                return true;
            }
            AbstractMultipleOperandsAllAssignmentsWidthMissmatchCheck.this.analyzeOperator(operator, this.scope, this.parserPath, "assignment");
            return true;
        }

        public void setHolder(IHidHolder holder) {
            this.scope = (RfNamedElement)((RfHidHolder)holder).getScope();
        }

        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }

        public Class<RfHidOperator> getType() {
            return RfHidOperator.class;
        }
    }

    protected class MethodArgumentsVisitor
    implements IHidVisitor<RfHid> {
        private ParserPath parserPath;
        private RfNamedElement scope;

        protected MethodArgumentsVisitor() {
        }

        public boolean visit(RfHid hidObject) {
            if (AbstractMultipleOperandsAllAssignmentsWidthMissmatchCheck.this.checkPreWaivers(this.parserPath)) {
                return true;
            }
            AbstractMultipleOperandsAllAssignmentsWidthMissmatchCheck.this.notifyCheckAlive();
            if (!hidObject.isMethodCall(false)) {
                return true;
            }
            if (!(hidObject.getElement() instanceof RfFunction)) {
                return true;
            }
            if (!(hidObject.getFirstAccess() instanceof RfHidAccessArgs)) {
                return true;
            }
            List<? extends IHidObject> argumentValues = ((RfHidAccessArgs)hidObject.getFirstAccess()).getArgumentValues();
            if (argumentValues == null || argumentValues.isEmpty()) {
                return true;
            }
            for (IHidObject iHidObject : argumentValues) {
                if (!(iHidObject instanceof RfHidOperator)) {
                    return true;
                }
                RfHidOperator operator = (RfHidOperator)iHidObject;
                AbstractMultipleOperandsAllAssignmentsWidthMissmatchCheck.this.analyzeOperator(operator, this.scope, this.parserPath, "argument");
            }
            return true;
        }

        public void setHolder(IHidHolder holder) {
            this.scope = (RfNamedElement)((RfHidHolder)holder).getScope();
        }

        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }

        public Class<RfHid> getType() {
            return RfHid.class;
        }
    }
}

