/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperatorConstants;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.rules.AbstractWidthMissmatchCheck;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfAssociatedType;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfInterface;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfStruct;
import ro.amiq.vlogdt.model.reflection.predefined.RfBitVectorScalarType;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccessArgs;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

public abstract class AbstractMultipleOperandsWidthMissmatchCheck
extends AbstractWidthMissmatchCheck {
    protected AbstractMultipleOperandsWidthMissmatchCheck(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    public boolean checkHidAndPopulateArrays(IHidObject valueHidObject, List<IHidObject> hidObjects, List<RfHid> valueRfHids, List<IRfNamedElement> elements, List<RfNamedElement> elementTypes, List<Hid> instanceHids, List<IRfNamedElement> ancestorElements, List<IRfNamedElement> instanceFieldOrFunctions, List<IRfScopeElement> ancestorElementEnclosingScopes, List<IRfScopeElement> elementEnclosingScopes, List<Boolean> isElementTypeParameter) {
        String lhElementTypeName;
        IHidObject valueHid = valueHidObject;
        if (valueHid instanceof RfHidAccessArgs) {
            valueHid = ((RfHidAccessArgs)valueHid).getParentHid();
        }
        if (valueHid instanceof RfHidAccess) {
            valueHid = ((RfHidAccess)valueHid).getParentHid();
        }
        if (!(valueHid instanceof RfHid) || !(((RfHid)valueHid).getElement() instanceof RfField) && !(((RfHid)valueHid).getElement() instanceof RfFunction)) {
            return false;
        }
        RfHid valueRfHid = (RfHid)valueHid;
        IRfNamedElement element = valueRfHid.getElement();
        if (!(element instanceof RfField) && !(element instanceof RfFunction)) {
            return false;
        }
        if (element instanceof RfField && ((RfField)element).isGenvar()) {
            return false;
        }
        if (element instanceof RfField && ((RfField)element).isParameterNoDataType()) {
            return false;
        }
        RfNamedElement elementType = this.getAssociatedFinalType((RfAssociatedType)element);
        if (elementType == null) {
            return false;
        }
        if (elementType instanceof RfBitVectorScalarType) {
            elementType = ((RfBitVectorScalarType)elementType).getScalarWithDefaultSign();
        }
        if (elementType instanceof RfStruct && ((RfStruct)elementType).getEnumBaseType() instanceof RfNamedElement) {
            elementType = (RfNamedElement)((RfStruct)elementType).getEnumBaseType();
        }
        if ("string".equals(lhElementTypeName = elementType.getName())) {
            return false;
        }
        if (!(valueRfHid.getAncestorHid().getElement() instanceof RfField) && !(valueRfHid.getAncestorHid().getElement() instanceof RfFunction)) {
            return false;
        }
        IRfNamedElement ancestorElement = valueRfHid.getAncestorHid().getElement();
        if (ancestorElement == null) {
            return false;
        }
        Hid instanceHid = this.getFirstParentInstanceHid(valueRfHid);
        if (instanceHid == null) {
            return false;
        }
        if (!(instanceHid.getElement() instanceof RfField) && !(instanceHid.getElement() instanceof RfFunction)) {
            return false;
        }
        IRfNamedElement instanceFieldOrFunction = instanceHid.getElement();
        IRfScopeElement ancestorElementEnclosingScope = ancestorElement.getEnclosingScope(new HashSet<Class>(Arrays.asList(RfModule.class, RfInterface.class)));
        IRfScopeElement elementEnclosingScope = element.getEnclosingScope(new HashSet<Class>(Arrays.asList(RfModule.class, RfInterface.class)));
        hidObjects.add(valueHidObject);
        valueRfHids.add(valueRfHid);
        elements.add(element);
        elementTypes.add(elementType);
        ancestorElements.add(ancestorElement);
        instanceHids.add(instanceHid);
        instanceFieldOrFunctions.add(instanceFieldOrFunction);
        ancestorElementEnclosingScopes.add(ancestorElementEnclosingScope);
        elementEnclosingScopes.add(elementEnclosingScope);
        isElementTypeParameter.add(elementType instanceof RfField && ((RfField)elementType).isTypeParameter());
        return true;
    }

    public boolean checkIfSkipTypes(IHidObject hidObj, Set<String> pSkipTypes) {
        if (hidObj instanceof RfHidAccessArgs) {
            hidObj = ((RfHidAccessArgs)hidObj).getParentHid();
        }
        if (hidObj instanceof RfHidAccess) {
            hidObj = ((RfHidAccess)hidObj).getParentHid();
        }
        if (!(hidObj instanceof RfHid)) {
            return false;
        }
        RfHid valueRfHid = (RfHid)hidObj;
        IRfNamedElement elementVal = valueRfHid.getElement();
        if (!(elementVal instanceof RfField) && !(elementVal instanceof RfFunction)) {
            return false;
        }
        RfNamedElement elementType = this.getAssociatedFinalTypeResolveAlias((RfAssociatedType)elementVal);
        if (elementType instanceof RfBitVectorScalarType) {
            elementType = ((RfBitVectorScalarType)elementType).getScalarWithDefaultSign();
        }
        if (elementType instanceof RfStruct && ((RfStruct)elementType).getEnumBaseType() instanceof RfNamedElement) {
            elementType = (RfNamedElement)((RfStruct)elementType).getEnumBaseType();
        }
        if (elementType == null) {
            return false;
        }
        return pSkipTypes.contains(elementType.getName());
    }

    protected Collection<IHidObject> flattenToHidsFromOperator(RfHidOperator operator) {
        ArrayList<IHidObject> flattenedHids = new ArrayList<IHidObject>();
        Set flattenOP = HidUtils.flattenToOperators((IHidOperator)operator);
        for (IHidOperator op : flattenOP) {
            if (!(op instanceof RfHidOperator)) {
                return null;
            }
            operator = (RfHidOperator)op;
            if (operator.getRHValues() == null || !this.checkOperatorsInRHSide(operator)) {
                return null;
            }
            if (!(operator.getLHValue() instanceof RfHidOperator)) {
                flattenedHids.add(operator.getLHValue());
            }
            for (IHidObject operand : operator.getRHValues()) {
                if (operand instanceof RfHidOperator) continue;
                flattenedHids.add(operand);
            }
        }
        return flattenedHids;
    }

    protected void calculateSizeOfImplicit(RfHidImplicit implicit, Map<IHidObject, int[]> dimensionsForHid, IRfNamedElement scope) {
        int[] implicitSize;
        if (LintUtils.isImplicitUnsized(implicit)) {
            int[] nArray = new int[2];
            nArray[0] = 31;
            implicitSize = nArray;
            if ("'1".equals(implicit.getName()) || "'0".equals(implicit.getName()) || "1".equals(implicit.getName()) || "0".equals(implicit.getName())) {
                dimensionsForHid.put((IHidObject)implicit, new int[0]);
                return;
            }
        } else {
            implicitSize = this.getSizeOfHid((IHidObject)implicit, null, null, this.emptyEvaluator, null, scope);
        }
        if (implicitSize == null) {
            return;
        }
        if (implicitSize.length == 1) {
            int[] nArray = new int[2];
            nArray[0] = this.getNumberOfBitsUsedInInteger(implicitSize[0]) - 1;
            dimensionsForHid.put((IHidObject)implicit, nArray);
        } else {
            dimensionsForHid.put((IHidObject)implicit, implicitSize);
        }
    }

    protected abstract boolean checkOperatorsInRHSide(RfHidOperator var1);

    protected int[] calculateSizeOfHid(IHidObject hidObject, Map<IHidObject, int[]> fieldDimensionsForHid) {
        if (hidObject instanceof RfHidOperator) {
            RfHidOperator operator = (RfHidOperator)hidObject;
            IHidObject lhOperand = operator.getLHValue();
            IHidObject rhOperand = operator.getFirstRHValue();
            if (operator.getOperatorKind() == IHidOperatorConstants.OperatorKind.BINARY_OPERATOR) {
                if (operator.isPlus()) {
                    return this.addDimensionToArray(this.getMaximumOfArrays(this.calculateSizeOfHid(lhOperand, fieldDimensionsForHid), this.calculateSizeOfHid(rhOperand, fieldDimensionsForHid)));
                }
                if (operator.isMinus() || operator.isBinaryBAnd() || operator.isBinaryOr() || operator.isBinaryBXor() || operator.isBinaryXNor()) {
                    return this.getMaximumOfArrays(this.calculateSizeOfHid(lhOperand, fieldDimensionsForHid), this.calculateSizeOfHid(rhOperand, fieldDimensionsForHid));
                }
                if (operator.isStar()) {
                    return this.getSumOfArrays(this.calculateSizeOfHid(lhOperand, fieldDimensionsForHid), this.calculateSizeOfHid(rhOperand, fieldDimensionsForHid));
                }
                if (operator.isDiv() || operator.isModulo() || operator.isArithmeticShift() || operator.isLogicalShiftLeft() || operator.isLogicalShiftRight()) {
                    return this.calculateSizeOfHid(lhOperand, fieldDimensionsForHid);
                }
                if (operator.isPowDoubleStar()) {
                    return this.getProductOfArrays(this.calculateSizeOfHid(lhOperand, fieldDimensionsForHid), this.calculateSizeOfHid(rhOperand, fieldDimensionsForHid));
                }
                if (534 == operator.getOperatorType() || operator.isLogical() || operator.isRelational() || operator.isEqualityOrInequality() || operator.isWildcardEquality()) {
                    return this.reduceArray(this.calculateSizeOfHid(lhOperand, fieldDimensionsForHid));
                }
            } else if (operator.getOperatorKind() == IHidOperatorConstants.OperatorKind.UNARY_OPERATOR) {
                if (operator.isBitwiseNot() || operator.isPlus() || operator.isMinus()) {
                    return this.calculateSizeOfHid(lhOperand, fieldDimensionsForHid);
                }
                if (operator.isReduction()) {
                    return this.reduceArray(this.calculateSizeOfHid(lhOperand, fieldDimensionsForHid));
                }
            } else if (operator.isVLOGConcatenation(true)) {
                if (operator.getFirstRHValue() == null) {
                    return null;
                }
                int[] result = this.calculateSizeOfHid(operator.getFirstRHValue(), fieldDimensionsForHid);
                int i = 1;
                while (i < operator.getRHValues().size()) {
                    result = this.getSumOfArrays(result, this.calculateSizeOfHid((IHidObject)operator.getRHValues().get(i), fieldDimensionsForHid));
                    ++i;
                }
                return result;
            }
            return this.calculateSizeOfHid(lhOperand, fieldDimensionsForHid);
        }
        return fieldDimensionsForHid.getOrDefault(hidObject, null);
    }

    protected int[] getMaximumOfArrays(int[] a, int[] b) {
        if (a == null || b == null) {
            return null;
        }
        int[] bigger = a.length > b.length ? a : b;
        int[] smaller = a.length > b.length ? b : a;
        int[] result = Arrays.copyOf(bigger, bigger.length);
        if (smaller.length == 0) {
            smaller = bigger;
        }
        int i = 0;
        while (i < smaller.length) {
            result[i] = Math.max(bigger[i], smaller[i]);
            result[i + 1] = 0;
            i += 2;
        }
        return result;
    }

    protected int[] addDimensionToArray(int[] a) {
        if (a == null) {
            return null;
        }
        int[] result = Arrays.copyOf(a, a.length);
        int i = 0;
        while (i < a.length) {
            result[i] = a[i] + 1;
            result[i + 1] = 0;
            i += 2;
        }
        return result;
    }

    protected int[] getSumOfArrays(int[] a, int[] b) {
        if (a == null || b == null) {
            return null;
        }
        int[] bigger = a.length > b.length ? a : b;
        int[] smaller = a.length > b.length ? b : a;
        int[] result = Arrays.copyOf(bigger, bigger.length);
        if (smaller.length == 0) {
            smaller = bigger;
        }
        int i = 0;
        while (i < smaller.length) {
            result[i] = this.getSizeOfSumOf2Dimensions(bigger[i], bigger[i + 1], smaller[i], smaller[i + 1]) - 1;
            result[i + 1] = 0;
            i += 2;
        }
        return result;
    }

    protected int getSizeOfSumOf2Dimensions(int aBig, int aSmall, int bBig, int bSmall) {
        return Math.abs(aBig - aSmall) + Math.abs(bBig - bSmall) + 2;
    }

    protected int[] getProductOfArrays(int[] a, int[] b) {
        if (a == null || b == null) {
            return null;
        }
        int[] bigger = a.length > b.length ? a : b;
        int[] smaller = a.length > b.length ? b : a;
        int[] result = Arrays.copyOf(bigger, bigger.length);
        if (smaller.length == 0) {
            smaller = bigger;
        }
        int i = 0;
        while (i < smaller.length) {
            result[i] = this.getSizeOfProductOf2Dimensions(bigger[i], bigger[i + 1], smaller[i], smaller[i + 1]) - 1;
            result[i + 1] = 0;
            i += 2;
        }
        return result;
    }

    protected int getSizeOfProductOf2Dimensions(int aBig, int aSmall, int bBig, int bSmall) {
        return (Math.abs(aBig - aSmall) + 1) * (Math.abs(bBig - bSmall) + 1);
    }

    protected int[] reduceArray(int[] a) {
        if (a == null) {
            return null;
        }
        return new int[a.length];
    }
}

