/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.utils.IWhitespaceParserCheck;
import ro.amiq.vlogdt.linter.utils.LiteralToken;
import ro.amiq.vlogdt.linter.utils.SVTBWhitespaceParser;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.parser.VlogFileInstance;
import ro.amiq.vlogdt.parser.VlogPreprocessingInfo;

public abstract class AbstractPathIncludeCheck
extends OVMComplianceCheck
implements IWhitespaceParserCheck {
    private static final String INCLUDE_STRING = "`include";

    protected AbstractPathIncludeCheck(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        RfProject rfProject = this.fOVMProject.getRfProject();
        if (rfProject == null) {
            return;
        }
        Map<ParserPath, Set<Integer>> filesWithIncludes = this.getAllFilesWithIncludes();
        if (filesWithIncludes.isEmpty()) {
            return;
        }
        for (Map.Entry<ParserPath, Set<Integer>> entry : filesWithIncludes.entrySet()) {
            ParserPath path = entry.getKey();
            Set<Integer> lines = entry.getValue();
            if (this.checkPreWaivers(path)) continue;
            this.notifyCheckAlive();
            for (Integer line : lines) {
                List<LiteralToken> literalTokens = this.getWSParser().getTokensOnLine(path, line);
                boolean foundToken = false;
                int i = 0;
                while (i < literalTokens.size() && !foundToken) {
                    block7: {
                        String filePath;
                        LiteralToken filePathToken;
                        block9: {
                            String currentString;
                            LiteralToken token;
                            block8: {
                                token = literalTokens.get(i);
                                if (token.getZone() != SVTBWhitespaceParser.ZoneType.CODE && token.getZone() != SVTBWhitespaceParser.ZoneType.STRING) break block7;
                                currentString = token.getStringToken();
                                LiteralToken nextToken = this.getWSParser().getNextToken(token, path);
                                foundToken = true;
                                if (!INCLUDE_STRING.equals(currentString)) break block8;
                                while (nextToken != null && !this.isFilePathTokenCandidate(nextToken)) {
                                    token = nextToken;
                                    nextToken = this.getWSParser().getNextToken(nextToken, path);
                                }
                                if (nextToken == null) break block7;
                                filePathToken = nextToken;
                                filePath = filePathToken.getStringToken();
                                break block9;
                            }
                            filePathToken = token;
                            filePath = currentString.startsWith(INCLUDE_STRING) ? currentString.substring(INCLUDE_STRING.length()) : currentString;
                        }
                        if (this.isFilePath(filePath)) {
                            this.analyzeFilePath(filePath, path, filePathToken.getLineNumber());
                        }
                    }
                    ++i;
                }
            }
        }
    }

    protected abstract void analyzeFilePath(String var1, ParserPath var2, int var3);

    private boolean isFilePath(String string) {
        char first = string.charAt(0);
        char last = string.charAt(string.length() - 1);
        return first == '<' && last == '>' || first == '\"' && last == '\"';
    }

    private boolean isFilePathTokenCandidate(LiteralToken currentToken) {
        return currentToken.getZone() == SVTBWhitespaceParser.ZoneType.CODE || currentToken.getZone() == SVTBWhitespaceParser.ZoneType.STRING;
    }

    private boolean checkPreWaivers(ParserPath parserPath) {
        if (parserPath == null) {
            return true;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    private Map<ParserPath, Set<Integer>> getAllFilesWithIncludes() {
        HashMap<ParserPath, Set<Integer>> result = new HashMap<ParserPath, Set<Integer>>();
        VlogPreprocessingInfo preprocessingTable = this.fOVMProject.getRfProject().getPreprocessingTable();
        VlogFileInstance topFile = preprocessingTable.getTopFileInstance();
        if (topFile == null) {
            return result;
        }
        ArrayList<VlogFileInstance> includedfiles = new ArrayList<VlogFileInstance>();
        includedfiles.addAll(topFile.getIncludedInstances());
        int i = 0;
        while (i < includedfiles.size()) {
            String name = ((VlogFileInstance)includedfiles.get(i)).getShortFileName();
            List<VlogFileInstance> includedInstances = ((VlogFileInstance)includedfiles.get(i)).getIncludedInstances();
            if (name.startsWith("__vlog__") && name.endsWith(".libfile")) {
                includedfiles.addAll(includedInstances);
            }
            ParserPath parserPath = ((VlogFileInstance)includedfiles.get(i)).getParserPath();
            includedfiles.addAll(includedInstances);
            if (!includedInstances.isEmpty()) {
                HashSet<Integer> lines = (HashSet<Integer>)result.get(parserPath);
                if (lines == null) {
                    lines = new HashSet<Integer>();
                    result.put(parserPath, lines);
                }
                for (VlogFileInstance instance : includedInstances) {
                    lines.add(instance.getIncludingScope().getIncludingLine());
                }
            }
            ++i;
        }
        return result;
    }
}

