/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidHolder;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.linter.utils.OVMUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfSpecializedClass;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;

public abstract class AbstractPipelineDriverCheck
extends OVMComplianceCheck {
    protected static final String GET_NEXT_ITEM = "get_next_item";
    protected static final String ITEM_DONE = "item_done";
    protected RfClass ovmBasePort;
    protected RfClass ovmEvent;

    protected AbstractPipelineDriverCheck(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        String xvm = OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "");
        this.ovmBasePort = this.fOVMProject.getRfProject().getClass(String.valueOf(xvm) + "_pkg::" + xvm + "_port_base", true);
        this.ovmEvent = this.fOVMProject.getRfProject().getClass(String.valueOf(xvm) + "_pkg::" + xvm + "_event", true);
        if (this.fOVMProject.fOvmDriver == null || this.ovmBasePort == null || this.ovmEvent == null) {
            return;
        }
        Set<RfClass> drivers = this.fOVMProject.getAllXVMSubClasses(this.fOVMProject.fOvmDriver);
        if (drivers.isEmpty()) {
            return;
        }
        for (RfClass driver : drivers) {
            if (driver.getDeclaration() != null && this.checkPreWaivers(driver.getDeclaration().getParserPath())) continue;
            this.notifyCheckAlive();
            this.checkDriver(driver);
        }
    }

    protected abstract void checkDriver(RfClass var1);

    private boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    protected class AbstractVisitor
    extends RfHidVisitor {
        private Map<RfFunction, Set<String>> pipelineMethodCalls = new HashMap<RfFunction, Set<String>>();

        protected AbstractVisitor() {
        }

        public boolean visit(RfHid hidObject) {
            IRfNamedElement element = hidObject.getElement();
            if (element instanceof RfFunction) {
                RfFunction function = (RfFunction)element;
                IRfNamedElement scope = ((HidHolder)this.holder).getScope();
                if (scope == null) {
                    return true;
                }
                RfFunction functionScope = (RfFunction)scope.getEnclosingScope(RfFunction.class);
                if (functionScope == null) {
                    return true;
                }
                this.additionalMethodChecks(hidObject, function, functionScope);
                if (!AbstractPipelineDriverCheck.GET_NEXT_ITEM.equals(function.getName()) && !AbstractPipelineDriverCheck.ITEM_DONE.equals(function.getName())) {
                    return true;
                }
                IRfNamedElement declarationScope = function.getEnclosingScope(new HashSet<Class>(Arrays.asList(RfClass.class, RfSpecializedClass.class)));
                if (!(declarationScope instanceof RfClass)) {
                    return true;
                }
                RfClass declarationClass = (RfClass)declarationScope;
                if (!AbstractPipelineDriverCheck.this.ovmBasePort.equals(declarationClass) && !LintUtils.isSubClassOf(declarationClass, AbstractPipelineDriverCheck.this.ovmBasePort)) {
                    return true;
                }
                this.setPipeline(function, functionScope);
            } else if (element instanceof RfField) {
                this.additionalFieldChecks((RfField)element);
            }
            return true;
        }

        protected void setPipeline(RfFunction function, RfFunction functionScope) {
            Set<String> pipelineMethodsInScope = this.pipelineMethodCalls.get(functionScope);
            if (pipelineMethodsInScope == null) {
                pipelineMethodsInScope = new HashSet<String>();
                this.pipelineMethodCalls.put(functionScope, pipelineMethodsInScope);
            }
            pipelineMethodsInScope.add(function.getName());
        }

        protected void additionalMethodChecks(RfHid hidObject, RfFunction function, RfFunction functionScope) {
        }

        protected void additionalFieldChecks(RfField field) {
        }

        public boolean isPipeline() {
            if (this.pipelineMethodCalls.isEmpty()) {
                return false;
            }
            if (this.pipelineMethodCalls.keySet().size() != 1) {
                return false;
            }
            RfFunction method = this.pipelineMethodCalls.keySet().iterator().next();
            if ("run_phase".equals(method.getName())) {
                return false;
            }
            Set<String> callsInMethod = this.pipelineMethodCalls.get(method);
            return callsInMethod != null && callsInMethod.size() == 2;
        }
    }
}

