/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.linter.utils.OVMUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;

public abstract class AbstractRaiseAndDropObjectionCheck
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="uvm_pkg::uvm_sequence", description="Comma separated list of classes for whose children methods are skipped.", name="skipBaseClasses", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pSkippedBaseClasses;
    private static final String RAISE_OBJECTION = "raise_objection";
    private static final String DROP_OBJECTION = "drop_objection";
    private static final String PHASE_RAISE_OBJECTION = "_phase.raise_objection";
    private static final String OBJECTION_RAISE_OBJECTION = "_objection.raise_objection";
    private static final String TEST_DONE_RAISE_OBJECTION = "_test_done_objection.raise_objection";
    private static final String PHASE_DROP_OBJECTION = "_phase.drop_objection";
    private static final String OBJECTION_DROP_OBJECTION = "_objection.drop_objection";
    private static final String TEST_DONE_DROP_OBJECTION = "_test_done_objection.drop_objection";
    private Set<String> objectionRelatedMethodsFullName;

    protected AbstractRaiseAndDropObjectionCheck(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
        int kind = this.fOVMProject.getLibraryKind();
        String libraryPkg = OVMUtils.prependLibraryPrefixTo(kind, "_pkg::");
        this.objectionRelatedMethodsFullName = new HashSet<String>();
        if (kind == 2) {
            this.objectionRelatedMethodsFullName.add(String.valueOf(libraryPkg) + OVMUtils.prependLibraryPrefixTo(kind, PHASE_RAISE_OBJECTION));
            this.objectionRelatedMethodsFullName.add(String.valueOf(libraryPkg) + OVMUtils.prependLibraryPrefixTo(kind, PHASE_DROP_OBJECTION));
        }
        this.objectionRelatedMethodsFullName.add(String.valueOf(libraryPkg) + OVMUtils.prependLibraryPrefixTo(kind, OBJECTION_RAISE_OBJECTION));
        this.objectionRelatedMethodsFullName.add(String.valueOf(libraryPkg) + OVMUtils.prependLibraryPrefixTo(kind, OBJECTION_DROP_OBJECTION));
        this.objectionRelatedMethodsFullName.add(String.valueOf(libraryPkg) + OVMUtils.prependLibraryPrefixTo(kind, TEST_DONE_RAISE_OBJECTION));
        this.objectionRelatedMethodsFullName.add(String.valueOf(libraryPkg) + OVMUtils.prependLibraryPrefixTo(kind, TEST_DONE_DROP_OBJECTION));
    }

    @Override
    public void performCheckImpl() {
        HashSet<RfClass> skippedBaseClasses = new HashSet<RfClass>();
        if (this.pSkippedBaseClasses != null) {
            for (String className : this.pSkippedBaseClasses) {
                RfClass tmpClazz = this.fOVMProject.getRfProject().getClass(className, true);
                if (tmpClazz == null) continue;
                skippedBaseClasses.add(tmpClazz);
            }
        }
        for (RfNamedElement clazz : this.fOVMProject.getAllNonXVMClasses()) {
            List<RfFunction> functions;
            ParserPath classParserPath;
            if (!(clazz instanceof RfClass)) continue;
            this.notifyCheckAlive();
            RfFileDef classFile = clazz.getFile();
            if (classFile == null || (classParserPath = classFile.getParserPath()) == null || this.fOVMProject.getProjectWaivers().pathIsPrewaived(classParserPath, this)) continue;
            boolean isSkipped = false;
            for (RfClass skippedClass : skippedBaseClasses) {
                if (!LintUtils.isSubClassOf((RfClass)clazz, skippedClass)) continue;
                isSkipped = true;
                break;
            }
            if (isSkipped || (functions = clazz.getLocalMembers(RfFunction.class)) == null || functions.isEmpty()) continue;
            for (RfFunction function : functions) {
                if (function.isPredefined()) continue;
                this.notifyCheckAlive();
                LinkedList<ObjectionInfo> raiseArguments = new LinkedList<ObjectionInfo>();
                LinkedList<ObjectionInfo> dropArguments = new LinkedList<ObjectionInfo>();
                function.visitHidObject(this.fOVMProject.getRfProject(), new RfHidObjectionCallsVisitor(raiseArguments, dropArguments));
                this.checkRaiseAndDropCalls(raiseArguments, dropArguments, classParserPath, function);
            }
        }
    }

    abstract void checkRaiseAndDropCalls(List<ObjectionInfo> var1, List<ObjectionInfo> var2, ParserPath var3, RfFunction var4);

    protected boolean checkCorrespondingHid(RfHid raiseHid, RfHid raiseArg, RfHid dropHid, RfHid dropArg) {
        boolean hasSameParent;
        boolean bl = hasSameParent = raiseHid.getParentHid() != null && dropHid.getParentHid() != null && raiseHid.getParentHid().equals((Object)dropHid.getParentHid());
        return hasSameParent && this.checkOffsets(raiseHid, dropHid) && raiseArg.equals((Object)dropArg);
    }

    private boolean checkOffsets(RfHid raiseHid, RfHid dropHid) {
        int dropOffset;
        int raiseOffset = raiseHid.getOccurrence().getOffset();
        return raiseOffset < (dropOffset = dropHid.getOccurrence().getOffset()) || raiseOffset == dropOffset && raiseHid.getVirtualOffset() < dropHid.getVirtualOffset();
    }

    protected static class ObjectionInfo {
        private RfHid objectionCall;
        private RfHid objectionParam;

        public ObjectionInfo(RfHid objectionCall, RfHid objectionParam) {
            this.objectionCall = objectionCall;
            this.objectionParam = objectionParam;
        }

        public RfHid getObjectionCall() {
            return this.objectionCall;
        }

        public RfHid getObjectionParam() {
            return this.objectionParam;
        }
    }

    private final class RfHidObjectionCallsVisitor
    extends RfHidVisitor {
        private final List<ObjectionInfo> raiseFirstArguments;
        private final List<ObjectionInfo> dropFirstArguments;

        private RfHidObjectionCallsVisitor(List<ObjectionInfo> raiseFirstArguments, List<ObjectionInfo> dropFirstArguments) {
            this.raiseFirstArguments = raiseFirstArguments;
            this.dropFirstArguments = dropFirstArguments;
        }

        public boolean visit(RfHid hid) {
            if (hid == null) {
                return true;
            }
            if (!hid.isMethodCall(false)) {
                return true;
            }
            if (!this.checkMethodIsObjectionRelated(hid)) {
                return true;
            }
            List methodCalls = MethodCallUtils.getMethodCalls((IHid)hid);
            if (methodCalls == null || methodCalls.isEmpty()) {
                return true;
            }
            for (MethodCall call : methodCalls) {
                RfHid objParamHid;
                if (call.argumentValuesMapRaw == null || call.argumentValuesMapRaw.isEmpty() || (objParamHid = this.getObjParameterHid(call)) == null) continue;
                String methodName = call.getMethodName();
                if (AbstractRaiseAndDropObjectionCheck.RAISE_OBJECTION.equals(methodName)) {
                    this.raiseFirstArguments.add(new ObjectionInfo(hid, objParamHid));
                } else if (AbstractRaiseAndDropObjectionCheck.DROP_OBJECTION.equals(methodName)) {
                    this.dropFirstArguments.add(new ObjectionInfo(hid, objParamHid));
                }
                return true;
            }
            return true;
        }

        private RfHid getObjParameterHid(MethodCall call) {
            RfHid objParamHid = null;
            for (Map.Entry entry : call.argumentValuesMapRaw.entrySet()) {
                if (!"obj".equals(((IRfFieldElement)entry.getKey()).getName()) || !(entry.getValue() instanceof RfHid)) continue;
                objParamHid = (RfHid)((Object)entry.getValue());
                break;
            }
            return objParamHid;
        }

        private boolean checkMethodIsObjectionRelated(RfHid hid) {
            IRfNamedElement hidNamedElement = hid.getElement();
            if (!(hidNamedElement instanceof RfFunction)) {
                return false;
            }
            RfFunction localFunctionCall = (RfFunction)hidNamedElement;
            String functionName = localFunctionCall.getName();
            if (functionName == null) {
                return false;
            }
            if (!AbstractRaiseAndDropObjectionCheck.RAISE_OBJECTION.equals(functionName) && !AbstractRaiseAndDropObjectionCheck.DROP_OBJECTION.equals(functionName)) {
                return false;
            }
            String fullName = LintUtils.getNamedElementFullName(localFunctionCall);
            return fullName != null && AbstractRaiseAndDropObjectionCheck.this.objectionRelatedMethodsFullName.contains(fullName);
        }
    }
}

