/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.HashSet;
import java.util.Set;
import ro.amiq.vlogdt.linter.LintingSemanticHit;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.model.reflection.RfProject;

public class AbstractSemanticLintingCheck
extends OVMComplianceCheck {
    protected Set<String> patterns = new HashSet<String>();

    public AbstractSemanticLintingCheck(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void preBuildNotification(RfProject aRfProject) {
        for (String pattern : this.patterns) {
            this.fOVMProject.registerSemanticCheck(pattern);
        }
    }

    @Override
    public void performCheckImpl() {
        if (this.patterns == null || this.patterns.isEmpty()) {
            return;
        }
        for (String pattern : this.patterns) {
            this.notifyCheckAlive();
            Set<LintingSemanticHit> hits = this.fOVMProject.getSemanticCheckPatternHits(pattern);
            if (hits == null) {
                return;
            }
            for (LintingSemanticHit hit : hits) {
                this.addHit(hit.getParserPath(), hit.getLine(), hit.getMessage(), null, false);
            }
        }
    }
}

