/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import ro.amiq.dvt.elaboration.ELConstants;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.core.ELInstance;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.elaboration.model.ELParamValueScope;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.elaboration.model.ELParamValuesHidEvaluator;
import ro.amiq.dvt.elaboration.model.IELMemory;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluationGuardian;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension2.DummyDataType;
import ro.amiq.dvt.model.reflection.semantic.extension2.ISDataAbstract;
import ro.amiq.dvt.model.reflection.semantic.extension2.SDataVariable;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.search.DocumentManager;
import ro.amiq.dvt.utils.DVTNumber;
import ro.amiq.dvt.utils.VlogBitVector;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfAssertExpect;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfInstance;
import ro.amiq.vlogdt.model.reflection.RfInstanceHolder;
import ro.amiq.vlogdt.model.reflection.RfInterface;
import ro.amiq.vlogdt.model.reflection.RfListType;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProgram;
import ro.amiq.vlogdt.model.reflection.RfResultImplicitVariable;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedFunction;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

public abstract class AbstractUnallowedCrossModuleReferenceCheck
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="", description="Comma separated list of module or interface name patterns where cross module references are allowed.", name="allowedXMRScopes", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_REGEX)
    private HashSet<Pattern> pAllowedXMRScopes;
    @CheckParameter(defaultValue="full, upward, downward", description="Comma separated list of module reference types that are going to be checked: full, upward, downward.", name="moduleReferenceTypes", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    protected HashSet<String> pModuleReferenceTypes;
    @CheckParameter(defaultValue="false", description="Include details for the XMRs like offset, full declaration type and signal width.", name="includeXMRDetails", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    protected boolean pIncludeXMRDetails;
    private static final Set<String> LIST_WRITE_METHODS = new HashSet<String>();
    private static final Set<String> LIST_READ_METHODS = new HashSet<String>();
    private static final Set<String> ASSOCIATIVE_ARRAY_WRITE_METHODS = new HashSet<String>();
    private static final Set<String> ASSOCIATIVE_ARRAY_READ_METHODS = new HashSet<String>();
    private static final Set<String> DYNAMIC_ARRAY_WRITE_METHODS = new HashSet<String>();
    private static final Set<String> DYNAMIC_ARRAY_READ_METHODS = new HashSet<String>();
    private static final Set<String> QUEUE_WRITE_METHODS = new HashSet<String>();
    private static final Set<String> QUEUE_READ_METHODS = new HashSet<String>();
    protected boolean checkFullReference;
    protected boolean checkUpwardReference;
    protected boolean checkDownwardReference;
    protected Set<RfNamedElement> topModules;
    private Map<ElementPath, Set<IRfInstanceElement>> childrenOfElementPathCache;
    private Map<RfNamedElement, List<ELInstance>> scopeInstancesCache;
    Map<ParserPath, Set<HidOccurrence>> readElements;
    Map<ParserPath, Set<HidOccurrence>> writtenElements;
    DocumentManager documentManager;

    static {
        LIST_WRITE_METHODS.add("reverse");
        LIST_WRITE_METHODS.add("sort");
        LIST_WRITE_METHODS.add("rsort");
        LIST_WRITE_METHODS.add("shuffle");
        LIST_READ_METHODS.add("and");
        LIST_READ_METHODS.add("find");
        LIST_READ_METHODS.add("find_first");
        LIST_READ_METHODS.add("find_first_index");
        LIST_READ_METHODS.add("find_index");
        LIST_READ_METHODS.add("find_last");
        LIST_READ_METHODS.add("find_last_index");
        LIST_READ_METHODS.add("max");
        LIST_READ_METHODS.add("min");
        LIST_READ_METHODS.add("or");
        LIST_READ_METHODS.add("product");
        LIST_READ_METHODS.add("sum");
        LIST_READ_METHODS.add("unique");
        LIST_READ_METHODS.add("unique_index");
        LIST_READ_METHODS.add("xor");
        ASSOCIATIVE_ARRAY_WRITE_METHODS.addAll(LIST_WRITE_METHODS);
        ASSOCIATIVE_ARRAY_WRITE_METHODS.add("delete");
        ASSOCIATIVE_ARRAY_READ_METHODS.addAll(LIST_READ_METHODS);
        ASSOCIATIVE_ARRAY_READ_METHODS.add("empty");
        ASSOCIATIVE_ARRAY_READ_METHODS.add("exists");
        ASSOCIATIVE_ARRAY_READ_METHODS.add("first");
        ASSOCIATIVE_ARRAY_READ_METHODS.add("last");
        ASSOCIATIVE_ARRAY_READ_METHODS.add("next");
        ASSOCIATIVE_ARRAY_READ_METHODS.add("num");
        ASSOCIATIVE_ARRAY_READ_METHODS.add("prev");
        ASSOCIATIVE_ARRAY_READ_METHODS.add("size");
        DYNAMIC_ARRAY_WRITE_METHODS.addAll(LIST_WRITE_METHODS);
        DYNAMIC_ARRAY_WRITE_METHODS.add("delete");
        DYNAMIC_ARRAY_WRITE_METHODS.add("new");
        DYNAMIC_ARRAY_READ_METHODS.addAll(LIST_READ_METHODS);
        DYNAMIC_ARRAY_READ_METHODS.add("size");
        QUEUE_WRITE_METHODS.addAll(LIST_WRITE_METHODS);
        QUEUE_WRITE_METHODS.add("delete");
        QUEUE_WRITE_METHODS.add("insert");
        QUEUE_WRITE_METHODS.add("pop_back");
        QUEUE_WRITE_METHODS.add("pop_front");
        QUEUE_WRITE_METHODS.add("push_back");
        QUEUE_WRITE_METHODS.add("push_front");
        QUEUE_READ_METHODS.addAll(LIST_READ_METHODS);
        QUEUE_READ_METHODS.add("empty");
        QUEUE_READ_METHODS.add("size");
        QUEUE_READ_METHODS.add("pick");
        QUEUE_READ_METHODS.add("pop_back");
        QUEUE_READ_METHODS.add("pop_front");
    }

    protected AbstractUnallowedCrossModuleReferenceCheck(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.checkFullReference = this.pModuleReferenceTypes.contains("full");
        this.checkUpwardReference = this.pModuleReferenceTypes.contains("upward");
        this.checkDownwardReference = this.pModuleReferenceTypes.contains("downward");
        this.childrenOfElementPathCache = new HashMap<ElementPath, Set<IRfInstanceElement>>();
        this.scopeInstancesCache = new HashMap<RfNamedElement, List<ELInstance>>();
        this.readElements = new HashMap<ParserPath, Set<HidOccurrence>>();
        this.writtenElements = new HashMap<ParserPath, Set<HidOccurrence>>();
        this.topModules = this.checkFullReference ? LintUtils.getTopModules(this.fOVMProject) : new HashSet<RfNamedElement>();
        this.documentManager = new DocumentManager();
        this.documentManager.activate();
        if (this.pIncludeXMRDetails) {
            this.fOVMProject.getRfProject().visitHidObject(this.fOVMProject.getRfProject(), new LocalHidObjectVisitor());
        }
        this.fOVMProject.getRfProject().visitHidObject(this.fOVMProject.getRfProject(), new LocalHidVisitor());
        this.documentManager.deactivate();
    }

    protected int getMaxSize(IHidObject select, IRfNamedElement element, ELManager elManager, ELParamValuesHidEvaluator evaluator) {
        IHidEvaluationGuardian guardian = ELUtils.getEvalGuardian((ELConstants.EvalExceptionZone)ELConstants.EvalExceptionZone.RANGE, (IRfNamedElement)element, null, (boolean)true, (ELManager)elManager);
        ELParamValueScope paramValueForSize = ELUtils.evaluateForSize((IHidObject)select, (IHidEvaluator)evaluator, (IRfNamedElement)element, (IHidEvaluationGuardian)guardian);
        if (ELUtils.isUnsuccessfulEval((ELParamValueScope)paramValueForSize)) {
            return -1;
        }
        DVTNumber numberForSize = paramValueForSize.getDVTNumber();
        if (!(numberForSize instanceof VlogBitVector)) {
            return -1;
        }
        return numberForSize.getSize();
    }

    private void addReadField(RfField rfField, HidOccurrence occurrence, ParserPath path) {
        if (rfField instanceof RfResultImplicitVariable || rfField.isPredefined()) {
            return;
        }
        Set<HidOccurrence> localReadElements = this.readElements.get(path);
        if (localReadElements == null) {
            localReadElements = new HashSet<HidOccurrence>();
            localReadElements.add(occurrence);
            this.readElements.put(path, localReadElements);
        } else {
            localReadElements.add(occurrence);
        }
    }

    private void addWrittenField(RfField rfField, HidOccurrence occurrence, ParserPath path) {
        if (rfField instanceof RfResultImplicitVariable || rfField.isPredefined()) {
            return;
        }
        Set<HidOccurrence> localWrittenElements = this.writtenElements.get(path);
        if (localWrittenElements == null) {
            localWrittenElements = new HashSet<HidOccurrence>();
            localWrittenElements.add(occurrence);
            this.writtenElements.put(path, localWrittenElements);
        } else {
            localWrittenElements.add(occurrence);
        }
    }

    protected boolean isXMR(RfHid hid, RfNamedElement scope) {
        if (hid == null) {
            return false;
        }
        if (hid.getParentAccess() == null || hid.getParentHid() == null) {
            return false;
        }
        Hid parentHid = hid.getParentHid();
        while (parentHid.getParentHid() != null) {
            parentHid = parentHid.getParentHid();
        }
        IRfNamedElement parentElement = parentHid.getElement();
        if (!(parentElement instanceof RfInstanceHolder) && !(parentElement instanceof RfInstance)) {
            return false;
        }
        IRfNamedElement tempScope = scope.getEnclosingScope(new HashSet<Class>(Arrays.asList(RfModule.class, RfInstance.class, RfProgram.class, RfInterface.class)));
        if (!(tempScope instanceof RfNamedElement)) {
            return false;
        }
        scope = (RfNamedElement)tempScope;
        if (!this.pAllowedXMRScopes.isEmpty()) {
            for (Pattern pattern : this.pAllowedXMRScopes) {
                if (!pattern.matcher(scope.getFullNameLabel()).matches()) continue;
                return false;
            }
        }
        if (this.checkFullReference && this.topModules.contains(parentElement)) {
            return true;
        }
        if (parentElement instanceof RfInstance) {
            boolean isDownWard = false;
            IELMemory memory = RfMixedLangManager.getInstance().getELMemory(this.fOVMProject.getProject());
            if (memory == null) {
                return false;
            }
            List instances = this.scopeInstancesCache.get(scope);
            if (instances == null) {
                instances = memory.getInstancesFor((IRfNamedElement)scope, false, 1);
                this.scopeInstancesCache.put(scope, instances);
            }
            if (instances.isEmpty()) {
                return false;
            }
            ElementPath scopePath = ((ELInstance)instances.get(0)).getHierarchyPath();
            Set<IRfInstanceElement> members = this.childrenOfElementPathCache.get(scopePath);
            if (members == null) {
                Map subtree = memory.subtreeOf(scopePath, false);
                members = new HashSet<IRfInstanceElement>();
                for (Map.Entry entry : subtree.entrySet()) {
                    if (!scopePath.isDirectParentOf((ElementPath)entry.getKey())) continue;
                    members.add(((ELInstance)entry.getValue()).getDescription());
                }
                this.childrenOfElementPathCache.put(scopePath, members);
            }
            if (members != null && !members.isEmpty() && members.contains(parentElement)) {
                isDownWard = true;
            }
            if (this.checkDownwardReference && isDownWard) {
                return true;
            }
            if (this.checkUpwardReference && !isDownWard) {
                return true;
            }
        }
        return false;
    }

    private boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    protected abstract boolean allowedXMRElement(RfHid var1);

    private final class LocalHidObjectVisitor
    implements IHidVisitor<IHidObject> {
        private ParserPath parserPath;
        private RfNamedElement scope;

        private LocalHidObjectVisitor() {
        }

        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }

        public void setHolder(IHidHolder holder) {
            this.scope = (RfNamedElement)((RfHidHolder)holder).getScope();
        }

        public boolean visit(IHidObject hidObject) {
            if (hidObject instanceof RfHid) {
                this.handleHid((RfHid)hidObject);
            } else if (hidObject instanceof RfHidOperator) {
                this.handleOperator((RfHidOperator)hidObject);
            } else if (hidObject instanceof RfHidAccess && ((RfHidAccess)hidObject).isSelect()) {
                this.handleSelect((RfHidAccess)hidObject);
            }
            return true;
        }

        private void handleHid(RfHid hidObject) {
            if (!hidObject.isMethodCall(false)) {
                if (hidObject.getElement() instanceof RfField) {
                    RfField field = (RfField)hidObject.getElement();
                    if (this.scope instanceof RfAssertExpect) {
                        AbstractUnallowedCrossModuleReferenceCheck.this.addReadField(field, hidObject.getOccurrence(), this.parserPath);
                        this.handleAccess(hidObject, false, false, false);
                        return;
                    }
                }
                return;
            }
            List methodCalls = MethodCallUtils.getMethodCalls((IHid)hidObject);
            if (methodCalls == null || methodCalls.isEmpty()) {
                return;
            }
            for (MethodCall methodCall : methodCalls) {
                this.handleMethodCall(methodCall);
            }
            this.handleAccess(hidObject, true, false, false);
        }

        private void handleAccess(RfHid hidObject, boolean isMethodCall, boolean isAssignment, boolean isWrite) {
            HidAccess parentAccess = hidObject.getParentAccess();
            if (!(parentAccess instanceof RfHidAccess)) {
                return;
            }
            RfHidAccess hidAccess = (RfHidAccess)parentAccess;
            IRfNamedElement asocType = hidAccess.getAssociatedType();
            Hid parentHid = hidAccess.getParentHid();
            if (!(parentHid instanceof RfHid)) {
                return;
            }
            IRfNamedElement hidElement = ((RfHid)parentHid).getElement();
            String hidName = hidObject.getName();
            while (hidElement instanceof RfField) {
                if (isAssignment) {
                    AbstractUnallowedCrossModuleReferenceCheck.this.addWrittenField((RfField)hidElement, ((RfHid)parentHid).getOccurrence(), this.parserPath);
                } else if (asocType instanceof RfClass) {
                    if (!isWrite) {
                        AbstractUnallowedCrossModuleReferenceCheck.this.addReadField((RfField)hidElement, ((RfHid)parentHid).getOccurrence(), this.parserPath);
                    } else {
                        AbstractUnallowedCrossModuleReferenceCheck.this.addWrittenField((RfField)hidElement, ((RfHid)parentHid).getOccurrence(), this.parserPath);
                    }
                } else if (asocType instanceof RfListType && isMethodCall) {
                    if (((RfListType)asocType).isAssociativeArray()) {
                        this.handleAssociativeArrayCall((RfField)hidElement, hidName, hidObject.getOccurrence());
                    } else if (((RfListType)asocType).isDynamicArray()) {
                        this.handleDynamicArrayCall((RfField)hidElement, hidName, hidObject.getOccurrence());
                    } else if (((RfListType)asocType).isQueue()) {
                        this.handleQueueCall((RfField)hidElement, hidName, hidObject.getOccurrence());
                    } else if (asocType instanceof RfListType) {
                        this.handleListCall((RfField)hidElement, hidName, hidObject.getOccurrence());
                    }
                }
                parentAccess = parentHid.getParentAccess();
                if (!(parentAccess instanceof RfHidAccess)) {
                    return;
                }
                hidAccess = (RfHidAccess)parentAccess;
                parentHid = hidAccess.getParentHid();
                if (!(parentHid instanceof RfHid)) {
                    return;
                }
                hidElement = ((RfHid)parentHid).getElement();
            }
        }

        private boolean isWrittenOnly(RfField argument) {
            return argument.isOutput() || argument.isRef() && !argument.isConstRef();
        }

        private boolean isReadOnly(RfField argument) {
            return argument.isInput() || argument.isConstRef() || argument.isRef() || argument.isParameter();
        }

        private void handleMethodCall(MethodCall methodCall) {
            if (methodCall.argumentValuesMap == null || methodCall.argumentValuesMap.isEmpty()) {
                return;
            }
            Set entrySet = methodCall.argumentValuesMap.entrySet();
            if (entrySet == null || entrySet.isEmpty()) {
                return;
            }
            for (Map.Entry argumentValue : entrySet) {
                IRfNamedElement key = (IRfNamedElement)argumentValue.getKey();
                if (!(key instanceof RfField)) continue;
                RfField argument = (RfField)key;
                Set values = (Set)argumentValue.getValue();
                if (values == null || values.isEmpty()) continue;
                boolean isReadOnly = this.isReadOnly(argument) || argument.isInout();
                boolean isWriteOnly = this.isWrittenOnly(argument) || argument.isInout();
                for (IHid value : values) {
                    if (!(value instanceof RfHid) || !(value.getElement() instanceof RfField)) continue;
                    IRfNamedElement element = value.getElement();
                    if (isReadOnly) {
                        AbstractUnallowedCrossModuleReferenceCheck.this.addReadField((RfField)element, value.getOccurrence(), this.parserPath);
                        this.handleAccess((RfHid)value, false, false, false);
                    }
                    if (!isWriteOnly && (!methodCall.getMethodName().equals("$cast") || !key.getName().equals("dest_var"))) continue;
                    AbstractUnallowedCrossModuleReferenceCheck.this.addWrittenField((RfField)element, value.getOccurrence(), this.parserPath);
                    this.handleAccess((RfHid)value, false, false, true);
                }
            }
        }

        private void handleAssociativeArrayCall(RfField field, String hidName, HidOccurrence occurrence) {
            if (ASSOCIATIVE_ARRAY_READ_METHODS.contains(hidName)) {
                AbstractUnallowedCrossModuleReferenceCheck.this.addReadField(field, occurrence, this.parserPath);
            }
            if (ASSOCIATIVE_ARRAY_WRITE_METHODS.contains(hidName)) {
                AbstractUnallowedCrossModuleReferenceCheck.this.addWrittenField(field, occurrence, this.parserPath);
            }
        }

        private void handleDynamicArrayCall(RfField field, String hidName, HidOccurrence occurrence) {
            if (DYNAMIC_ARRAY_READ_METHODS.contains(hidName)) {
                AbstractUnallowedCrossModuleReferenceCheck.this.addReadField(field, occurrence, this.parserPath);
            }
            if (DYNAMIC_ARRAY_WRITE_METHODS.contains(hidName)) {
                AbstractUnallowedCrossModuleReferenceCheck.this.addWrittenField(field, occurrence, this.parserPath);
            }
        }

        private void handleQueueCall(RfField field, String hidName, HidOccurrence occurrence) {
            if (QUEUE_READ_METHODS.contains(hidName)) {
                AbstractUnallowedCrossModuleReferenceCheck.this.addReadField(field, occurrence, this.parserPath);
            }
            if (QUEUE_WRITE_METHODS.contains(hidName)) {
                AbstractUnallowedCrossModuleReferenceCheck.this.addWrittenField(field, occurrence, this.parserPath);
            }
        }

        private void handleListCall(RfField field, String hidName, HidOccurrence occurrence) {
            if (LIST_READ_METHODS.contains(hidName)) {
                AbstractUnallowedCrossModuleReferenceCheck.this.addReadField(field, occurrence, this.parserPath);
            }
            if (LIST_WRITE_METHODS.contains(hidName)) {
                AbstractUnallowedCrossModuleReferenceCheck.this.addWrittenField(field, occurrence, this.parserPath);
            }
        }

        private void handleOperator(RfHidOperator hidObject) {
            ListContainer rhValues;
            IRfNamedElement element;
            IHidObject lhValue = hidObject.getLHValue();
            if (lhValue == null) {
                return;
            }
            ISDataAbstract operatorResolvedType = hidObject.getOperatorResolvedType();
            if (hidObject.isAssignment() && lhValue instanceof RfHid) {
                if (operatorResolvedType instanceof SDataVariable) {
                    this.addWrittenVariable((SDataVariable)operatorResolvedType, ((RfHid)lhValue).getOccurrence());
                }
                if (operatorResolvedType instanceof DummyDataType && "undefined".equals(((DummyDataType)operatorResolvedType).getName(false))) {
                    HidOccurrence occurrence = ((RfHid)lhValue).getOccurrence();
                    Set<HidOccurrence> localReadElements = AbstractUnallowedCrossModuleReferenceCheck.this.writtenElements.get(this.parserPath);
                    if (localReadElements == null) {
                        localReadElements = new HashSet<HidOccurrence>();
                        localReadElements.add(occurrence);
                        AbstractUnallowedCrossModuleReferenceCheck.this.writtenElements.put(this.parserPath, localReadElements);
                    } else {
                        localReadElements.add(occurrence);
                    }
                }
            }
            if (!hidObject.isAssignment()) {
                IHidObject select;
                List selects;
                if (lhValue instanceof RfHid) {
                    IRfNamedElement element2 = ((RfHid)lhValue).getElement();
                    if (element2 instanceof RfField) {
                        AbstractUnallowedCrossModuleReferenceCheck.this.addReadField((RfField)element2, ((RfHid)lhValue).getOccurrence(), this.parserPath);
                        this.handleAccess((RfHid)lhValue, false, false, false);
                        if (hidObject.isIncrementOrDecrement()) {
                            AbstractUnallowedCrossModuleReferenceCheck.this.addWrittenField((RfField)element2, ((RfHid)lhValue).getOccurrence(), this.parserPath);
                            this.handleAccess((RfHid)lhValue, false, false, true);
                        }
                    }
                } else if (lhValue instanceof RfHidAccess && ((RfHidAccess)lhValue).isSelect() && (selects = ((RfHidAccess)lhValue).getSelects()) != null && !selects.isEmpty() && (select = (IHidObject)selects.get(0)) instanceof RfHid && ((RfHid)select).getElement() instanceof RfField) {
                    AbstractUnallowedCrossModuleReferenceCheck.this.addReadField((RfField)((RfHid)select).getElement(), ((RfHid)select).getOccurrence(), this.parserPath);
                    this.handleAccess((RfHid)select, false, false, false);
                }
            }
            Hid parent = null;
            if (lhValue instanceof RfHidAccess) {
                RfHidAccess rfHidAccess = (RfHidAccess)lhValue;
                parent = rfHidAccess.getParentHid();
            } else if (lhValue instanceof RfHid) {
                parent = ((RfHid)lhValue).getParentHid();
            }
            if (parent instanceof RfHid && (element = ((RfHid)parent).getElement()) instanceof RfField) {
                if (hidObject.isAssignment()) {
                    AbstractUnallowedCrossModuleReferenceCheck.this.addWrittenField((RfField)element, ((RfHid)parent).getOccurrence(), this.parserPath);
                    this.handleAccess((RfHid)parent, false, true, true);
                } else {
                    AbstractUnallowedCrossModuleReferenceCheck.this.addReadField((RfField)element, ((RfHid)parent).getOccurrence(), this.parserPath);
                    this.handleAccess((RfHid)parent, false, false, false);
                }
            }
            if ((rhValues = hidObject.getRHValues()) == null || rhValues.isEmpty()) {
                return;
            }
            for (IHidObject rhValue : rhValues) {
                Hid parentHid;
                Hid rhHid;
                if (rhValue instanceof RfHid) {
                    IRfNamedElement element3 = ((RfHid)rhValue).getElement();
                    if (element3 == null || element3.isPredefined()) {
                        return;
                    }
                    if (!(element3 instanceof RfField)) continue;
                    AbstractUnallowedCrossModuleReferenceCheck.this.addReadField((RfField)element3, ((RfHid)rhValue).getOccurrence(), this.parserPath);
                    this.handleAccess((RfHid)rhValue, false, false, false);
                    continue;
                }
                if (!(rhValue instanceof RfHidAccess) || !((rhHid = ((RfHidAccess)rhValue).getParentHid()) instanceof RfHid)) continue;
                IRfNamedElement element4 = ((RfHid)rhHid).getElement();
                if (element4 == null || element4.isPredefined() && !((RfPredefinedFunction)element4).isConstructor()) {
                    return;
                }
                if (element4 instanceof RfField) {
                    AbstractUnallowedCrossModuleReferenceCheck.this.addReadField((RfField)element4, ((RfHid)rhHid).getOccurrence(), this.parserPath);
                    this.handleAccess((RfHid)rhHid, false, false, false);
                    continue;
                }
                if (!(element4 instanceof RfPredefinedFunction) || !((parentHid = rhHid.getParentAccess().getParentHid()) instanceof RfHid) || !(parentHid.getElement() instanceof RfField)) continue;
                this.handleDynamicArrayCall((RfField)parentHid.getElement(), parentHid.getName(), parentHid.getOccurrence());
            }
        }

        private void addWrittenVariable(SDataVariable sDataNamedVariable, HidOccurrence occurrence) {
            IRfNamedElement variable = sDataNamedVariable.getVariable();
            if (variable instanceof RfField) {
                AbstractUnallowedCrossModuleReferenceCheck.this.addWrittenField((RfField)variable, occurrence, this.parserPath);
            }
        }

        private void handleSelect(RfHidAccess hidObject) {
            List selects = hidObject.getSelects();
            if (selects == null || selects.isEmpty()) {
                return;
            }
            IHidObject select = (IHidObject)selects.get(0);
            if (!(select instanceof RfHid)) {
                return;
            }
            RfHid rfHid = (RfHid)select;
            if (!(rfHid.getElement() instanceof RfField)) {
                return;
            }
            AbstractUnallowedCrossModuleReferenceCheck.this.addReadField((RfField)rfHid.getElement(), rfHid.getOccurrence(), this.parserPath);
            this.handleAccess(rfHid, false, false, false);
        }

        public Class<IHidObject> getType() {
            return IHidObject.class;
        }
    }

    private final class LocalHidVisitor
    implements IHidVisitor<RfHid> {
        private ParserPath parserPath;
        private RfNamedElement scope;

        private LocalHidVisitor() {
        }

        public boolean enterBindInstances() {
            return true;
        }

        public boolean enterDataTypes() {
            return true;
        }

        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }

        public void setHolder(IHidHolder holder) {
            this.scope = (RfNamedElement)((RfHidHolder)holder).getScope();
        }

        public boolean visit(RfHid hid) {
            if (AbstractUnallowedCrossModuleReferenceCheck.this.checkPreWaivers(this.parserPath)) {
                return true;
            }
            ListContainer accesses = hid.getAccesses();
            if (accesses != null) {
                for (HidAccess access : accesses) {
                    if (!(AbstractUnallowedCrossModuleReferenceCheck.this.pIncludeXMRDetails ? !access.isSelect() && !access.isMethodCall(false) : !access.isSelect())) continue;
                    return true;
                }
            }
            AbstractUnallowedCrossModuleReferenceCheck.this.notifyCheckAlive();
            if (!AbstractUnallowedCrossModuleReferenceCheck.this.isXMR(hid, this.scope)) {
                return true;
            }
            if (AbstractUnallowedCrossModuleReferenceCheck.this.allowedXMRElement(hid)) {
                return true;
            }
            if (AbstractUnallowedCrossModuleReferenceCheck.this.pIncludeXMRDetails) {
                HidOccurrence accessOccurrence;
                IDocument document;
                String usage;
                HidOccurrence occurrence;
                String typeName;
                IRfNamedElement elem;
                block29: {
                    elem = hid.getElement();
                    if (!(elem instanceof RfField) && !(elem instanceof RfPredefinedFunction)) {
                        return true;
                    }
                    if (elem instanceof RfField) {
                        typeName = ((RfField)elem).isParameterNoDataType() ? "parameter with no type" : ((RfField)elem).getAssociatedTypeName();
                    } else {
                        Hid funcParent = hid.getParentHid();
                        if (!(funcParent instanceof RfHid)) {
                            return true;
                        }
                        RfHid hidParent = (RfHid)funcParent;
                        if (!AbstractUnallowedCrossModuleReferenceCheck.this.isXMR(hidParent, this.scope)) {
                            return true;
                        }
                        if (AbstractUnallowedCrossModuleReferenceCheck.this.allowedXMRElement(hidParent)) {
                            return true;
                        }
                        if (!(funcParent.getElement() instanceof RfField)) {
                            return true;
                        }
                        typeName = ((RfField)funcParent.getElement()).getAssociatedTypeName();
                    }
                    occurrence = hid.getOccurrence();
                    Set<HidOccurrence> localReadElements = AbstractUnallowedCrossModuleReferenceCheck.this.readElements.get(this.parserPath);
                    Set<HidOccurrence> localWriteElements = AbstractUnallowedCrossModuleReferenceCheck.this.writtenElements.get(this.parserPath);
                    usage = "";
                    if (localReadElements != null && localWriteElements != null && localReadElements.contains(occurrence) && localWriteElements.contains(occurrence)) {
                        usage = "read and write";
                    } else if (localReadElements != null && localReadElements.contains(occurrence)) {
                        usage = "read";
                    } else if (localWriteElements != null && localWriteElements.contains(occurrence)) {
                        usage = "write";
                    }
                    document = AbstractUnallowedCrossModuleReferenceCheck.this.documentManager.getDocument(this.parserPath, AbstractUnallowedCrossModuleReferenceCheck.this.fOVMProject.getProject());
                    HidAccess access = hid.getParentAccess();
                    while (access.getParentHid().getParentAccess() != null) {
                        access = access.getParentHid().getParentAccess();
                    }
                    accessOccurrence = access.getOccurrence();
                    if (accessOccurrence != null) break block29;
                    return true;
                }
                try {
                    RfNamedElement arrayElementType;
                    IRfNamedElement arrayElement;
                    List selects;
                    int docOffsetOfHid = HidUtils.getStartOffset((HidOccurrence)accessOccurrence);
                    int offsetOfLine = document.getLineOffset(accessOccurrence.getLine() - 1);
                    int lineOffsetOfHid = docOffsetOfHid - offsetOfLine;
                    String usageString = "";
                    boolean hasSelect = false;
                    if (accesses != null) {
                        for (HidAccess currentAccess : accesses) {
                            if (!currentAccess.isSelect()) continue;
                            hasSelect = true;
                            usageString = "Illegal XMR " + usage + ": '" + HidUtils.toNiceString((IHidObject)((IHidObject)accesses.get(0))) + "' ";
                        }
                    }
                    if (!hasSelect) {
                        usageString = "Illegal XMR " + usage + ": '" + HidUtils.toNiceString((IHidObject)hid) + "' ";
                    }
                    String typeString = "Type name: '" + typeName + "'. ";
                    int sizeInBits = -1;
                    ELManager elManager = AbstractUnallowedCrossModuleReferenceCheck.this.fOVMProject.getRfProject().getELManager();
                    ELParamValuesHidEvaluator evaluator = ELParamValues.EMPTY.getHidEvaluator(elManager);
                    if (accesses != null && (selects = ((HidAccess)accesses.get(0)).getSelects()) != null && (arrayElement = hid.getElement()) != null && arrayElement instanceof RfField && ((arrayElementType = LintUtils.getAssociatedFinalType((RfField)arrayElement)) == null || !"string".equals(arrayElementType.getName()))) {
                        sizeInBits = AbstractUnallowedCrossModuleReferenceCheck.this.getMaxSize((IHidObject)hid.getAccesses().get(0), elem, elManager, evaluator);
                    }
                    if (sizeInBits == -1) {
                        sizeInBits = AbstractUnallowedCrossModuleReferenceCheck.this.getMaxSize((IHidObject)hid, elem, elManager, evaluator);
                    }
                    String accessWidthString = "";
                    if (sizeInBits != -1) {
                        accessWidthString = "XMR width: " + sizeInBits + ".";
                    }
                    AbstractUnallowedCrossModuleReferenceCheck.this.addHit(this.parserPath, occurrence, String.valueOf(usageString) + "at offset: " + lineOffsetOfHid + ". " + typeString + accessWidthString);
                }
                catch (BadLocationException e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            } else {
                AbstractUnallowedCrossModuleReferenceCheck.this.addHit(this.parserPath, hid, "Illegal XMR access: '" + HidUtils.toNiceString((IHidObject)hid) + "'!");
            }
            return true;
        }

        public Class<RfHid> getType() {
            return RfHid.class;
        }
    }
}

