/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import ro.amiq.dvt.buildconfig.ElaborationDebugZone;
import ro.amiq.dvt.buildconfig.ElaborationExpressionControl;
import ro.amiq.dvt.elaboration.ELConstants;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.core.ELBuildPhase;
import ro.amiq.dvt.elaboration.core.ELInstance;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.elaboration.core.ELManagerConfiguration;
import ro.amiq.dvt.elaboration.core.ELSpecializationWrapper;
import ro.amiq.dvt.elaboration.model.ELParamValueScope;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.elaboration.model.ELParamValuesHidEvaluator;
import ro.amiq.dvt.elaboration.model.IELMemory;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.interpreter.XUtils;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.model.reflection.RfMixedLangProject;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluationGuardian;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.utils.DVTNumber;
import ro.amiq.dvt.utils.DVTUnpackedArray;
import ro.amiq.dvt.utils.VlogBitVector;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.IndexType;
import ro.amiq.vlogdt.model.reflection.RfAssociatedType;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfInstance;
import ro.amiq.vlogdt.model.reflection.RfInterface;
import ro.amiq.vlogdt.model.reflection.RfListType;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfStruct;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;
import ro.amiq.vlogdt.model.reflection.predefined.RfBitVectorScalarType;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccessArgs;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

public abstract class AbstractWidthMissmatchCheck
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="false", description="When true, comparisons with int type variables are not flagged.", name="ignoreIntTypeVariables", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    protected boolean pIgnoreIntTypeVariables;
    protected IELMemory memory;
    protected ELManager elManager;
    protected ELParamValuesHidEvaluator emptyEvaluator;
    protected Map<IRfNamedElement, Map<ELSpecializationWrapper, ELSpecializationWrapper>> specsPerElement;

    protected AbstractWidthMissmatchCheck(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        RfProject rfProject = this.fOVMProject.getRfProject();
        ELManager elabManager = rfProject.getELManager();
        RfMixedLangProject mixedLangProjectParent = rfProject.getMixedLangProjectParent();
        this.elManager = new ELManager(mixedLangProjectParent, IELMemory.ELMemoryType.STANDARD, ELBuildPhase.NONE, ELManagerConfiguration.newDummyWithControlConfig((boolean)false, EnumSet.noneOf(ElaborationExpressionControl.class), new HashSet(), (boolean)false), mixedLangProjectParent.getNonElabConstantsManager(), EnumSet.noneOf(ElaborationDebugZone.class));
        IELMemory elabMem = elabManager != null ? elabManager.getMemory() : null;
        this.elManager.addToMemory(elabMem);
        this.emptyEvaluator = ELParamValues.EMPTY.getHidEvaluator(this.elManager);
        this.memory = RfMixedLangManager.getInstance().getELMemory(this.fOVMProject.getProject());
        RfMixedLangProject mixedLangProject = mixedLangProjectParent;
        this.specsPerElement = mixedLangProject.getLinterElabSpecs();
    }

    protected String getHitMessageKind() {
        return null;
    }

    public abstract boolean checkOperator(RfHidOperator var1);

    protected RfNamedElement getAssociatedFinalType(RfAssociatedType aAssociatedType) {
        if (aAssociatedType == null) {
            return null;
        }
        IRfNamedElement associatedType = aAssociatedType.getAssociatedTypeNoLastLevelParams();
        while (associatedType instanceof RfListType || associatedType instanceof RfTypeAlias) {
            if (associatedType instanceof RfListType) {
                associatedType = ((RfListType)associatedType).getAssociatedTypeNoLastLevelParams();
            }
            if (!(associatedType instanceof RfTypeAlias)) continue;
            associatedType = ((RfTypeAlias)associatedType).getAssociatedTypeNoLastLevelParams();
        }
        return associatedType instanceof RfNamedElement ? (RfNamedElement)associatedType : null;
    }

    protected RfNamedElement getAssociatedFinalTypeResolveAlias(RfAssociatedType aAssociatedType) {
        if (aAssociatedType == null) {
            return null;
        }
        IRfNamedElement associatedType = aAssociatedType.getAssociatedType();
        while (associatedType instanceof RfTypeAlias) {
            associatedType = ((RfTypeAlias)associatedType).getTranslatedType();
        }
        return associatedType instanceof RfNamedElement ? (RfNamedElement)associatedType : null;
    }

    protected Hid getFirstParentInstanceHid(RfHid rfHid) {
        RfHid parentHid = rfHid;
        while (parentHid != null) {
            if (parentHid.getParentHid() != null && parentHid.getParentHid().getElement() instanceof RfInstance) {
                return parentHid.getParentHid();
            }
            if (parentHid.getParentHid() == null) {
                return parentHid;
            }
            parentHid = parentHid.getParentHid();
        }
        return null;
    }

    protected SpecInfo getWrapperForInstance(Hid instanceFieldHid, IRfNamedElement instanceFieldOrFunction, Map<ELSpecializationWrapper, ELSpecializationWrapper> specializationWrappers, IHidEvaluator defaultEvaluator, ArrayBlockingQueue<ElementPath> pathPrefixes) {
        SpecInfo specInfo = new SpecInfo();
        if (specializationWrappers == null || specializationWrappers.isEmpty()) {
            specInfo.setEvaluator(defaultEvaluator);
            return specInfo;
        }
        for (ELSpecializationWrapper wrapper : specializationWrappers.values()) {
            for (ElementPath path : wrapper.paths) {
                IRfInstanceElement instanceElement;
                ELInstance instance = this.memory.instanceFor(path);
                if (instance == null || !(instanceElement = instance.getDescription()).equals(instanceFieldOrFunction)) continue;
                boolean hasPrefix = false;
                for (ElementPath pathPrefix : pathPrefixes) {
                    if (!pathPrefix.isPrefixOf(path) || !path.toString().contains(HidUtils.toStringBuilder((IHidObject)instanceFieldHid, (boolean)true, (boolean)true, (boolean)true, (boolean)true, (boolean)true, (boolean)false).toString())) continue;
                    hasPrefix = true;
                }
                if (!hasPrefix) continue;
                specInfo.setEvaluator(wrapper.getHidEvaluator(this.elManager));
                specInfo.addPath(path.toString());
            }
        }
        if (specInfo.getEvaluator() == null) {
            specInfo.setEvaluator(defaultEvaluator);
        }
        return specInfo;
    }

    public boolean shouldEvaluateWithNonEmptyEvaluator(IRfNamedElement element, IRfNamedElement elementType, boolean evaluateIntParameterNotInPortlist) {
        if (element instanceof RfField) {
            if (elementType != null && "int".equals(elementType.getName()) && ((RfField)element).isAnyParameter() && ((RfField)element).isInParameterPortList()) {
                return true;
            }
            if (evaluateIntParameterNotInPortlist && elementType != null && "int".equals(elementType.getName()) && ((RfField)element).isAnyParameter()) {
                return true;
            }
        }
        if (elementType instanceof RfField && ((RfField)elementType).isTypeParameter()) {
            return true;
        }
        LintUtils.FullTypeData fullTypeData = LintUtils.getAssociatedFinalDataType((RfAssociatedType)element);
        if (fullTypeData == null) {
            return false;
        }
        DataType dataType = fullTypeData.getAssocDataType();
        if (dataType == null) {
            return false;
        }
        List<IndexType> packedDimension = dataType.getPackedDimension();
        if (packedDimension == null || packedDimension.isEmpty()) {
            return false;
        }
        boolean result = false;
        int i = 0;
        while (i < packedDimension.size()) {
            IndexType indexType = packedDimension.get(i);
            if (!(indexType.getRangeObject() instanceof RfHidOperator)) {
                return false;
            }
            RfHidOperator operator = (RfHidOperator)indexType.getRangeObject();
            ListContainer rhValues = operator.getRHValues();
            if (rhValues == null || rhValues.size() != 1) {
                return false;
            }
            IHidObject lhValue = operator.getLHValue();
            boolean bl = result = result || this.hasDataTypeDependingOnParameters(lhValue) || this.hasDataTypeDependingOnParameters((IHidObject)rhValues.get(0));
            if (result) {
                return result;
            }
            ++i;
        }
        return false;
    }

    private boolean hasDataTypeDependingOnParameters(IHidObject hidObject) {
        if (hidObject instanceof RfHid && ((RfHid)hidObject).getElement() instanceof RfField && (((RfField)((RfHid)hidObject).getElement()).isInParameterPortList() || ELUtils.isVLOGConstant((IRfNamedElement)((RfHid)hidObject).getElement()))) {
            return true;
        }
        if (hidObject instanceof RfHidOperator) {
            RfHidOperator operator = (RfHidOperator)hidObject;
            ListContainer rhValues = operator.getRHValues();
            if (rhValues == null || rhValues.size() != 1) {
                return false;
            }
            return this.hasDataTypeDependingOnParameters(operator.getLHValue()) || this.hasDataTypeDependingOnParameters((IHidObject)rhValues.get(0));
        }
        if (hidObject instanceof RfHidAccess) {
            List hids = HidUtils.getSelects((IHidObject)hidObject);
            if (hids == null || hids.isEmpty()) {
                return false;
            }
            boolean found = false;
            for (IHidObject hid : hids) {
                if (found |= this.hasDataTypeDependingOnParameters(hid)) break;
            }
            return found;
        }
        return false;
    }

    protected int[] getSizeOfHid(IHidObject hidValue, IRfNamedElement hidElement, IRfNamedElement hidElementType, ELParamValuesHidEvaluator hidEvaluator, ELSpecializationWrapper specsWrapper, IRfNamedElement scope) {
        Integer actualValue;
        if ((hidElement instanceof RfField && hidElementType != null && "int".equals(hidElementType.getName()) && ((RfField)hidElement).isAnyParameter() || hidValue instanceof RfHidImplicit && LintUtils.isImplicitUnsized((RfHidImplicit)hidValue)) && (actualValue = this.getValueAsSize(hidValue, (RfField)hidElement, hidEvaluator, scope)) != null) {
            return new int[]{actualValue};
        }
        return this.getElementSize(hidValue, hidElement, hidEvaluator, specsWrapper, scope);
    }

    private void checkSizes(IHidObject lhValue, IHidObject rhValue, IRfNamedElement lhElement, IRfNamedElement rhElement, IRfNamedElement lhElementType, IRfNamedElement rhElementType, ELParamValuesHidEvaluator lhHidEvaluator, ELParamValuesHidEvaluator rhHidEvaluator, ParserPath parserPath, RfHidOperator operator, String lhPathsText, String rhPathsText, boolean hasPathsText, ELSpecializationWrapper specsWrapper, IRfNamedElement scope) {
        int[] lhFieldDimensionsInfo = this.getSizeOfHid(lhValue, lhElement, lhElementType, lhHidEvaluator, specsWrapper, scope);
        int[] rhFieldDimensionsInfo = this.getSizeOfHid(rhValue, rhElement, rhElementType, rhHidEvaluator, specsWrapper, scope);
        if (lhFieldDimensionsInfo == null || rhFieldDimensionsInfo == null) {
            return;
        }
        String hitMessage = null;
        if (lhFieldDimensionsInfo.length == 1 && rhFieldDimensionsInfo.length == 1) {
            return;
        }
        if (lhFieldDimensionsInfo.length == 1) {
            if (this.getNumberOfBitsUsedInInteger(lhFieldDimensionsInfo[0]) > this.getSizeFromLowerAndUpperBounds(rhFieldDimensionsInfo[0], rhFieldDimensionsInfo[1])) {
                hitMessage = String.valueOf(this.getHitMessageKind()) + " (" + HidUtils.toNiceString((IHidObject)operator) + "): '" + this.getHitMessageWidthInfo(rhValue, rhFieldDimensionsInfo) + " which can not represent '" + lhElement.getName() + "' value of " + lhFieldDimensionsInfo[0] + "!" + (hasPathsText ? "\nHierarchy Paths for left operand: " + lhPathsText + "\nHierarchy Paths for right operand: " + rhPathsText : "");
            }
        } else if (rhFieldDimensionsInfo.length == 1) {
            if (this.getNumberOfBitsUsedInInteger(rhFieldDimensionsInfo[0]) > this.getSizeFromLowerAndUpperBounds(lhFieldDimensionsInfo[0], lhFieldDimensionsInfo[1])) {
                hitMessage = String.valueOf(this.getHitMessageKind()) + " (" + HidUtils.toNiceString((IHidObject)operator) + "): '" + this.getHitMessageWidthInfo(lhValue, lhFieldDimensionsInfo) + " which can not represent '" + rhElement.getName() + "' value of " + rhFieldDimensionsInfo[0] + "!" + (hasPathsText ? "\nHierarchy Paths for left operand: " + lhPathsText + "\nHierarchy Paths for right operand: " + rhPathsText : "");
            }
        } else if (!Arrays.equals(lhFieldDimensionsInfo, rhFieldDimensionsInfo)) {
            hitMessage = String.valueOf(this.getHitMessageKind()) + " " + HidUtils.toNiceString((IHidObject)operator) + ": '" + this.getHitMessageWidthInfo(lhValue, lhFieldDimensionsInfo) + " while '" + this.getHitMessageWidthInfo(rhValue, rhFieldDimensionsInfo) + "!" + (hasPathsText ? "\nHierarchy Paths for left operand: " + lhPathsText + "\nHierarchy Paths for right operand: " + rhPathsText : "");
        }
        if (hitMessage != null) {
            this.addHit(parserPath, (HidOccurrence)operator.getOccurrence(), hitMessage);
        }
    }

    protected int getNumberOfBitsUsedInInteger(int value) {
        if (value == 0) {
            return 1;
        }
        return 32 - Integer.numberOfLeadingZeros(value);
    }

    protected int getSizeFromLowerAndUpperBounds(int lowerBound, int upperBound) {
        return Math.abs(lowerBound - upperBound) + 1;
    }

    private Integer getValueAsSize(IHidObject hidObject, RfField field, ELParamValuesHidEvaluator evaluator, IRfNamedElement scope) {
        IELParamValue value;
        IHidEvaluationGuardian guardianForEval = ELUtils.getEvalGuardian((ELConstants.EvalExceptionZone)ELConstants.EvalExceptionZone.RANGE, (IRfNamedElement)field, null, (boolean)false, (ELManager)this.elManager);
        IHid hid = HidUtils.getHidFrom((IHidObject)hidObject);
        if (hid != null && hid.getParentHid() != null) {
            guardianForEval.updateElements((IRfNamedElement)field, scope);
        }
        if (ELUtils.isUnsuccessfulEval((IELParamValue)(value = XUtils.getValue((ELParamValueScope)ELUtils.evaluate((IHidObject)hidObject, (IHidEvaluator)evaluator, null, (IHidEvaluationGuardian)guardianForEval)))) || !(value instanceof ELParamValues.ParamValueNumber)) {
            return null;
        }
        return value.intValue();
    }

    protected int[] getElementSize(IHidObject hidObject, IRfNamedElement element, ELParamValuesHidEvaluator evaluator, ELSpecializationWrapper specsWrapper, IRfNamedElement scope) {
        IELParamValue paramValueForSize;
        ElementPath hierarchicalPath = null;
        if (specsWrapper != null) {
            hierarchicalPath = specsWrapper.paths != null ? (ElementPath)specsWrapper.paths.peek() : null;
        }
        IHidEvaluationGuardian guardianForSize = ELUtils.getEvalGuardian((ELConstants.EvalExceptionZone)ELConstants.EvalExceptionZone.RANGE, (IRfNamedElement)element, (ElementPath)hierarchicalPath, (boolean)true, (ELManager)this.elManager);
        IHid hid = HidUtils.getHidFrom((IHidObject)hidObject);
        if (hid != null && (hid.getParentHid() != null || element instanceof RfFunction)) {
            guardianForSize.updateElements(element, scope);
        }
        if (ELUtils.isUnsuccessfulEval((IELParamValue)(paramValueForSize = XUtils.getValue((ELParamValueScope)ELUtils.evaluateForSize((IHidObject)hidObject, (IHidEvaluator)evaluator, (IRfNamedElement)element, (IHidEvaluationGuardian)guardianForSize))))) {
            return null;
        }
        return this.getSuccessfulEvaluationDimensionsInfo(paramValueForSize);
    }

    private int[] getSuccessfulEvaluationDimensionsInfo(IELParamValue paramValueForSize) {
        DVTNumber numberForSize = paramValueForSize.getDVTNumber();
        ArrayList<Integer> dimensionsInfo = new ArrayList<Integer>();
        while (!(numberForSize instanceof VlogBitVector)) {
            if (numberForSize instanceof DVTUnpackedArray) {
                dimensionsInfo.add(((DVTUnpackedArray)numberForSize).getLeft());
                dimensionsInfo.add(((DVTUnpackedArray)numberForSize).getRight());
                numberForSize = ((DVTUnpackedArray)numberForSize).getElementType();
                continue;
            }
            return null;
        }
        VlogBitVector bitVector = (VlogBitVector)numberForSize;
        dimensionsInfo.add(bitVector.getLeft());
        dimensionsInfo.add(bitVector.getRight());
        return dimensionsInfo.stream().mapToInt(Integer::intValue).toArray();
    }

    private String getHitMessageWidthInfo(IHidObject hid, int[] dimensionsInfo) {
        StringBuilder sb = new StringBuilder();
        sb.append(HidUtils.toNiceString((IHidObject)hid));
        sb.append("' has width ");
        sb.append(this.getWidthAsString(dimensionsInfo));
        return sb.toString();
    }

    protected String getWidthAsString(int[] fieldDimensionsInfo) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < fieldDimensionsInfo.length) {
            sb.append("[");
            if (fieldDimensionsInfo[i] < fieldDimensionsInfo[i + 1]) {
                sb.append(fieldDimensionsInfo[i]);
            } else {
                sb.append(fieldDimensionsInfo[i + 1]);
            }
            sb.append(":");
            if (fieldDimensionsInfo[i] < fieldDimensionsInfo[i + 1]) {
                sb.append(fieldDimensionsInfo[i + 1]);
            } else {
                sb.append(fieldDimensionsInfo[i]);
            }
            sb.append("]");
            i += 2;
        }
        return sb.toString();
    }

    public boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    protected class OperatorVisitor
    implements IHidVisitor<RfHidOperator> {
        private ParserPath parserPath;
        private IRfNamedElement scope;

        protected OperatorVisitor() {
        }

        public void setScope(IRfNamedElement scope) {
            this.scope = scope;
        }

        public boolean visit(RfHidOperator operator) {
            if (!AbstractWidthMissmatchCheck.this.checkOperator(operator)) {
                return true;
            }
            if (AbstractWidthMissmatchCheck.this.checkPreWaivers(this.parserPath)) {
                return true;
            }
            AbstractWidthMissmatchCheck.this.notifyCheckAlive();
            ListContainer rhValues = operator.getRHValues();
            if (rhValues == null || rhValues.size() > 1) {
                return true;
            }
            IHidObject lhValueHidObject = operator.getLHValue();
            IHidObject rhValueHidObject = (IHidObject)rhValues.get(0);
            if (lhValueHidObject instanceof RfHidAccessArgs && ((RfHidAccessArgs)lhValueHidObject).getSelects() != null) {
                return true;
            }
            if (rhValueHidObject instanceof RfHidAccessArgs && ((RfHidAccessArgs)rhValueHidObject).getSelects() != null) {
                return true;
            }
            IHidObject lhValueHid = lhValueHidObject;
            IHidObject rhValueHid = rhValueHidObject;
            if (lhValueHid instanceof RfHidAccessArgs) {
                lhValueHid = ((RfHidAccessArgs)lhValueHid).getParentHid();
            }
            if (lhValueHid instanceof RfHidAccess) {
                lhValueHid = ((RfHidAccess)lhValueHid).getParentHid();
            }
            if (rhValueHid instanceof RfHidAccessArgs) {
                rhValueHid = ((RfHidAccessArgs)rhValueHid).getParentHid();
            }
            if (rhValueHid instanceof RfHidAccess) {
                rhValueHid = ((RfHidAccess)rhValueHid).getParentHid();
            }
            if (!(lhValueHid instanceof RfHid) || !(rhValueHid instanceof RfHid) || !(((RfHid)lhValueHid).getElement() instanceof RfField) && !(((RfHid)lhValueHid).getElement() instanceof RfFunction) || !(((RfHid)rhValueHid).getElement() instanceof RfField) && !(((RfHid)rhValueHid).getElement() instanceof RfFunction)) {
                return true;
            }
            RfHid lhValueRfHid = (RfHid)lhValueHid;
            RfHid rhValueRfHid = (RfHid)rhValueHid;
            IRfNamedElement lhElement = lhValueRfHid.getElement();
            IRfNamedElement rhElement = rhValueRfHid.getElement();
            if (!(lhElement instanceof RfField) && !(lhElement instanceof RfFunction) || !(rhElement instanceof RfField) && !(rhElement instanceof RfFunction)) {
                return true;
            }
            if (lhElement instanceof RfField && ((RfField)lhElement).isGenvar() || rhElement instanceof RfField && ((RfField)rhElement).isGenvar()) {
                return true;
            }
            RfNamedElement lhElementType = null;
            RfNamedElement rhElementType = null;
            if (lhElement instanceof RfFunction || !((RfField)lhElement).isParameterNoDataType()) {
                String lhElementTypeName;
                lhElementType = AbstractWidthMissmatchCheck.this.getAssociatedFinalType((RfAssociatedType)lhElement);
                if (lhElementType == null) {
                    return true;
                }
                if (lhElementType instanceof RfBitVectorScalarType) {
                    lhElementType = ((RfBitVectorScalarType)lhElementType).getScalarWithDefaultSign();
                }
                if (lhElementType instanceof RfStruct && ((RfStruct)lhElementType).isEnum()) {
                    lhElementType = ((RfStruct)lhElementType).getEnumBaseType();
                }
                if ("string".equals(lhElementTypeName = lhElementType.getName())) {
                    return true;
                }
                if (AbstractWidthMissmatchCheck.this.pIgnoreIntTypeVariables && "int".equals(lhElementTypeName)) {
                    return true;
                }
            }
            if (rhElement instanceof RfFunction || !((RfField)rhElement).isParameterNoDataType()) {
                String rhElementTypeName;
                rhElementType = AbstractWidthMissmatchCheck.this.getAssociatedFinalType((RfAssociatedType)rhElement);
                if (rhElementType == null) {
                    return true;
                }
                if (rhElementType instanceof RfStruct && ((RfStruct)rhElementType).isEnum()) {
                    rhElementType = ((RfStruct)rhElementType).getEnumBaseType();
                }
                if (rhElementType instanceof RfBitVectorScalarType) {
                    rhElementType = ((RfBitVectorScalarType)rhElementType).getScalarWithDefaultSign();
                }
                if ("string".equals(rhElementTypeName = rhElementType.getName())) {
                    return true;
                }
                if (AbstractWidthMissmatchCheck.this.pIgnoreIntTypeVariables && "int".equals(rhElementTypeName)) {
                    return true;
                }
            }
            if (!(lhValueRfHid.getAncestorHid().getElement() instanceof RfField) && !(lhValueRfHid.getAncestorHid().getElement() instanceof RfFunction) || !(rhValueRfHid.getAncestorHid().getElement() instanceof RfField) && !(rhValueRfHid.getAncestorHid().getElement() instanceof RfFunction)) {
                return true;
            }
            IRfNamedElement lhAncestorElement = lhValueRfHid.getAncestorHid().getElement();
            IRfNamedElement rhAncestorElement = rhValueRfHid.getAncestorHid().getElement();
            if (lhAncestorElement == null || rhAncestorElement == null) {
                return true;
            }
            Hid lhInstanceHid = AbstractWidthMissmatchCheck.this.getFirstParentInstanceHid(lhValueRfHid);
            Hid rhInstanceHid = AbstractWidthMissmatchCheck.this.getFirstParentInstanceHid(rhValueRfHid);
            if (lhInstanceHid == null || rhInstanceHid == null) {
                return true;
            }
            if (!(lhInstanceHid.getElement() instanceof RfField) && !(lhInstanceHid.getElement() instanceof RfFunction) || !(rhInstanceHid.getElement() instanceof RfField) && !(rhInstanceHid.getElement() instanceof RfFunction)) {
                return true;
            }
            IRfNamedElement lhInstanceFieldOrFunction = lhInstanceHid.getElement();
            IRfNamedElement rhInstanceFieldOrFunction = rhInstanceHid.getElement();
            IRfScopeElement lhAncestorElementEnclosingScope = lhAncestorElement.getEnclosingScope(new HashSet<Class>(Arrays.asList(RfModule.class, RfInterface.class)));
            IRfScopeElement rhAncestorElementEnclosingScope = rhAncestorElement.getEnclosingScope(new HashSet<Class>(Arrays.asList(RfModule.class, RfInterface.class)));
            IRfScopeElement lhElementEnclosingScope = lhElement.getEnclosingScope(new HashSet<Class>(Arrays.asList(RfModule.class, RfInterface.class)));
            IRfScopeElement rhElementEnclosingScope = rhElement.getEnclosingScope(new HashSet<Class>(Arrays.asList(RfModule.class, RfInterface.class)));
            if (lhAncestorElementEnclosingScope == null || rhAncestorElementEnclosingScope == null || lhElementEnclosingScope == null || rhElementEnclosingScope == null || AbstractWidthMissmatchCheck.this.specsPerElement.get(lhAncestorElementEnclosingScope) == null || AbstractWidthMissmatchCheck.this.specsPerElement.get(rhAncestorElementEnclosingScope) == null || !lhAncestorElementEnclosingScope.equals(rhAncestorElementEnclosingScope) || AbstractWidthMissmatchCheck.this.specsPerElement.get(lhAncestorElementEnclosingScope).isEmpty() || !AbstractWidthMissmatchCheck.this.shouldEvaluateWithNonEmptyEvaluator(lhElement, lhElementType, true) && !AbstractWidthMissmatchCheck.this.shouldEvaluateWithNonEmptyEvaluator(rhElement, rhElementType, true)) {
                AbstractWidthMissmatchCheck.this.checkSizes(lhValueHidObject, rhValueHidObject, lhElement, rhElement, lhElementType, rhElementType, AbstractWidthMissmatchCheck.this.emptyEvaluator, AbstractWidthMissmatchCheck.this.emptyEvaluator, this.parserPath, operator, null, null, false, null, this.scope);
                return true;
            }
            boolean lhElementIsTypeParameter = lhElementType instanceof RfField && ((RfField)lhElementType).isTypeParameter();
            boolean rhElementIsTypeParameter = rhElementType instanceof RfField && ((RfField)rhElementType).isTypeParameter();
            Map<ELSpecializationWrapper, ELSpecializationWrapper> specializationWrappers = AbstractWidthMissmatchCheck.this.specsPerElement.get(lhAncestorElementEnclosingScope);
            for (ELSpecializationWrapper ancestorFieldWrapper : specializationWrappers.values()) {
                String rhElementTypeName;
                IELParamValue value;
                Map<ELSpecializationWrapper, ELSpecializationWrapper> rhFieldSpecializationWrappers;
                SpecInfo rhSpecInfo;
                IHidEvaluator rhFieldSpecializationEvaluator;
                String lhElementTypeName;
                IELParamValue value2;
                Map<ELSpecializationWrapper, ELSpecializationWrapper> lhFieldSpecializationWrappers;
                SpecInfo lhSpecInfo;
                IHidEvaluator lhFieldSpecializationEvaluator;
                IHidEvaluator defaultEvaluator = ancestorFieldWrapper.getHidEvaluator(AbstractWidthMissmatchCheck.this.elManager);
                if (!(defaultEvaluator instanceof ELParamValuesHidEvaluator) || ancestorFieldWrapper.paths == null || !((lhFieldSpecializationEvaluator = (lhSpecInfo = AbstractWidthMissmatchCheck.this.getWrapperForInstance(lhInstanceHid, lhInstanceFieldOrFunction, lhFieldSpecializationWrappers = AbstractWidthMissmatchCheck.this.specsPerElement.get(lhElementEnclosingScope), defaultEvaluator, ancestorFieldWrapper.paths)).getEvaluator()) instanceof ELParamValuesHidEvaluator) || AbstractWidthMissmatchCheck.this.pIgnoreIntTypeVariables && lhElementIsTypeParameter && lhElementType != null && (value2 = lhSpecInfo.evaluator.getValueDirectly(lhElementType.getName())) instanceof ELParamValues.ParamValueType && "int".equals(lhElementTypeName = ((ELParamValues.ParamValueType)value2).getNamedElement().getName()) || !((rhFieldSpecializationEvaluator = (rhSpecInfo = AbstractWidthMissmatchCheck.this.getWrapperForInstance(rhInstanceHid, rhInstanceFieldOrFunction, rhFieldSpecializationWrappers = AbstractWidthMissmatchCheck.this.specsPerElement.get(rhElementEnclosingScope), defaultEvaluator, ancestorFieldWrapper.paths)).getEvaluator()) instanceof ELParamValuesHidEvaluator) || AbstractWidthMissmatchCheck.this.pIgnoreIntTypeVariables && rhElementIsTypeParameter && rhElementType != null && (value = rhSpecInfo.evaluator.getValueDirectly(rhElementType.getName())) instanceof ELParamValues.ParamValueType && "int".equals(rhElementTypeName = ((ELParamValues.ParamValueType)value).getNamedElement().getName())) continue;
                String lhPathsText = lhSpecInfo.getPath() == null ? ancestorFieldWrapper.getPathsText() : lhSpecInfo.getPath();
                String rhPathsText = rhSpecInfo.getPath() == null ? ancestorFieldWrapper.getPathsText() : rhSpecInfo.getPath();
                AbstractWidthMissmatchCheck.this.checkSizes(lhValueHidObject, rhValueHidObject, lhElement, rhElement, lhElementType, rhElementType, (ELParamValuesHidEvaluator)lhFieldSpecializationEvaluator, (ELParamValuesHidEvaluator)rhFieldSpecializationEvaluator, this.parserPath, operator, lhPathsText, rhPathsText, true, ancestorFieldWrapper, this.scope);
                if (!AbstractWidthMissmatchCheck.this.shouldEvaluateWithNonEmptyEvaluator(lhElement, lhElementType, false) && !AbstractWidthMissmatchCheck.this.shouldEvaluateWithNonEmptyEvaluator(rhElement, rhElementType, false)) break;
            }
            return true;
        }

        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }

        public Class<RfHidOperator> getType() {
            return RfHidOperator.class;
        }
    }

    static class SpecInfo {
        private IHidEvaluator evaluator;
        private String path;

        SpecInfo() {
        }

        public void setEvaluator(IHidEvaluator evaluator) {
            this.evaluator = evaluator;
        }

        public void addPath(String path) {
            if (this.path == null) {
                this.path = path;
                return;
            }
            this.path = String.valueOf(this.path) + ", " + path;
        }

        public IHidEvaluator getEvaluator() {
            return this.evaluator;
        }

        public String getPath() {
            return this.path;
        }
    }
}

