/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.Collection;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.IRfNamedElementVisitor;
import ro.amiq.vlogdt.model.reflection.RfAssociatedType;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;

@CheckVersion(value="21.1.20")
@CheckID(value="R.1002")
@CheckName(value="R.1002")
@CheckLabel(labels={RuleLabel.DESIGN, RuleLabel.SYNTHESIS})
@CheckTitle(value="Do not declare real variables")
@CheckDescription(value="This check verifies that there are no real variables declared in the project.\nObjects with real values have no physical equivalent and therefore may not be synthesizable.\n\nExamples:\nreal a; // not allowed\nreal b; // not allowed\n\nCheck supports pre-waiving.")
public class Check_R_1002
extends OVMComplianceCheck {
    IRfNamedElementVisitor visitor = namedElement -> {
        if (!(namedElement instanceof RfField)) {
            return true;
        }
        if (namedElement.isPredefined()) {
            return true;
        }
        if (namedElement.isAnonymous()) {
            return true;
        }
        if (namedElement.getDeclaration() == null) {
            return true;
        }
        RfNamedElement enclosingScope = namedElement.getEnclosingScope();
        if (enclosingScope == null) {
            return true;
        }
        this.notifyCheckAlive();
        if (!this.checkVariable(namedElement)) {
            return true;
        }
        if (namedElement.getFile() == null) {
            return true;
        }
        ParserPath parserPath = namedElement.getFile().getParserPath();
        if (this.checkPreWaivers(parserPath)) {
            return true;
        }
        Collection declarations = namedElement.getDeclarations();
        for (RfDefElement declaration : declarations) {
            this.addHit(parserPath, declaration.getStartLine(), "Variable '" + LintUtils.getNamedElementFullName(namedElement) + "' is declared with" + this.getMessage() + " real type!", declaration.getReparseInfo());
        }
        return false;
    };

    public Check_R_1002(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.fOVMProject.getRfProject().accept(this.visitor);
    }

    public boolean checkVariable(RfNamedElement namedElement) {
        return this.isReal(namedElement);
    }

    public boolean isReal(RfNamedElement namedElement) {
        LintUtils.FullTypeData fullTypeData = LintUtils.getAssociatedFinalDataType((RfAssociatedType)namedElement);
        return fullTypeData != null && fullTypeData.getAssocDataType().containsTypeName("real");
    }

    public String getMessage() {
        return "";
    }

    public boolean checkPreWaivers(ParserPath parserPath) {
        if (parserPath == null) {
            return true;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }
}

