/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.List;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;

@CheckVersion(value="21.1.20")
@CheckID(value="R.1003")
@CheckName(value="R.1003")
@CheckLabel(labels={RuleLabel.DESIGN, RuleLabel.MODULE, RuleLabel.INITIAL, RuleLabel.FINAL})
@CheckTitle(value="Do not use initial and final blocks")
@CheckDescription(value="This rule checks that initial and final blocks are not declared as they don't have a physical equivalent.\n\nExamples:\n\nmodule top();\n\tinitial begin // not allowed\n\t\t// code\n\tend\n\n\tfinal begin // not allowed\n\t\t// code\n\tend\nendmodule\n\nCheck supports pre-waiving.")
public class Check_R_1003
extends OVMComplianceCheck {
    public Check_R_1003(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        List<RfActionBlock> actionBlocks = this.fOVMProject.getRfProject().getAllActionBlocks();
        for (RfActionBlock actionBlock : actionBlocks) {
            ParserPath parserPath;
            if (actionBlock == null || actionBlock.getDeclaration() == null || this.checkPreWaivers(parserPath = actionBlock.getDeclaration().getParserPath())) continue;
            this.notifyCheckAlive();
            if (actionBlock.isInitial()) {
                this.addHit(parserPath, actionBlock.getLine(), "Initial block " + (actionBlock.isAnonymous() ? "" : "'" + actionBlock.getFullNameLabel() + "' ") + "should not be declared!", null);
            }
            if (!actionBlock.isFinal()) continue;
            this.addHit(parserPath, actionBlock.getLine(), "Final block " + (actionBlock.isAnonymous() ? "" : "'" + actionBlock.getFullNameLabel() + "' ") + "should not be declared!", null);
        }
    }

    public boolean checkPreWaivers(ParserPath parserPath) {
        if (parserPath == null) {
            return true;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }
}

