/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.IRfNamedElementVisitor;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfInstance;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;

@CheckVersion(value="21.1.19")
@CheckID(value="R.1004")
@CheckName(value="R.1004")
@CheckLabel(labels={RuleLabel.DESIGN, RuleLabel.MODULE, RuleLabel.FILE, RuleLabel.BIND})
@CheckTitle(value="Do not bind a module or to a module in the same file with its declaration")
@CheckDescription(value="This check flags bind statements of a module or to a module in the same file as the declaration of that module. Having the bind statements in a different file allows the user of the file to use the module without it being bound to other modules.\n\nCheck supports pre-waiving.")
public class Check_R_1004
extends OVMComplianceCheck {
    Map<ParserPath, Set<RfInstance.RfBindInstance>> allBinds;

    public Check_R_1004(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.allBinds = new HashMap<ParserPath, Set<RfInstance.RfBindInstance>>();
        CollectBindsVisitor bindsVisitor = new CollectBindsVisitor();
        this.fOVMProject.getRfProject().accept(bindsVisitor);
        if (this.allBinds.isEmpty()) {
            return;
        }
        NamedElementVisitor moduleVisitor = new NamedElementVisitor();
        this.fOVMProject.getRfProject().accept(moduleVisitor);
    }

    private boolean pathIsPrewaived(ParserPath path) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(path, this);
    }

    private final class CollectBindsVisitor
    implements IRfNamedElementVisitor {
        private CollectBindsVisitor() {
        }

        @Override
        public boolean visit(RfNamedElement namedElement) {
            List<? extends IRfInstanceElement> bindInstances;
            List<? extends IRfInstanceElement> list = bindInstances = namedElement instanceof IRfDesignElement ? namedElement.getBindInstances(-1L) : null;
            if (bindInstances != null && !bindInstances.isEmpty()) {
                for (IRfInstanceElement iRfInstanceElement : bindInstances) {
                    ParserPath path;
                    Check_R_1004.this.notifyCheckAlive();
                    RfDefElement declaration = ((RfInstance.RfBindInstance)iRfInstanceElement).getDeclaration();
                    if (declaration == null || Check_R_1004.this.pathIsPrewaived(path = declaration.getParserPath())) continue;
                    Set<RfInstance.RfBindInstance> binds = Check_R_1004.this.allBinds.get(path);
                    if (binds == null) {
                        binds = new HashSet<RfInstance.RfBindInstance>();
                    }
                    binds.add((RfInstance.RfBindInstance)iRfInstanceElement);
                    Check_R_1004.this.allBinds.put(path, binds);
                }
            }
            return true;
        }
    }

    private final class NamedElementVisitor
    implements IRfNamedElementVisitor {
        private NamedElementVisitor() {
        }

        @Override
        public boolean visit(RfNamedElement namedElement) {
            if (!(namedElement instanceof RfModule)) {
                return true;
            }
            Check_R_1004.this.notifyCheckAlive();
            RfDefElement declaration = namedElement.getDeclaration();
            if (declaration == null) {
                return true;
            }
            ParserPath modulePath = declaration.getDefFile().getParserPath();
            if (Check_R_1004.this.pathIsPrewaived(modulePath)) {
                return true;
            }
            Set<RfInstance.RfBindInstance> binds = Check_R_1004.this.allBinds.get(modulePath);
            if (binds == null || binds.isEmpty()) {
                return true;
            }
            for (RfInstance.RfBindInstance bindInstance : binds) {
                IRfDesignElement designInstance;
                IRfNamedElement bindModule = bindInstance.getCachedBindResult();
                if (bindModule != null) {
                    if (bindModule.equals(namedElement)) {
                        Check_R_1004.this.addHit(bindInstance, "Illegal bind '" + LintUtils.getNamedElementFullName(bindInstance) + "' in the same file with the target module " + Check_R_1004.this.link(namedElement) + " declaration!");
                    }
                } else {
                    String targetScope = bindInstance.getTargetScope();
                    if (targetScope != null && targetScope.equals(namedElement.getName())) {
                        Check_R_1004.this.addHit(bindInstance, "Illegal bind '" + LintUtils.getNamedElementFullName(bindInstance) + "' in the same file with the target module " + Check_R_1004.this.link(namedElement) + " declaration!");
                    } else {
                        List<RfInstance.TargetInstance> targetInstances = bindInstance.getTargetInstances();
                        if (targetInstances != null) {
                            for (RfInstance.TargetInstance targetInstance : targetInstances) {
                                String lastSegment;
                                ElementPath path = targetInstance.getTargetNoSelect();
                                if (path == null || path.length() != 1 || !(lastSegment = path.lastSegment()).equals(namedElement.getName())) continue;
                                Check_R_1004.this.addHit(bindInstance, "Illegal bind '" + LintUtils.getNamedElementFullName(bindInstance) + "' in the same file with the target module " + Check_R_1004.this.link(namedElement) + " declaration!");
                            }
                        }
                    }
                }
                if ((designInstance = bindInstance.getInstantiatedDesign()) == null || !(designInstance instanceof RfNamedElement) || !((RfNamedElement)designInstance).equals(namedElement)) continue;
                Check_R_1004.this.addHit(bindInstance, "Illegal bind '" + LintUtils.getNamedElementFullName(bindInstance) + "' in the same file with the bound module " + Check_R_1004.this.link((RfNamedElement)designInstance) + " declaration!");
            }
            return true;
        }
    }
}

