/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfPackage;

@CheckVersion(value="21.1.20")
@CheckID(value="R.1005")
@CheckName(value="R.1005")
@CheckLabel(labels={RuleLabel.CLASS, RuleLabel.PACKAGE, RuleLabel.VERIFICATION})
@CheckTitle(value="Classes must be defined within a package")
@CheckDescription(value="Each class must be defined within a package. Having classes in packages allows for a more precise control of a class accessibility.\n\nExamples:\n\npackage p1;\n\tclass c1; // allowed\n\tendclass\nendpackage\n\nclass c2; // not allowed\nendclass\n\nCheck supports pre-waiving.")
public class Check_R_1005
extends OVMComplianceCheck {
    public Check_R_1005(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        for (RfClass clazz : this.fOVMProject.getAllClasses()) {
            if (clazz.getDeclaration() != null && this.fOVMProject.getProjectWaivers().pathIsPrewaived(clazz.getDeclaration().getParserPath(), this)) continue;
            this.notifyCheckAlive();
            RfPackage scope = clazz.getEnclosingScope(RfPackage.class);
            if (scope != null) continue;
            this.addHit(clazz, "Class '" + LintUtils.getNamedElementFullName(clazz) + "' is not declared within a package!");
        }
    }
}

