/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.IRfNamedElementVisitor;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;

@CheckVersion(value="21.1.20")
@CheckID(value="R.1006")
@CheckName(value="R.1006")
@CheckLabel(labels={RuleLabel.DESIGN, RuleLabel.SYNTHESIS})
@CheckTitle(value="Do not use tri0/tri1 net declarations")
@CheckDescription(value="This rule checks that tri0 and tri1 net declarations are not used.\nThe tri0 and tri1 net declarations represent connections with resistive pull-down or pull-up. Because some technologies may not support tristate operations, these net declarations are not synthesizable.\n\nExamples:\nmodule top();\n\ttri0 a; // not allowed\n\ttri1 b; // not allowed\nendmodule\n\nCheck supports pre-waiving.")
public class Check_R_1006
extends OVMComplianceCheck {
    public Check_R_1006(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        try {
            this.fOVMProject.getRfProject().accept(new IRfNamedElementVisitor(){

                @Override
                public boolean visit(RfNamedElement namedElement) {
                    if (!(namedElement instanceof RfField)) {
                        return true;
                    }
                    if (namedElement.isPredefined()) {
                        return true;
                    }
                    if (namedElement.isAnonymous()) {
                        return true;
                    }
                    if (namedElement.getDeclaration() == null) {
                        return true;
                    }
                    RfNamedElement enclosingScope = namedElement.getEnclosingScope();
                    if (enclosingScope == null) {
                        return true;
                    }
                    Check_R_1006.this.notifyCheckAlive();
                    if (namedElement.getFile() == null) {
                        return true;
                    }
                    ParserPath parserPath = namedElement.getFile().getParserPath();
                    if (Check_R_1006.this.checkPreWaivers(parserPath)) {
                        return true;
                    }
                    RfDefElement declaration = namedElement.getDeclaration();
                    DataType dataType = declaration.getDataType(namedElement);
                    if (dataType == null) {
                        return true;
                    }
                    String netType = dataType.getNetType();
                    if (netType == null) {
                        return true;
                    }
                    if (netType.equals("tri0") || netType.equals("tri1")) {
                        Check_R_1006.this.addHit(parserPath, declaration.getStartLine(), "Variable '" + namedElement.getName() + "' is declared with " + netType + " net type!", declaration.getReparseInfo());
                    }
                    return true;
                }
            });
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            this.fOVMProject.notifyCheckException(this, e);
        }
    }

    public boolean checkPreWaivers(ParserPath parserPath) {
        if (parserPath == null) {
            return true;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }
}

