/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.Collection;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;

@CheckVersion(value="21.1.19")
@CheckID(value="R.1007")
@CheckName(value="R.1007")
@CheckLabel(labels={RuleLabel.METHOD, RuleLabel.OVERRIDE, RuleLabel.VERIFICATION})
@CheckTitle(value="When overriding XVM virtual methods do not use the virtual keyword")
@CheckDescription(value="The 'virtual' keyword is optional for overriding methods. For XVM methods which are known to be virtual it only clutters the code.\n\nCheck supports pre-waiving.")
public class Check_R_1007
extends OVMComplianceCheck {
    public Check_R_1007(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        for (RfNamedElement clazz : this.fOVMProject.getAllNonXVMClasses()) {
            if (!(clazz instanceof RfClass)) continue;
            this.checkClass((RfClass)clazz);
        }
    }

    private void checkClass(RfClass clazz) {
        if (clazz == null) {
            return;
        }
        RfClass classParent = clazz.getParent();
        if (classParent == null) {
            return;
        }
        this.notifyCheckAlive();
        RfFileDef file = clazz.getFile();
        if (file == null) {
            return;
        }
        if (this.fOVMProject.getProjectWaivers().pathIsPrewaived(file.getParserPath(), this)) {
            return;
        }
        this.checkMethods(clazz.getLocalMembers(RfFunction.class));
    }

    private void checkMethods(Collection<RfFunction> methods) {
        if (methods == null || methods.isEmpty()) {
            return;
        }
        for (RfFunction method : methods) {
            if (method == null || method.isPredefined() || !method.hasVirtualQualifier() || !this.fOVMProject.isOVMFunctionOverride(method)) continue;
            this.addHit(method, "Overriding method '" + LintUtils.getNamedElementFullName(method) + "' contains the virtual keyword in the declaration!");
        }
    }
}

