/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.List;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.linter.utils.OVMUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfCovergroup;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccessArgs;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="21.1.20")
@CheckID(value="R.1008")
@CheckName(value="R.1008")
@CheckLabel(labels={RuleLabel.COVERAGE, RuleLabel.COVERGROUP, RuleLabel.TRANSACTION, RuleLabel.UVM_SEQUENCE, RuleLabel.VERIFICATION})
@CheckTitle(value="Do not declare and instantiate covergroups in transactions and sequences")
@CheckDescription(value="This check flags covergroup declarations and instantiations in classes that inherit from xvm_transaction. \nCoverage should be collected from objects that endure throughout the simulation, not from objects that are not persistent over time.\n\nCheck supports pre-waiving.")
public class Check_R_1008
extends OVMComplianceCheck {
    public Check_R_1008(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        String xvm_transaction = String.valueOf(OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_pkg")) + "::" + OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_transaction");
        RfClass transactionClass = this.fOVMProject.getRfProject().getClass(xvm_transaction, true);
        if (transactionClass == null) {
            return;
        }
        Set<RfClass> allTransactions = this.fOVMProject.getAllXVMSubClasses(transactionClass);
        if (allTransactions.isEmpty()) {
            return;
        }
        for (RfClass clazz : allTransactions) {
            if (clazz.getDeclaration() != null && this.fOVMProject.getProjectWaivers().pathIsPrewaived(clazz.getDeclaration().getParserPath(), this)) continue;
            this.notifyCheckAlive();
            List<RfCovergroup> covergroups = clazz.getCovergroupsWithPrefix("", 2, 1);
            String className = LintUtils.getNamedElementFullName(clazz);
            if (covergroups != null) {
                for (RfCovergroup covergroup : covergroups) {
                    this.addHit(covergroup, "Covergroup '" + covergroup.getName() + "' declared in class '" + className + "'!");
                }
            }
            clazz.visitHidObject(this.fOVMProject.getRfProject(), new LocalHidOperatorVisitor(className));
        }
    }

    public class LocalHidOperatorVisitor
    implements IHidVisitor<RfHidOperator> {
        private ParserPath parserPath;
        private String className;

        public LocalHidOperatorVisitor(String className) {
            this.className = className;
        }

        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }

        public boolean visit(RfHidOperator hidObject) {
            if (!hidObject.isAssignment()) {
                return true;
            }
            ListContainer rhValues = hidObject.getRHValues();
            if (rhValues == null || rhValues.isEmpty()) {
                return true;
            }
            IHidObject rhValue = (IHidObject)rhValues.get(0);
            Hid rhHid = null;
            if (rhValue instanceof RfHidAccessArgs) {
                rhHid = ((RfHidAccessArgs)rhValue).getParentHid();
            }
            if (rhValue instanceof RfHid) {
                rhHid = (RfHid)rhValue;
            }
            if (!(rhHid instanceof RfHid)) {
                return true;
            }
            RfHid rhValueHid = (RfHid)rhHid;
            IRfNamedElement rightElement = rhValueHid.getElement();
            if (!(rightElement instanceof RfFunction)) {
                return true;
            }
            if (!((RfFunction)rightElement).isConstructor()) {
                return true;
            }
            if (!(((RfFunction)rightElement).getEnclosingScope() instanceof RfCovergroup)) {
                return true;
            }
            IHidObject lhValue = hidObject.getLHValue();
            String lhValueName = null;
            if (lhValue instanceof RfHid) {
                lhValueName = ((RfHid)lhValue).getName();
            }
            if (lhValue instanceof RfHidImplicit) {
                lhValueName = ((RfHidImplicit)lhValue).getName();
            }
            if (lhValueName == null) {
                return true;
            }
            Check_R_1008.this.addHit(this.parserPath, (HidOccurrence)hidObject.getOccurrence(), "Covergroup '" + lhValueName + "' initialized in class '" + this.className + "'!");
            return true;
        }

        public Class<RfHidOperator> getType() {
            return RfHidOperator.class;
        }
    }
}

