/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.linter.utils.OVMUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;

@CheckVersion(value="21.1.22")
@CheckID(value="R.1009")
@CheckName(value="R.1009")
@CheckLabel(labels={RuleLabel.NAME, RuleLabel.FACTORY_CREATE, RuleLabel.STYLING, RuleLabel.VERIFICATION})
@CheckTitle(value="XVM instance naming pattern")
@CheckDescription(value="This check verifies that the XVM instances have names that match the specified pattern.\nIt is generally not advised to use special characters in instance names as this can make it hard to interpret the generated reports of the project.\n\nCheck supports pre-waiving.")
public class Check_R_1009
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="^[a-zA-Z0-9_]*$", description="The instance name pattern.", name="namePattern", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.REGEX)
    private Pattern pNamePatternValue;
    private static final Set<String> FACTORY_CREATE_FUNCTION_NAMES = new HashSet<String>();
    private RfClass objectRegistryClass;
    private RfClass componentRegistryClass;
    private RfClass objectWrapperClass;
    private RfClass factoryClass;
    private RfClass componentClass;

    static {
        FACTORY_CREATE_FUNCTION_NAMES.add("create_object_by_type");
        FACTORY_CREATE_FUNCTION_NAMES.add("create_object_by_name");
        FACTORY_CREATE_FUNCTION_NAMES.add("create_component_by_type");
        FACTORY_CREATE_FUNCTION_NAMES.add("create_component_by_name");
    }

    public Check_R_1009(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.objectRegistryClass = this.fOVMProject.getRfProject().getClass(String.valueOf(OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_pkg::")) + OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_object_registry"), true);
        this.componentRegistryClass = this.fOVMProject.getRfProject().getClass(String.valueOf(OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_pkg::")) + OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_component_registry"), true);
        this.objectWrapperClass = this.fOVMProject.getRfProject().getClass(String.valueOf(OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_pkg::")) + OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_object_wrapper"), true);
        this.factoryClass = this.fOVMProject.getRfProject().getClass(String.valueOf(OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_pkg::")) + OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_factory"), true);
        this.componentClass = this.fOVMProject.getRfProject().getClass(String.valueOf(OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_pkg::")) + OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_component"), true);
        this.fOVMProject.getRfProject().visitHidObject(null, new LocalHidVisitor());
    }

    private boolean isXVMCreateFunction(RfFunction function) {
        String functionName = function.getName();
        RfNamedElement enclosingScope = function.getEnclosingScope();
        if (enclosingScope == null || !(enclosingScope instanceof RfClass)) {
            return false;
        }
        RfClass enclosingClass = (RfClass)enclosingScope;
        if (!functionName.equals("create")) {
            return false;
        }
        if (functionName.equals("create") && (LintUtils.isSubClassOf(enclosingClass, this.objectRegistryClass) || LintUtils.isSubClassOf(enclosingClass, this.componentRegistryClass))) {
            return true;
        }
        if (functionName.equals("create_component") && LintUtils.isSubClassOf(enclosingClass, this.componentClass)) {
            return true;
        }
        if (functionName.equals("create_object") && (LintUtils.isSubClassOf(enclosingClass, this.objectWrapperClass) || LintUtils.isSubClassOf(enclosingClass, this.componentClass))) {
            return true;
        }
        return FACTORY_CREATE_FUNCTION_NAMES.contains(functionName) && LintUtils.isSubClassOf(enclosingClass, this.factoryClass);
    }

    private boolean isXVMNewFunction(RfFunction function) {
        if (!function.getName().equals("new")) {
            return false;
        }
        IRfNamedElement type = function.getAssociatedType();
        while (type instanceof RfClass) {
            if (this.fOVMProject.isOVMElement((RfClass)type)) {
                return true;
            }
            type = ((RfClass)type).getParent();
        }
        return false;
    }

    public boolean checkPreWaivers(ParserPath parserPath) {
        if (parserPath == null) {
            return true;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    class LocalHidVisitor
    extends RfHidVisitor {
        LocalHidVisitor() {
        }

        public boolean visit(RfHid rfHid) {
            if (Check_R_1009.this.checkPreWaivers(this.parserPath)) {
                return true;
            }
            if (!rfHid.isMethodCall(false)) {
                return true;
            }
            if (!(rfHid.getElement() instanceof RfFunction)) {
                return true;
            }
            Check_R_1009.this.notifyCheckAlive();
            RfFunction function = (RfFunction)rfHid.getElement();
            if (!Check_R_1009.this.isXVMCreateFunction(function) && !Check_R_1009.this.isXVMNewFunction(function)) {
                return true;
            }
            List methodCalls = MethodCallUtils.getMethodCalls((IHid)rfHid);
            if (methodCalls == null || methodCalls.isEmpty()) {
                return true;
            }
            for (MethodCall methodCall : methodCalls) {
                Matcher instanceNameMatcher;
                RfHidImplicit argumentHidImplicit;
                String name;
                if (methodCall.argumentValuesMapRaw == null) continue;
                IHidObject nameArgumentValue = null;
                for (Map.Entry argument : methodCall.argumentValuesMapRaw.entrySet()) {
                    IHidObject argumentValue = (IHidObject)argument.getValue();
                    if (argumentValue == null || !((IRfFieldElement)argument.getKey()).getName().equals("name")) continue;
                    nameArgumentValue = argumentValue;
                }
                if (nameArgumentValue == null || !(nameArgumentValue instanceof RfHidImplicit) || (name = (argumentHidImplicit = (RfHidImplicit)nameArgumentValue).getName().substring(1, argumentHidImplicit.getName().length() - 1)) == null || name.equals("") || (instanceNameMatcher = Check_R_1009.this.pNamePatternValue.matcher(name)).matches()) continue;
                Check_R_1009.this.addHit(this.parserPath, rfHid, "Instance name '" + name + "' does not match the given pattern!");
            }
            return true;
        }
    }
}

