/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfThisImplicitVariable;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="21.1.24")
@CheckID(value="R.1010")
@CheckName(value="R.1010")
@CheckLabel(labels={RuleLabel.ASSIGNMENT, RuleLabel.DEAD_CODE})
@CheckTitle(value="Do not assign a variable to itself")
@CheckDescription(value="This rule flags assignment statements that assign a variable to itself.\nExample:\nvar1 = var1; //NOT ALLOWED\n\nCheck supports pre-waiving.")
public class Check_R_1010
extends OVMComplianceCheck {
    public Check_R_1010(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.fOVMProject.getRfProject().visitHidObject(null, new OperatorVisior());
    }

    public boolean checkPrewaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    private class OperatorVisior
    implements IHidVisitor<RfHidOperator> {
        ParserPath parserPath;

        private OperatorVisior() {
        }

        public boolean visit(RfHidOperator hidObject) {
            if (!hidObject.isAssignment()) {
                return true;
            }
            if (Check_R_1010.this.checkPrewaivers(this.parserPath)) {
                return true;
            }
            Check_R_1010.this.notifyCheckAlive();
            IHidObject lhValue = hidObject.getLHValue();
            ListContainer rhValues = hidObject.getRHValues();
            if (!(lhValue instanceof RfHid)) {
                return true;
            }
            if (rhValues == null || rhValues.size() != 1) {
                return true;
            }
            IHidObject rhValue = (IHidObject)rhValues.get(0);
            if (!(rhValue instanceof RfHid)) {
                return true;
            }
            if (((RfHid)lhValue).getElement() == null || ((RfHid)rhValue).getElement() == null) {
                return true;
            }
            if (!lhValue.equals(rhValue) && !((RfHid)lhValue).getElement().equals(((RfHid)rhValue).getElement())) {
                return true;
            }
            if (lhValue.equals(rhValue)) {
                Check_R_1010.this.addHit(this.parserPath, (HidOccurrence)hidObject.getOccurrence(), "Variable '" + ((RfHid)lhValue).getName() + "' is assigned to itself!");
            } else if (((RfHid)lhValue).getElement().equals(((RfHid)rhValue).getElement())) {
                boolean leftHasThisParent = this.hasThisParent((RfHid)lhValue);
                boolean rightHasThisParent = this.hasThisParent((RfHid)rhValue);
                String leftLiteralValue = HidUtils.toNiceString((IHidObject)lhValue);
                String rightLiteralValue = HidUtils.toNiceString((IHidObject)rhValue);
                if (leftHasThisParent) {
                    leftLiteralValue = leftLiteralValue.substring("this.".length());
                }
                if (rightHasThisParent) {
                    rightLiteralValue = rightLiteralValue.substring("this.".length());
                }
                if (leftLiteralValue.equals(rightLiteralValue)) {
                    Check_R_1010.this.addHit(this.parserPath, (HidOccurrence)hidObject.getOccurrence(), "Variable '" + ((RfHid)lhValue).getName() + "' is assigned to itself!");
                }
            }
            return true;
        }

        private boolean hasThisParent(Hid hid) {
            while (hid.getParentHid() != null && !(hid.getParentHid().getElement() instanceof RfThisImplicitVariable)) {
                if (!(hid instanceof RfHid)) {
                    return false;
                }
                hid = hid.getParentHid();
            }
            return hid.getParentHid() != null;
        }

        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }

        public Class<RfHidOperator> getType() {
            return RfHidOperator.class;
        }
    }
}

