/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;

@CheckVersion(value="21.1.23")
@CheckID(value="R.1011")
@CheckName(value="R.1011")
@CheckLabel(labels={RuleLabel.CLASS_INSTANTIATION, RuleLabel.UVM_IEEE, RuleLabel.VERIFICATION})
@CheckTitle(value="Do not instantiate UVM IEEE virtual classes")
@CheckDescription(value="The \"uvm_reg_backdoor\" and \"uvm_vreg_field_cbs\" classes are now abstract in UVM IEEE.\nIt is illegal to instantiate an abstract class directly.\n\nCheck supports pre-waiving.")
public class Check_R_1011
extends OVMComplianceCheck {
    public Check_R_1011(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        final RfClass uvmRegBackdoorClass = this.fOVMProject.getRfProject().getClass("uvm_reg_backdoor", false);
        final RfClass uvmVregFieldCbsClass = this.fOVMProject.getRfProject().getClass("uvm_vreg_field_cbs", false);
        if (uvmRegBackdoorClass == null || uvmVregFieldCbsClass == null) {
            return;
        }
        this.fOVMProject.getRfProject().visitHidObject(null, new IHidVisitor<RfHid>(){
            private ParserPath parserPath;
            private IHidHolder holder;

            public boolean visit(RfHid hid) {
                RfClass holderClass;
                RfFunction scopeFunction;
                IRfNamedElement element = hid.getElement();
                if (!(element instanceof RfFunction)) {
                    return true;
                }
                if (!(this.holder instanceof RfHidHolder)) {
                    return true;
                }
                if (Check_R_1011.this.checkPreWaivers(this.parserPath)) {
                    return true;
                }
                Check_R_1011.this.notifyCheckAlive();
                RfFunction function = (RfFunction)element;
                if (!function.isConstructor()) {
                    return true;
                }
                RfClass enclosingClass = function.getEnclosingScope(RfClass.class);
                if (enclosingClass == null) {
                    return true;
                }
                if (!enclosingClass.equals(uvmVregFieldCbsClass) && !enclosingClass.equals(uvmRegBackdoorClass)) {
                    return true;
                }
                IRfNamedElement holderScope = ((RfHidHolder)this.holder).getScope();
                if (holderScope instanceof RfFunction && (scopeFunction = (RfFunction)holderScope).isConstructor() && ((holderClass = scopeFunction.getEnclosingScope(RfClass.class)) == null || LintUtils.isSubClassOf(holderClass, uvmRegBackdoorClass) || LintUtils.isSubClassOf(holderClass, uvmVregFieldCbsClass))) {
                    return true;
                }
                Check_R_1011.this.addHit(this.parserPath, hid, "Illegal constructor call for UVM IEEE abstract class '" + enclosingClass.getName() + "'!");
                return true;
            }

            public void setHolder(IHidHolder holder) {
                this.holder = holder;
            }

            public void setParserPath(ParserPath parserPath) {
                this.parserPath = parserPath;
            }

            public Class<RfHid> getType() {
                return RfHid.class;
            }
        });
    }

    private boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }
}

