/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.HashSet;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfCovergroup;
import ro.amiq.vlogdt.model.reflection.RfCoverpoint;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;

@CheckVersion(value="21.1.27")
@CheckID(value="R.1012")
@CheckName(value="R.1012")
@CheckLabel(labels={RuleLabel.COVERAGE, RuleLabel.COVERGROUP, RuleLabel.COVERPOINT, RuleLabel.OPTION, RuleLabel.VERIFICATION})
@CheckTitle(value="Set the at_least option of each covergroup and each coverpoint to a value different than 1")
@CheckDescription(value="This rule checks that for each covergroup and each coverpoint the at_least option is set to a value different than 1.\nThe default value of this option ensures that each state is hit at least once. Having each state hit multiple times can ensure that the state is tested for deadlock issues.\n\nExamples:\ncovergroup cg1;\n\tcoverpoint x;\n\toption.at_least = 1;  // not allowed\n\n\tpoint: coverpoint x {\n\t\toption.at_least = 5;  // allowed\n\t}\nendgroup\n\nCheck supports pre-waiving.")
public class Check_R_1012
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="false", description="When true, coverpoints are skipped.", name="skipCoverpoints", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pSkipCoverpoints;
    @CheckParameter(defaultValue="false", description="When true, the default value of the option is allowed if it is explicitly declared.", name="allowExplicitDefaultValue", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pAllowExplicitDefaultValue;

    public Check_R_1012(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        Set<RfNamedElement> validElements = this.collectValidElements();
        this.checkCovergroupsAndCoverpoints(validElements);
    }

    private Set<RfNamedElement> collectValidElements() {
        final HashSet<RfNamedElement> validElements = new HashSet<RfNamedElement>();
        this.fOVMProject.getRfProject().visitHidObject(this.fOVMProject.getRfProject(), (IHidVisitor<?>)new HidOperatorVisitor(new HidOperatorQualifier[]{HidOperatorQualifier.IS_PATTERN_VALUE}){

            public boolean visit(HidOperator operator) {
                if (!operator.isAssignment()) {
                    return true;
                }
                if (Check_R_1012.this.checkPreWaivers(this.parserPath)) {
                    return true;
                }
                IHidObject lhValue = operator.getLHValue();
                if (lhValue == null) {
                    return true;
                }
                if (!(lhValue instanceof RfHid)) {
                    return true;
                }
                Check_R_1012.this.notifyCheckAlive();
                RfHid leftValue = (RfHid)operator.getLHValue();
                if (!leftValue.getName().equals("at_least")) {
                    return true;
                }
                Hid parentHid = leftValue.getParentHid();
                if (parentHid == null) {
                    return true;
                }
                if (!parentHid.getName().equals("option")) {
                    return true;
                }
                IRfNamedElement element = parentHid.getElement();
                if (element == null) {
                    return true;
                }
                IRfScopeElement enclosingScope = element.getEnclosingScope();
                if (!(enclosingScope instanceof RfCovergroup) && !(enclosingScope instanceof RfCoverpoint)) {
                    return true;
                }
                if (Check_R_1012.this.pSkipCoverpoints && enclosingScope instanceof RfCoverpoint) {
                    return true;
                }
                validElements.add((RfNamedElement)enclosingScope);
                ListContainer rhValues = operator.getRHValues();
                if (rhValues == null || rhValues.size() != 1) {
                    return true;
                }
                if (!(rhValues.get(0) instanceof RfHidImplicit)) {
                    return true;
                }
                RfHidImplicit atLeastOptionValue = (RfHidImplicit)rhValues.get(0);
                if (!atLeastOptionValue.getName().equals("1")) {
                    return true;
                }
                if (Check_R_1012.this.pAllowExplicitDefaultValue) {
                    return true;
                }
                Check_R_1012.this.addHit(this.parserPath, (HidOccurrence)operator.getOccurrence(), "option.at_least is set for " + LintUtils.getElementKind((RfNamedElement)enclosingScope) + " '" + LintUtils.getNamedElementFullName((RfNamedElement)enclosingScope) + "' with value 1!");
                return true;
            }
        });
        return validElements;
    }

    private void checkCovergroupsAndCoverpoints(Set<RfNamedElement> validElements) {
        try {
            this.fOVMProject.getRfProject().accept(namedElement -> {
                boolean isCovergroup = namedElement instanceof RfCovergroup;
                boolean isCoverpoint = namedElement instanceof RfCoverpoint;
                if (!isCovergroup && !isCoverpoint) {
                    return true;
                }
                if (this.pSkipCoverpoints && isCoverpoint) {
                    return true;
                }
                this.notifyCheckAlive();
                if (validElements.contains(namedElement)) {
                    return true;
                }
                String typeOfElement = DVTStringUtil.capitalizeFirstLetter((String)LintUtils.getElementKind(namedElement));
                this.addHit(namedElement, String.valueOf(typeOfElement) + " '" + namedElement.getName() + "' does not set the at_least option!");
                return true;
            });
        }
        catch (Exception e) {
            this.fOVMProject.notifyCheckException(this, e);
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public boolean checkPreWaivers(ParserPath parserPath) {
        if (parserPath == null) {
            return true;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }
}

