/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;

@CheckVersion(value="21.1.26")
@CheckID(value="R.1025")
@CheckName(value="R.1025")
@CheckLabel(labels={RuleLabel.UVM_IEEE, RuleLabel.FIELD, RuleLabel.VERIFICATION, RuleLabel.REMOVED_API})
@CheckTitle(value="Do not use uvm_pkg::uvm_top")
@CheckDescription(value="Do not use uvm_pkg::uvm_top, it is removed from UVM IEEE 1800.2-2020 standard and library implementation, use uvm_root::get() instead.\n\nCheck supports pre-waiving.")
public class Check_R_1025
extends OVMComplianceCheck {
    private static final String UVM_TOP = "uvm_pkg::uvm_top";
    private static final String UVM_ROOT_GET = "uvm_root::get()";

    public Check_R_1025(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        RfProject rfProject = this.fOVMProject.getRfProject();
        if (rfProject == null) {
            return;
        }
        rfProject.visitHidObject(rfProject, new LocalHidVisitor());
    }

    public boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    private final class LocalHidVisitor
    extends RfHidVisitor {
        private LocalHidVisitor() {
        }

        public boolean visit(RfHid hidObject) {
            if (hidObject == null) {
                return true;
            }
            IRfNamedElement element = hidObject.getElement();
            if (!(element instanceof RfField)) {
                return true;
            }
            RfField field = (RfField)element;
            if (Check_R_1025.this.checkPreWaivers(this.parserPath)) {
                return true;
            }
            Check_R_1025.this.notifyCheckAlive();
            String fieldName = field.getFullName();
            if (fieldName.equals(Check_R_1025.UVM_TOP)) {
                Check_R_1025.this.addHit(this.parserPath, hidObject, "The global variable '" + fieldName + "' is removed from the UVM IEEE library, use instead '" + Check_R_1025.UVM_ROOT_GET + "'!");
            }
            return true;
        }
    }
}

