/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.OVMUtils;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;

@CheckVersion(value="21.1.26")
@CheckID(value="R.1026")
@CheckName(value="R.1026")
@CheckLabel(labels={RuleLabel.BANNED_API, RuleLabel.METHOD, RuleLabel.TEST, RuleLabel.VERIFICATION})
@CheckTitle(value="Do not use xvm_root.run_test()")
@CheckDescription(value="Do not use xvm_root.run_test(), use the convenience method xvm_pkg::run_test() instead.\n\nCheck supports pre-waiving.")
public class Check_R_1026
extends OVMComplianceCheck {
    private final String XVM_ROOT_RUN_TEST;
    private final String XVM_PKG_RUN_TEST;

    public Check_R_1026(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
        this.XVM_ROOT_RUN_TEST = String.valueOf(OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_pkg")) + "::" + OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_root.run_test");
        this.XVM_PKG_RUN_TEST = OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_pkg::run_test()");
    }

    @Override
    public void performCheckImpl() {
        this.fOVMProject.getLibraryKind();
        RfProject rfProject = this.fOVMProject.getRfProject();
        if (rfProject == null) {
            return;
        }
        rfProject.visitHidObject(rfProject, new LocalHidVisitor());
    }

    public boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    private final class LocalHidVisitor
    extends RfHidVisitor {
        private LocalHidVisitor() {
        }

        public boolean visit(RfHid hidObject) {
            if (hidObject == null) {
                return true;
            }
            IRfNamedElement element = hidObject.getElement();
            if (!(element instanceof RfFunction)) {
                return true;
            }
            RfFunction method = (RfFunction)element;
            if (Check_R_1026.this.checkPreWaivers(this.parserPath)) {
                return true;
            }
            Check_R_1026.this.notifyCheckAlive();
            String methodName = method.getFullName();
            if (methodName.equals(Check_R_1026.this.XVM_ROOT_RUN_TEST)) {
                Check_R_1026.this.addHit(this.parserPath, hidObject, "Do not use the '" + methodName + "' task, use instead '" + Check_R_1026.this.XVM_PKG_RUN_TEST + "'!");
            }
            return true;
        }
    }
}

