/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.parser.ReparseInfo;

@CheckVersion(value="21.1.40")
@CheckID(value="R.1027")
@CheckName(value="R.1027")
@CheckLabel(labels={RuleLabel.UVM_IEEE, RuleLabel.FIELD, RuleLabel.VERIFICATION, RuleLabel.REMOVED_API})
@CheckTitle(value="Do not use uvm_printer_knobs fields")
@CheckDescription(value="Do not use uvm_printer_knobs fields, they are removed from UVM IEEE 1800.2-2020 standard and library, use uvm_printer accessor methods instead.\n\nExamples:\nmy_uvm_printer my_printer;\nmy_printer.knobs.separator = \"\\t\"; // not allowed\nmy_printer.knobs.depth = 1; // not allowed\n\nuvm_tree_printer my_printer = new();\nmy_printer.set_separators(\"\\t\"); // allowed\n\nCheck supports pre-waiving.")
public class Check_R_1027
extends OVMComplianceCheck {
    private static final Set<String> UVM_KNOBS_FIELDS = new HashSet<String>(Arrays.asList("identifier", "type_name", "size", "depth", "reference", "begin_elements", "end_elements", "prefix", "indent", "show_root", "mcd", "separator", "show_radix", "default_radix", "dec_radix", "bin_radix", "oct_radix", "unsigned_radix", "hex_radix", "max_width", "truncation", "name_width", "type_width", "size_width", "value_width", "sprint"));

    public Check_R_1027(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        LocalHidVisitor visitor = new LocalHidVisitor();
        this.fOVMProject.getRfProject().visitHidObject(null, visitor);
    }

    public boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    public class LocalHidVisitor
    implements IHidVisitor<IHidObject> {
        RfNamedElement scope;
        ParserPath parserPath;

        public boolean visit(IHidObject hidObject) {
            if (this.scope == null) {
                return true;
            }
            if (this.scope.isPredefined()) {
                return true;
            }
            if (Check_R_1027.this.checkPreWaivers(this.parserPath)) {
                return true;
            }
            if (!(hidObject instanceof RfHid)) {
                return true;
            }
            RfHid hid = (RfHid)hidObject;
            if (!UVM_KNOBS_FIELDS.contains(hid.getName())) {
                return true;
            }
            Check_R_1027.this.notifyCheckAlive();
            Hid parentHid = hid.getParentHid();
            if (!(parentHid instanceof RfHid)) {
                return true;
            }
            IRfNamedElement associatedType = hid.getParentAccess().getAssociatedType();
            if (!(associatedType instanceof RfClass)) {
                return true;
            }
            if (!associatedType.getName().equals("uvm_printer_knobs")) {
                return true;
            }
            ReparseInfo reparseInfo = null;
            if (hid.getReparseInfo() != null && hid.getReparseInfo() instanceof ReparseInfo) {
                reparseInfo = (ReparseInfo)hid.getReparseInfo();
            }
            Check_R_1027.this.addHit(this.parserPath, hid.getOccurrence().getLine(), "Do not use uvm_printer_knobs field '" + hid.getName() + "', use accessor methods instead!", reparseInfo, false);
            return true;
        }

        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }

        public void setHolder(IHidHolder holder) {
            this.scope = (RfNamedElement)((RfHidHolder)holder).getScope();
        }

        public Class<IHidObject> getType() {
            return IHidObject.class;
        }
    }
}

