/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.List;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;

@CheckVersion(value="21.1.26")
@CheckID(value="R.1028")
@CheckName(value="R.1028")
@CheckLabel(labels={RuleLabel.PREDEFINED_METHOD, RuleLabel.ARGUMENT, RuleLabel.FUNCTIONAL})
@CheckTitle(value="Call $fopen with type argument specified")
@CheckDescription(value="The function $fopen returns either a 32-bit multichannel descriptor or a 32-bit file descriptor, determined by the absence or presence of the type argument.\nWhen calling $fopen without a type argument, it returns the 32-bit multichannel descriptor in which a single bit is set. This means that calling $fopen this way can only be done for 31 files.\n\nExamples:\n\nfd1 = $fopen(\"test.txt\", \"r\"); // allowed\nfd2 = $fopen(\"test.txt\"); // not allowed\nfd3 = $fopen(.filename(\"test.txt\")); // not allowed\n\nCheck supports pre-waiving.")
public class Check_R_1028
extends OVMComplianceCheck {
    public Check_R_1028(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.fOVMProject.getRfProject().visitHidObject(null, new LocalHidVisitor());
    }

    public boolean checkPreWaivers(ParserPath parserPath) {
        if (parserPath == null) {
            return true;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    class LocalHidVisitor
    extends RfHidVisitor {
        LocalHidVisitor() {
        }

        public boolean visit(RfHid rfHid) {
            if (Check_R_1028.this.checkPreWaivers(this.parserPath)) {
                return true;
            }
            Check_R_1028.this.notifyCheckAlive();
            if (!rfHid.isMethodCall(false)) {
                return true;
            }
            if (!rfHid.getName().equals("$fopen")) {
                return true;
            }
            List methodCalls = MethodCallUtils.getMethodCalls((IHid)rfHid);
            if (methodCalls == null || methodCalls.isEmpty()) {
                return true;
            }
            for (MethodCall methodCall : methodCalls) {
                if (methodCall.argumentValuesMapRaw == null || methodCall.argumentValuesMapRaw.entrySet().size() == 2) continue;
                Check_R_1028.this.addHit(this.parserPath, rfHid, "$fopen call does not have type argument specified!");
            }
            return true;
        }
    }
}

