/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.rules.AbstractUVMIEEEDeviationCheck;

@CheckVersion(value="21.1.27")
@CheckID(value="R.1032")
@CheckName(value="R.1032")
@CheckLabel(labels={RuleLabel.UVM_IEEE, RuleLabel.METHOD, RuleLabel.VERIFICATION})
@CheckTitle(value="Do not use UVM IEEE 1800.2-2020 uvm_reg_map.add_mem deviation")
@CheckDescription(value="Section 18.2.3.4 of the UVM IEEE 1800.2-2020 standard says that an address map may be added to multiple address maps if it is accessible from multiple pysical interfaces. \nThis map structure was not supported in UVM1.2 and an attempt to add to multiple address maps would result in an error. \nThe UVM IEEE 1800.2-2020 implementation will still produce an error if an address map is added to multiple address maps.\n\nCheck supports pre-waiving.")
public class Check_R_1032
extends AbstractUVMIEEEDeviationCheck {
    public Check_R_1032(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
        this.methodName = "uvm_pkg::uvm_reg_map.add_mem";
    }

    @Override
    protected boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }
}

