/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import ro.amiq.dvt.model.reflection.IReparseInfo;
import ro.amiq.dvt.model.reflection.LineInfo;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixAdditionalInfo;
import ro.amiq.vlogdt.linter.autofixes.fixes.Autofix_R_1033;
import ro.amiq.vlogdt.linter.base.annotations.CheckAutofix;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;
import ro.amiq.vlogdt.parser.MacroCallInfo;
import ro.amiq.vlogdt.parser.MacroCallItem;

@CheckVersion(value="21.1.32")
@CheckID(value="R.1033")
@CheckName(value="R.1033")
@CheckLabel(labels={RuleLabel.MACRO, RuleLabel.METHOD})
@CheckTitle(value="Call macro from specified method")
@CheckDescription(value="This rule checks that the `<macroName> is called at the beginning of the procedural code in all methods.\n\nExample:\nfunction void my_func();\n  int a;\n  `<macroName>  // allowed\n  a = a + 1;\nendfunction\n\nfunction void my_func2(); // not allowed\n  int a;\n  a = a + 1;\nendfunction\n\nCheck supports pre-waiving.\nCheck supports auto-correcting.")
@CheckAutofix(value=Autofix_R_1033.class)
public class Check_R_1033
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="", description="The name of the macro that must be called in the specified methods", name="macroName", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.STRING)
    protected String pMacroName;
    @CheckParameter(defaultValue="", description="One of function, task. If empty, both will be checked.", name="methodType", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.STRING)
    protected String pMethodType;
    @CheckParameter(defaultValue="", description="Base class to check. If empty, all functions or tasks will be checked", name="baseClass", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.STRING)
    protected String pBaseClass;
    @CheckParameter(defaultValue="", description="Comma separated list of method names from the base class to be checked. It's not used if tha baseClass is not specified. The base class and all the child implementations will be checked.", name="baseClassMethods", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    protected Set<String> pBaseClassMethods;
    @CheckParameter(defaultValue="", description="Comma separated list of method full name patterns to be skipped.", name="skipMethods", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_REGEX)
    protected Set<Pattern> pSkipMethods;
    private RfClass baseClass;

    public Check_R_1033(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void preBuildNotification(RfProject aRfProject) {
        HashSet<String> macros = new HashSet<String>();
        macros.add("`" + this.pMacroName);
        aRfProject.lintTrackMacrosByNames("all", macros);
    }

    @Override
    public void performCheckImpl() {
        if (this.pMacroName.isEmpty()) {
            return;
        }
        if (this.pBaseClass != null && !this.pBaseClass.isEmpty()) {
            this.baseClass = this.fOVMProject.getRfProject().getClass(this.pBaseClass, true);
        }
        if (this.pMethodType.equals("function")) {
            this.checkFunctions();
        } else if (this.pMethodType.equals("task")) {
            this.checkTasks();
        } else {
            this.checkFunctions();
            this.checkTasks();
        }
    }

    private void checkFunctions() {
        for (RfNamedElement element : this.fOVMProject.getAllFunctions()) {
            RfFunction function;
            if (!(element instanceof RfFunction) || (function = (RfFunction)element).getDeclaration() != null && this.checkPreWaivers(function.getDeclaration().getParserPath())) continue;
            this.analyzeFunctionOrTask(function, "Function");
        }
    }

    private void checkTasks() {
        for (RfNamedElement element : this.fOVMProject.getAllTasks()) {
            RfFunction task;
            if (!(element instanceof RfFunction) || (task = (RfFunction)element).getDeclaration() != null && this.checkPreWaivers(task.getDeclaration().getParserPath())) continue;
            this.analyzeFunctionOrTask(task, "Task");
        }
    }

    private void analyzeFunctionOrTask(RfFunction method, String methodType) {
        MacroCallInfo macroCallInfo;
        this.notifyCheckAlive();
        for (Pattern skipMethod : this.pSkipMethods) {
            if (!skipMethod.matcher(method.getFullName()).matches()) continue;
            return;
        }
        if (this.baseClass != null) {
            RfClass enclosingClass = method.getEnclosingScope(RfClass.class);
            if (enclosingClass == null) {
                return;
            }
            if (!LintUtils.isSubClassOf(enclosingClass, this.baseClass)) {
                return;
            }
            if (!this.pBaseClassMethods.isEmpty()) {
                boolean found = false;
                for (String methodName : this.pBaseClassMethods) {
                    if (!methodName.equals(method.getName())) continue;
                    found = true;
                }
                if (!found) {
                    return;
                }
            }
        }
        if ((macroCallInfo = method.getMacroCallInfo()) == null) {
            return;
        }
        List<MacroCallItem> items = macroCallInfo.getItems("`" + this.pMacroName);
        if (items == null || items.isEmpty()) {
            this.addHit(method, String.valueOf(methodType) + " " + method.getName() + " is not calling the `" + this.pMacroName + " macro!", new VerissimoAutofixAdditionalInfo(method));
            return;
        }
        MacroCallItem item = items.get(0);
        HidVisitor visitor = new HidVisitor(item.getLineInfo(), this.pMacroName);
        method.visitHidObject(this.fOVMProject.getRfProject(), visitor);
        if (visitor.isNotFirstStatement()) {
            this.addHit(method, "The `" + this.pMacroName + " macro is not the first statement called from the " + method.getName() + " " + methodType.toLowerCase() + "!", new VerissimoAutofixAdditionalInfo(null));
        }
    }

    private boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    private static class HidVisitor
    extends RfHidVisitor {
        private LineInfo lineInfo;
        private boolean isNotFirstStatement;
        private String macroName;

        public HidVisitor(LineInfo info, String macroName) {
            this.lineInfo = info;
            this.macroName = macroName;
            this.isNotFirstStatement = false;
        }

        public boolean visit(RfHid hidObject) {
            IReparseInfo reparseInfo = hidObject.getReparseInfo();
            if (reparseInfo != null && this.macroName.equals(reparseInfo.getLastReparseMacroName())) {
                return true;
            }
            HidOccurrence occurence = hidObject.getOccurrence();
            if (occurence == null) {
                return true;
            }
            if (occurence.getOffset() < this.lineInfo.realOffset) {
                this.isNotFirstStatement = true;
            }
            return false;
        }

        public boolean isNotFirstStatement() {
            return this.isNotFirstStatement;
        }
    }
}

