/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifierCache;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.search.DocumentManager;
import ro.amiq.dvt.utils.DVTLinkedHashMap;
import ro.amiq.dvt.utils.DVTPair;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfAssertExpect;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfWait;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccessArgs;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="25.1.10")
@CheckID(value="R.1034")
@CheckName(value="R.1034")
@CheckLabel(labels={RuleLabel.PROCEDURAL_STATEMENT, RuleLabel.ASSIGNMENT, RuleLabel.WAIT})
@CheckTitle(value="Do not wait for variable that is assigned in parallel thread")
@CheckDescription(value="Waiting for a variable to change its value might lead to a deadlock if the assignment is not made properly on another thread.\nIf not done properly, the wait statement might remain blocked and the code will run indefinitely.\n\nThe rule checks the following:\n- searches for all the wait statements in the project in order to find all the variables used in a wait expression;\n- for all the variables used in a wait expression, it searches for the assignments done inside a loop on that variable;\n- if between any two successive assigments there's no time consuming statement, the rule reports a failure on the wait statement.\n\nExample:\n  Thread 1:\n    wait (flag_variable == 1);\n\n  Thread 2 - not allowed, the wait will remain blocked because there's no time consuming statement between the 2nd assignment and the 1st one in the loop:\n    forever begin\n      flag_variable = 0;\n      #20;\n      flag_variable = 1;\n    end\n\n  Thread 2 - allowed:\n    forever begin\n      flag_variable = 0;\n      #20;\n      flag_variable = 1;\n      #20;\n    end\n\nCheck supports pre-waiving.")
public class Check_R_1034
extends OVMComplianceCheck {
    private Map<RfField, RfWait> waitFields = new HashMap<RfField, RfWait>();
    private DocumentManager documentManager;
    @CheckParameter(defaultValue="bit", description="Comma separated list of variables types to check. If empty, all variable types will be checked.", name="checkedTypes", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private Set<String> pCheckedTypes;

    public Check_R_1034(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.documentManager = new DocumentManager(true);
        this.fOVMProject.getRfProject().accept(namedElement -> {
            if (!(namedElement instanceof RfWait)) {
                return true;
            }
            RfWait wait = (RfWait)namedElement;
            if (wait.getKind() != 0) {
                return true;
            }
            if (this.checkPreWaivers(namedElement.getFile())) {
                return true;
            }
            this.notifyCheckAlive();
            Set flattenedHids = HidUtils.flattenToHids((IHidObject)wait.getExpression(), (Set)HidFlatteningOption.IMPLICITS_EXCLUDED);
            for (IHid hid : flattenedHids) {
                RfHid rfHid;
                IRfNamedElement element;
                while (hid instanceof RfHidAccess) {
                    hid = ((RfHidAccess)hid).getParentHid();
                }
                if (!(hid instanceof RfHid) || !((element = (rfHid = (RfHid)hid).getElement()) instanceof RfField)) continue;
                RfField waitField = (RfField)element;
                if (!this.pCheckedTypes.isEmpty() && !this.pCheckedTypes.contains(LintUtils.getFieldType(waitField).getName())) continue;
                this.waitFields.put(waitField, wait);
            }
            return true;
        });
        for (RfActionBlock actionBlock : this.fOVMProject.getRfProject().getAllActionBlocks()) {
            if (!actionBlock.isLoop() || this.checkPreWaivers(actionBlock.getFile())) continue;
            this.notifyCheckAlive();
            LocalHidVisitor hidVisitor = new LocalHidVisitor();
            actionBlock.visitHidObject(null, hidVisitor);
            Map<RfField, TreeSet<Integer>> blockAssigns = hidVisitor.getFieldAssigns();
            if (blockAssigns == null || blockAssigns.isEmpty()) continue;
            final TreeSet<Integer> timeConsumingStatementOffsets = new TreeSet<Integer>();
            DVTLinkedHashMap<String, RfNamedElement> blockMembers = actionBlock.getLocalMembers(true);
            if (blockMembers != null) {
                for (RfNamedElement member : blockMembers.values()) {
                    boolean isTimeConsuming = false;
                    if (member instanceof RfActionBlock) {
                        isTimeConsuming = ((RfActionBlock)member).isForkJoin() || ((RfActionBlock)member).isForkJoinAny();
                    } else if (member instanceof RfAssertExpect) {
                        isTimeConsuming = ((RfAssertExpect)member).isExpect();
                    } else if (member instanceof RfWait) {
                        isTimeConsuming = true;
                    }
                    if (!isTimeConsuming) continue;
                    timeConsumingStatementOffsets.add(member.getDeclaration().getStartOffset());
                }
            }
            actionBlock.visitHidObject(null, new IHidVisitor<IHidObject>(){
                int forkJoinNoneScopeCount;

                public void setScope(IRfNamedElement scope) {
                    this.forkJoinNoneScopeCount += scope instanceof RfActionBlock && ((RfActionBlock)scope).isForkJoinNone() ? 1 : 0;
                }

                public void endScope(IRfNamedElement scope) {
                    this.forkJoinNoneScopeCount -= this.forkJoinNoneScopeCount > 0 && scope instanceof RfActionBlock && ((RfActionBlock)scope).isForkJoinNone() ? 1 : 0;
                }

                public boolean visit(IHidObject hidObject) {
                    HidOccurrence occurrence;
                    RfHidAccessArgs access;
                    IRfNamedElement target;
                    if (this.forkJoinNoneScopeCount > 0) {
                        return false;
                    }
                    if (hidObject instanceof RfHidOperator) {
                        HidOperatorOccurrence occurrence2;
                        RfHidOperator operator = (RfHidOperator)hidObject;
                        if ((operator.isPound() || operator.isPoundPound() || operator.isEventControl()) && !operator.hasQualifier(HidQualifierCache.IS_CONTROLLED_NON_BLOCKING_ASSIGN_QUALIFIER) && (occurrence2 = operator.getOccurrence()) != null) {
                            timeConsumingStatementOffsets.add(occurrence2.getOffset());
                        }
                    } else if (hidObject instanceof RfHidAccessArgs && (target = (access = (RfHidAccessArgs)hidObject).getParentHid().getElement()) instanceof RfFunction && ((RfFunction)target).isTask() && !((RfFunction)target).isPredefined() && !target.getName().startsWith("$") && (occurrence = access.getOccurrence()) != null) {
                        timeConsumingStatementOffsets.add(occurrence.getOffset());
                    }
                    return true;
                }

                public Class<IHidObject> getType() {
                    return IHidObject.class;
                }
            });
            IDocument document = this.documentManager.getDocument(actionBlock.getDeclaration().getParserPath(), this.fOVMProject.getProject());
            for (Map.Entry<RfField, TreeSet<Integer>> entry : blockAssigns.entrySet()) {
                DVTPair<Integer, Integer> result;
                RfField field = entry.getKey();
                TreeSet<Integer> assignOffsets = entry.getValue();
                RfWait wait = this.waitFields.get(field);
                if (assignOffsets.size() < 2 || wait == null || (result = this.getAssignWithoutTimeStatement(assignOffsets, timeConsumingStatementOffsets)) == null) continue;
                try {
                    int firstAssignLine = document.getLineOfOffset(((Integer)result.getKey()).intValue()) + 1;
                    int secondAssignLine = document.getLineOfOffset(((Integer)result.getValue()).intValue()) + 1;
                    ParserPath parserPath = actionBlock.getDeclaration().getParserPath();
                    String hitMessage = "Wait statement on the '" + LintUtils.getNamedElementFullName(field) + "' field might not be triggered by ";
                    if (firstAssignLine > secondAssignLine) {
                        hitMessage = String.valueOf(hitMessage) + "the following looping assignments:";
                        int swap = secondAssignLine;
                        secondAssignLine = firstAssignLine;
                        firstAssignLine = swap;
                    } else {
                        hitMessage = String.valueOf(hitMessage) + "the following consecutive assignments:";
                    }
                    hitMessage = String.valueOf(hitMessage) + "\n    " + this.link("at line " + firstAssignLine + " of " + LintUtils.getFileShortName(parserPath.path), parserPath.path, firstAssignLine) + "\n" + "    " + this.link("at line " + secondAssignLine + " of " + LintUtils.getFileShortName(parserPath.path), parserPath.path, secondAssignLine);
                    this.addHit(wait, hitMessage);
                }
                catch (BadLocationException e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            }
        }
        this.documentManager.deactivate();
    }

    private DVTPair<Integer, Integer> getAssignWithoutTimeStatement(TreeSet<Integer> assignOffsets, TreeSet<Integer> timeConsumingStatementOffsets) {
        Iterator<Integer> assignIterator = assignOffsets.iterator();
        int previousAssignOffset = assignIterator.next();
        while (assignIterator.hasNext()) {
            int currentAssignOffset = assignIterator.next();
            SortedSet<Integer> timeConsumingStatementsBetween = timeConsumingStatementOffsets.subSet(previousAssignOffset + 1, currentAssignOffset);
            if (timeConsumingStatementsBetween.isEmpty()) {
                return new DVTPair((Object)previousAssignOffset, (Object)currentAssignOffset);
            }
            previousAssignOffset = currentAssignOffset;
        }
        if (timeConsumingStatementOffsets.first() > assignOffsets.first() && timeConsumingStatementOffsets.last() < assignOffsets.last()) {
            return new DVTPair((Object)assignOffsets.last(), (Object)assignOffsets.first());
        }
        return null;
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.checkPreWaivers(fileDef.getParserPath());
    }

    private boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    private final class LocalHidVisitor
    implements IHidVisitor<IHidObject> {
        private Map<RfField, TreeSet<Integer>> fieldAssigns = new HashMap<RfField, TreeSet<Integer>>();
        private ParserPath parserPath;

        private LocalHidVisitor() {
        }

        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }

        public boolean visit(IHidObject hidObject) {
            if (Check_R_1034.this.checkPreWaivers(this.parserPath)) {
                return true;
            }
            Check_R_1034.this.notifyCheckAlive();
            if (!(hidObject instanceof HidOperator)) {
                return true;
            }
            HidOperator operator = (HidOperator)hidObject;
            if (!operator.isAssignment()) {
                return true;
            }
            IHidObject lhValue = operator.getLHValue();
            while (lhValue instanceof RfHidAccess) {
                lhValue = ((RfHidAccess)lhValue).getParentHid();
            }
            if (!(lhValue instanceof RfHid)) {
                return true;
            }
            RfHid rfHid = (RfHid)lhValue;
            IRfNamedElement element = rfHid.getElement();
            if (!(element instanceof RfField)) {
                return true;
            }
            RfField field = (RfField)element;
            if (!Check_R_1034.this.waitFields.containsKey(field)) {
                return true;
            }
            TreeSet<Integer> assigns = this.fieldAssigns.get(field);
            if (assigns == null) {
                assigns = new TreeSet();
                this.fieldAssigns.put(field, assigns);
            }
            assigns.add(operator.getOccurrence().getOffset());
            return true;
        }

        public Map<RfField, TreeSet<Integer>> getFieldAssigns() {
            return this.fieldAssigns;
        }

        public Class<IHidObject> getType() {
            return IHidObject.class;
        }
    }
}

