/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.linter.utils.OVMUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;

@CheckVersion(value="21.1.40")
@CheckID(value="R.1035")
@CheckName(value="R.1035")
@CheckLabel(labels={RuleLabel.SEQUENCE_ITEM, RuleLabel.SEQUENCER, RuleLabel.FIELD, RuleLabel.VERIFICATION})
@CheckTitle(value="Do not use the internal variable xvm_sequence_item::m_sequencer.")
@CheckDescription(value="This check flags the usage of the m_sequencer field of sequence items.\nUse the macro `uvm_declare_p_sequencer to declare a variable p_sequencer in situations where a sequence needs access to the sequencer on which it is running.\n\nCheck supports pre-waiving.")
public class Check_R_1035
extends OVMComplianceCheck {
    private String sequenceItemName;
    private RfClass sequenceItemClass;

    public Check_R_1035(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        RfProject rfProject = this.fOVMProject.getRfProject();
        if (rfProject == null) {
            return;
        }
        this.sequenceItemName = String.valueOf(OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_pkg::")) + OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_sequence_item");
        this.sequenceItemClass = rfProject.getClass(this.sequenceItemName, true);
        if (this.sequenceItemClass == null) {
            return;
        }
        rfProject.visitHidObject(rfProject, new LocalHidVisitor());
    }

    public boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    private final class LocalHidVisitor
    extends RfHidVisitor {
        private LocalHidVisitor() {
        }

        public boolean visit(RfHid hidObject) {
            if (hidObject == null) {
                return true;
            }
            if (Check_R_1035.this.checkPreWaivers(this.parserPath)) {
                return true;
            }
            RfNamedElement rfNamedElement = (RfNamedElement)hidObject.getElement();
            if (!(rfNamedElement instanceof RfField)) {
                return true;
            }
            Check_R_1035.this.notifyCheckAlive();
            RfField rfField = (RfField)rfNamedElement;
            if (!rfField.getName().equals("m_sequencer")) {
                return true;
            }
            if (!rfField.isField()) {
                return true;
            }
            RfClass enclosingClass = rfField.getEnclosingScope(RfClass.class);
            if (enclosingClass == null) {
                return true;
            }
            if (!LintUtils.isSubClassOf(enclosingClass, Check_R_1035.this.sequenceItemClass)) {
                return true;
            }
            Check_R_1035.this.addHit(this.parserPath, hidObject, "Internal variable '" + LintUtils.getNamedElementFullName(rfField) + "' found, use instead p_sequencer!");
            return true;
        }
    }
}

