/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterOverride;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.guidelines.AbstractConstructorCheck;

@CheckVersion(value="21.1.33")
@CheckID(value="R.1036")
@CheckName(value="R.1036")
@CheckLabel(labels={RuleLabel.UVM_SEQUENCE, RuleLabel.CONSTRUCTOR, RuleLabel.VERIFICATION})
@CheckTitle(value="XVM Sequence constructor")
@CheckDescription(value="The constructor for a XVM sequence must look as follows: \n\nfunction new(string name = \"\");\n  super.new(name);\nendfunction\n\nCheck supports pre-waiving.")
@CheckParameterOverride(name="allowCoverageInstantiation", isVisible=false)
public class Check_R_1036
extends AbstractConstructorCheck {
    public Check_R_1036(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        if (this.fOVMProject.fSequences.isEmpty()) {
            return;
        }
        this.checkConstructorWithEmptyName(this.fOVMProject.fSequences, false, true, true);
    }
}

