/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;

@CheckVersion(value="21.1.51")
@CheckID(value="R.1038")
@CheckName(value="R.1038")
@CheckLabel(labels={RuleLabel.FIELD, RuleLabel.GLOBAL, RuleLabel.VERIFICATION})
@CheckTitle(value="Do not use the global variable uvm_pkg::factory")
@CheckDescription(value="This check flags the usage of the global variable 'factory' from uvm_pkg package.\nCall the static method uvm_factory::get() when you need access to the factory.\n\nCheck supports pre-waiving.")
public class Check_R_1038
extends OVMComplianceCheck {
    private final String globalFactoryName = "uvm_pkg::factory";

    public Check_R_1038(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        RfProject rfProject = this.fOVMProject.getRfProject();
        if (rfProject == null) {
            return;
        }
        rfProject.visitHidObject(rfProject, new LocalHidVisitor());
    }

    public boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    private final class LocalHidVisitor
    extends RfHidVisitor {
        private LocalHidVisitor() {
        }

        public boolean visit(RfHid hidObject) {
            if (hidObject == null) {
                return true;
            }
            if (Check_R_1038.this.checkPreWaivers(this.parserPath)) {
                return true;
            }
            IRfNamedElement rfNamedElement = hidObject.getElement();
            if (!(rfNamedElement instanceof RfField)) {
                return true;
            }
            Check_R_1038.this.notifyCheckAlive();
            RfField rfField = (RfField)rfNamedElement;
            if (!rfField.getFullName().equals("uvm_pkg::factory")) {
                return true;
            }
            if (!rfField.isField()) {
                return true;
            }
            Check_R_1038.this.addHit(this.parserPath, hidObject, "Global variable '" + LintUtils.getNamedElementFullName(rfField) + "' found, use uvm_factory::get() instead!");
            return true;
        }
    }
}

