/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckReapplyDisable;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;
import ro.amiq.vlogdt.model.reflection.util.NullProtectedList;

@CheckVersion(value="21.1.33")
@CheckID(value="R.1039")
@CheckName(value="R.1039")
@CheckLabel(labels={RuleLabel.PERFORMANCE, RuleLabel.TEST, RuleLabel.OBJECTION, RuleLabel.VERIFICATION})
@CheckTitle(value="Do not raise or drop objections outside tests")
@CheckDescription(value="It is not recommended to raise or drop objections outside xvm_tests. Raising or dropping an objection in a non-test xvm_component may cause simulation slowdowns due to the additional overhead involved.\n\nExample:\nclass my_driver extends uvm_driver;\n  task run_phase(uvm_phase phase);\n    phase.raise_objection(phase);  // not allowed\n    phase.drop_objection(phase);   // not allowed\n  endtask: run_phase\nendclass: my_driver\n\nclass my_test extends uvm_test;\n  task run_phase(uvm_phase phase);\n    phase.raise_objection(phase);  // allowed\n    phase.drop_objection(phase);   // allowed\n  endtask: run_phase\nendclass: my_test\n\nCheck supports pre-waiving.")
@CheckReapplyDisable
public class Check_R_1039
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="false", description="When true, indirect calls of raise_objection or drop_objection are allowed in tests", name="allowIndirectCalls", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pAllowIndirectCalls;
    private Set<RfFunction> visitedFunctions = new HashSet<RfFunction>();
    private NullProtectedList<RfNamedElement> testClasses = new NullProtectedList();
    private Map<RfFunction, List<RfHid>> raiseAndDropMethodsWithScope = new HashMap<RfFunction, List<RfHid>>();

    public Check_R_1039(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        RfClass xvmTest = this.fOVMProject.fOvmTest;
        if (xvmTest == null) {
            return;
        }
        NullProtectedList<RfNamedElement> projectClasses = this.fOVMProject.getAllNonXVMClasses();
        this.visitedFunctions.clear();
        if (this.pAllowIndirectCalls) {
            for (RfNamedElement rfNamedElement : projectClasses) {
                if (!LintUtils.isSubClassOf((RfClass)rfNamedElement, xvmTest)) continue;
                this.testClasses.add(rfNamedElement);
            }
        }
        for (RfNamedElement rfNamedElement : projectClasses) {
            ParserPath classParserPath;
            RfFileDef classFile;
            if (LintUtils.isSubClassOf((RfClass)rfNamedElement, xvmTest) || (classFile = rfNamedElement.getFile()) == null || (classParserPath = classFile.getParserPath()) == null || this.fOVMProject.getProjectWaivers().pathIsPrewaived(classParserPath, this)) continue;
            this.checkAllMethods((RfClass)rfNamedElement, false);
        }
        if (this.pAllowIndirectCalls && !this.testClasses.isEmpty()) {
            for (RfNamedElement rfNamedElement : this.testClasses) {
                this.checkAllMethods((RfClass)rfNamedElement, true);
            }
        }
        if (this.raiseAndDropMethodsWithScope.isEmpty()) {
            return;
        }
        for (Map.Entry entry : this.raiseAndDropMethodsWithScope.entrySet()) {
            ArrayList raiseAndDropMethodsList = new ArrayList((Collection)entry.getValue());
            for (RfHid hidObject : raiseAndDropMethodsList) {
                ParserPath parserPath = ((RfFunction)entry.getKey()).getFile().getParserPath();
                RfClass functionClass = ((RfFunction)entry.getKey()).getEnclosingScope(RfClass.class);
                if (hidObject.getName().equals("raise_objection")) {
                    this.addHit(parserPath, hidObject, "The raise_objection() method is called inside class '" + functionClass.getFullName() + "'!");
                    continue;
                }
                this.addHit(parserPath, hidObject, "The drop_objection() method is called inside class '" + functionClass.getFullName() + "'!");
            }
        }
    }

    private void checkAllMethods(RfClass clazz, boolean isTestClass) {
        this.notifyCheckAlive();
        HashSet<RfFunction> functions = new HashSet<RfFunction>();
        functions.addAll(clazz.getFunctionsWithPrefix("", 2, 2, IRfNamedElement.AccessModifier.SHOW_PRIVATE));
        functions.addAll(clazz.getTasksWithPrefix("", 2, 2, IRfNamedElement.AccessModifier.SHOW_PRIVATE));
        functions.addAll(clazz.getConstructorsWithPrefix("", 2, 2, IRfNamedElement.AccessModifier.SHOW_PRIVATE));
        if (functions.isEmpty()) {
            return;
        }
        if (!isTestClass) {
            for (RfFunction function : functions) {
                function.visitHidObject(null, new RaiseAndDropObjectionsVisitor(clazz, function));
            }
        } else {
            for (RfFunction function : functions) {
                this.visitedFunctions.add(function);
                function.visitHidObject(null, new RaiseAndDropObjectionsTestsVisitor(clazz));
            }
        }
    }

    private class RaiseAndDropObjectionsTestsVisitor
    extends RfHidVisitor {
        private RfClass functionClass;

        public RaiseAndDropObjectionsTestsVisitor(RfNamedElement clazz) {
            this.functionClass = (RfClass)clazz;
        }

        public boolean visit(RfHid hidObject) {
            RfFunction tempFunction;
            if (!hidObject.isMethodCall(false)) {
                return true;
            }
            IRfNamedElement element = hidObject.getElement();
            if (!(element instanceof RfFunction)) {
                return true;
            }
            if (element.isPredefined()) {
                return true;
            }
            RfFunction function = (RfFunction)element;
            RfNamedElement enclosingScope = function.getEnclosingScope();
            if (!(enclosingScope instanceof RfClass)) {
                return true;
            }
            if (!Check_R_1039.this.fOVMProject.isOVMElement(function) && function.isVirtual() && (tempFunction = LintUtils.getValidVirtualFunction(function, hidObject, this.functionClass)) != null) {
                function = tempFunction;
            }
            if (Check_R_1039.this.visitedFunctions.contains(function)) {
                return true;
            }
            Check_R_1039.this.visitedFunctions.add(function);
            if (Check_R_1039.this.raiseAndDropMethodsWithScope.containsKey(function)) {
                Check_R_1039.this.raiseAndDropMethodsWithScope.remove(function);
                Check_R_1039.this.visitedFunctions.add(function);
                return true;
            }
            function.visitHidObject(null, new RaiseAndDropObjectionsTestsVisitor(this.functionClass));
            return true;
        }
    }

    private class RaiseAndDropObjectionsVisitor
    extends RfHidVisitor {
        private RfClass functionClass;
        private RfFunction currentFunction;

        public RaiseAndDropObjectionsVisitor(RfNamedElement clazz, RfFunction function) {
            this.functionClass = (RfClass)clazz;
            this.currentFunction = function;
        }

        public boolean visit(RfHid hidObject) {
            RfFunction tempFunction;
            if (!hidObject.isMethodCall(false)) {
                return true;
            }
            IRfNamedElement element = hidObject.getElement();
            if (!(element instanceof RfFunction)) {
                return true;
            }
            if (element.isPredefined()) {
                return true;
            }
            RfFunction function = (RfFunction)element;
            RfNamedElement enclosingScope = function.getEnclosingScope();
            if (!(enclosingScope instanceof RfClass)) {
                return true;
            }
            if (!Check_R_1039.this.fOVMProject.isOVMElement(function) && function.isVirtual() && (tempFunction = LintUtils.getValidVirtualFunction(function, hidObject, this.functionClass)) != null) {
                function = tempFunction;
            }
            if (!function.isFunction()) {
                return true;
            }
            if (function.getName().equals("raise_objection") || function.getName().equals("drop_objection")) {
                if (Check_R_1039.this.raiseAndDropMethodsWithScope.containsKey(this.currentFunction)) {
                    newList = new ArrayList(Check_R_1039.this.raiseAndDropMethodsWithScope.get(this.currentFunction));
                    newList.add(hidObject);
                    Check_R_1039.this.raiseAndDropMethodsWithScope.replace(this.currentFunction, newList);
                } else {
                    newList = new ArrayList<RfHid>();
                    newList.add(hidObject);
                    Check_R_1039.this.raiseAndDropMethodsWithScope.put(this.currentFunction, newList);
                }
            }
            return true;
        }
    }
}

