/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterOverride;
import ro.amiq.vlogdt.linter.base.annotations.CheckParametersOverrides;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.Check_SVTB_30_1_0;

@CheckVersion(value="21.1.40")
@CheckID(value="R.1040")
@CheckName(value="R.1040")
@CheckLabel(labels={RuleLabel.UVM_IEEE, RuleLabel.METHOD, RuleLabel.REMOVED_API, RuleLabel.VERIFICATION})
@CheckTitle(value="Do not use 'get_config_int, get_config_string, get_config_object'")
@CheckDescription(value="The following functions are no longer available in the UVM IEEE 1800.2-2020 standard or the implementation library:\n - uvm_pkg::uvm_component.get_config_int()\n - uvm_pkg::uvm_component.get_config_string()\n - uvm_pkg::uvm_component.get_config_object()\n Use instead:\n - uvm_config_db#(int)::get(this, \"*\", \"int_field_name\", value);\n - uvm_config_db#(string)::get(this, \"*\", \"str_field_name\", value);\n - uvm_config_db#(uvm_object)::get(this, \"*\", \"obj_field_name\", obj);\n\nCheck supports pre-waiving.")
@CheckParametersOverrides(value={@CheckParameterOverride(name="deprecatedComments", defaultValue="", isVisible=false), @CheckParameterOverride(name="deprecatedMethods", defaultValue="uvm_pkg::uvm_component.get_config_int, uvm_pkg::uvm_component.get_config_string, uvm_pkg::uvm_component.get_config_object", isVisible=false), @CheckParameterOverride(name="allowedPaths", isVisible=false), @CheckParameterOverride(name="invertedFilter", isVisible=false)})
public class Check_R_1040
extends Check_SVTB_30_1_0 {
    public Check_R_1040(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    protected String makeMessage(String calledFunctionFullName) {
        return "Removed method call '" + calledFunctionFullName + "()'!";
    }
}

