/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.parser.SVTBIssues;

@CheckVersion(value="21.1.33")
@CheckID(value="R.1041")
@CheckName(value="R.1041")
@CheckLabel(labels={RuleLabel.GLOBAL, RuleLabel.DIRECTIVE, RuleLabel.FILE, RuleLabel.TIMESCALE})
@CheckTitle(value="Do not use timescale in the compiled files")
@CheckDescription(value="A file should not include a globally scoped `timescale declaration. It is recommended to pass the timescale through the argument files.\nExamples:\nfile.sv:\n`timescale 1ns/1ns // not allowed\n\nfilelist.f:\n-timescale 1ns/1ns // allowed\n\nCheck supports pre-waiving.")
public class Check_R_1041
extends OVMComplianceCheck {
    private static final Pattern SPACE_PATTERN = Pattern.compile("\\s+");

    public Check_R_1041(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void preBuildNotification(RfProject aRfProject) {
        aRfProject.lintTrackP2LInfo(37);
    }

    @Override
    public void performCheckImpl() {
        HashSet<ParserPath> files = this.fOVMProject.getAllImportedFiles();
        if (files.isEmpty()) {
            return;
        }
        Map<ParserPath, List<SVTBIssues>> allIssues = this.fOVMProject.getSVTBIssuesWithKind(37);
        for (ParserPath file : files) {
            List<SVTBIssues> timescales;
            this.notifyCheckAlive();
            if (this.checkPreWaivers(file) || (timescales = allIssues.get(file)) == null || timescales.isEmpty()) continue;
            for (SVTBIssues timescale : timescales) {
                String timescaleValue = timescale.getInfo();
                if (timescaleValue == null) continue;
                timescaleValue = SPACE_PATTERN.matcher(timescaleValue).replaceAll(" ");
                this.addHit(file, timescale.getLine(), "Timescale '" + timescaleValue + "' used!", timescale.getReparseInfo());
            }
        }
    }

    public boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }
}

