/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.rules.AbstractPathIncludeCheck;

@CheckVersion(value="21.1.40")
@CheckID(value="R.1042")
@CheckName(value="R.1042")
@CheckLabel(labels={RuleLabel.FILE, RuleLabel.INCLUDE})
@CheckTitle(value="Do not include files using their paths")
@CheckDescription(value="All includes should never be referencing paths within the include quotes.\nMust be formatted as include \"example.sv\" and the +incdir for the directory must be in the filelist definition for compilation.\nEnforcing this rules ensures an easier to maintain code base especially when files are moved in different folders.\n\nAllowed:\n`include \"example.sv\" (in .sv file)\n+incdir+path/to/file (in build file)\n\nNot allowed:\n'include \"path/to/file/example.sv\" (in .sv file)\n\nCheck supports pre-waiving.")
public class Check_R_1042
extends AbstractPathIncludeCheck {
    public Check_R_1042(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    protected void analyzeFilePath(String filePath, ParserPath path, int lineNumber) {
        int lastSeparatorIndex = this.findLastSeparatorIndex(filePath);
        if (lastSeparatorIndex < 0 || lastSeparatorIndex >= filePath.length()) {
            return;
        }
        this.addHit(path, lineNumber, "'" + filePath.substring(lastSeparatorIndex + 1, filePath.length() - 1) + "' referenced by path, change to '`import " + filePath.charAt(0) + filePath.substring(lastSeparatorIndex + 1, filePath.length()) + "' and add '+incdir+" + filePath.substring(1, lastSeparatorIndex) + "' in the build file.", null);
    }

    private int findLastSeparatorIndex(String filePath) {
        int lastSeparatorIndex = filePath.length() - 1;
        while (lastSeparatorIndex >= 0 && filePath.charAt(lastSeparatorIndex) != '/') {
            --lastSeparatorIndex;
        }
        return lastSeparatorIndex;
    }
}

