/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterOverride;
import ro.amiq.vlogdt.linter.base.annotations.CheckParametersOverrides;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractOverrideMethodFromParentClassCheck;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfFunction;

@CheckVersion(value="21.1.33")
@CheckID(value="R.1043")
@CheckName(value="R.1043")
@CheckLabel(labels={RuleLabel.RUN_PHASE, RuleLabel.METHOD, RuleLabel.OVERRIDE, RuleLabel.VERIFICATION})
@CheckTitle(value="Do not override sub-run phases")
@CheckDescription(value="Classes should not override reset_phase(), configure_phase(), main_phase(), shutdown_phase() and the pre_/post_ versions of those phases.\nExamples:\nclass my_agent extends uvm_agent;\n  task reset_phase(uvm_phase phase); // not allowed\n    super.reset_phase(phase);\n\tendtask : reset_phase\n\nclass my_agent extends uvm_agent;\n  task run_phase(uvm_phase phase); // allowed\n    super.run_phase(phase);\n\tendtask : run_phase\n\nCheck supports pre-waiving.")
@CheckParametersOverrides(value={@CheckParameterOverride(name="methodName", defaultValue="pre_reset_phase, reset_phase, post_reset_phase, pre_configure_phase, configure_phase, post_configure_phase, pre_main_phase, main_phase, post_main_phase, pre_shutdown_phase, shutdown_phase, post_shutdown_phase", isVisible=false), @CheckParameterOverride(name="baseClass", defaultValue="uvm_pkg::uvm_component", isVisible=false)})
public class Check_R_1043
extends AbstractOverrideMethodFromParentClassCheck {
    public Check_R_1043(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void computeHitForMethod(RfClass aClass, String aMethodName, RfFunction implementedMethod) {
        if (implementedMethod != null) {
            this.addHit(implementedMethod, "Class '" + aClass.getName() + "' overrides '" + aMethodName + "()' !");
        }
    }
}

