/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.rules.AbstractUVMIEEEDeviationCheck;

@CheckVersion(value="21.1.33")
@CheckID(value="R.1044")
@CheckName(value="R.1044")
@CheckLabel(labels={RuleLabel.UVM_IEEE, RuleLabel.METHOD, RuleLabel.VERIFICATION})
@CheckTitle(value="Do not use UVM IEEE 1800.2-2020 uvm_reg.get_local_map deviation")
@CheckDescription(value="\nSection 18.4.3.6 of the UVM IEEE 1800.2-2020 standard says that if the map argument passed to get_local_map() is null, then the default map of the parent block is returned.\nThe actual behaviour is to return the result of the get_default_map() call.\n\nCheck supports pre-waiving.")
public class Check_R_1044
extends AbstractUVMIEEEDeviationCheck {
    public Check_R_1044(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
        this.methodName = "uvm_pkg::uvm_reg.get_local_map";
    }

    @Override
    protected boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }
}

