/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;

@CheckVersion(value="21.1.51")
@CheckID(value="R.1045")
@CheckName(value="R.1045")
@CheckLabel(labels={RuleLabel.BUILD_PHASE, RuleLabel.METHOD, RuleLabel.COMPONENT, RuleLabel.SUPER, RuleLabel.VERIFICATION, RuleLabel.EXTEND})
@CheckTitle(value="Do not call super.build_phase() in user-defined component classes that directly extend XVM base classes")
@CheckDescription(value="\nWhere a user-defined component class directly extends a class from the XVM base class library and overrides the standard build_phase method, do not call super.build_phase()\n\nCheck supports pre-waiving.")
public class Check_R_1045
extends OVMComplianceCheck {
    private static final String SUPER = "super";
    private String currentClassName;

    public Check_R_1045(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        RfProject rfProject = this.fOVMProject.getRfProject();
        if (rfProject == null) {
            return;
        }
        for (RfClass currentClass : this.fOVMProject.getAllClasses()) {
            RfClass parentClass;
            if (this.fOVMProject.isOVMElement(currentClass) || (parentClass = currentClass.getParent()) == null || !this.fOVMProject.isOVMElement(parentClass)) continue;
            this.currentClassName = LintUtils.getNamedElementFullName(currentClass);
            currentClass.visitHidObject(rfProject, new LocalHidVisitor());
        }
    }

    public boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    private final class LocalHidVisitor
    extends RfHidVisitor {
        private LocalHidVisitor() {
        }

        public boolean visit(RfHid hidObject) {
            if (hidObject == null) {
                return true;
            }
            if (Check_R_1045.this.checkPreWaivers(this.parserPath)) {
                return true;
            }
            if (!hidObject.isMethodCall(false)) {
                return true;
            }
            if (!(this.holder instanceof RfHidHolder)) {
                return true;
            }
            IRfNamedElement scope = ((RfHidHolder)this.holder).getScope();
            if (!(scope instanceof RfNamedElement)) {
                return true;
            }
            Check_R_1045.this.notifyCheckAlive();
            RfFunction enclosingFunction = (RfFunction)scope.getEnclosingScope(RfFunction.class);
            if (enclosingFunction == null) {
                return true;
            }
            if (!"build_phase".equals(enclosingFunction.getName())) {
                return true;
            }
            if (!"build_phase".equals(hidObject.getName())) {
                return true;
            }
            Hid parentHid = hidObject.getParentHid();
            if (!(parentHid instanceof RfHid)) {
                return true;
            }
            RfHid parentHidObject = (RfHid)parentHid;
            if (!Check_R_1045.SUPER.equals(parentHidObject.getName())) {
                return true;
            }
            Check_R_1045.this.addHit(this.parserPath, parentHidObject, "super.build_phase() called by overridden function build_phase() in '" + Check_R_1045.this.currentClassName + "'!");
            return true;
        }
    }
}

