/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.search.DocumentManager;
import ro.amiq.dvt.utils.DVTPair;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.IWhitespaceParserCheck;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.linter.utils.LiteralToken;
import ro.amiq.vlogdt.linter.utils.SVTBWhitespaceParser;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfActionBlockDef;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;
import ro.amiq.vlogdt.model.reflection.util.RfBatchUtils;
import ro.amiq.vlogdt.model.reflection.util.RfWNamedElementAndScope;

@CheckVersion(value="21.1.41")
@CheckID(value="R.1046")
@CheckName(value="R.1046")
@CheckLabel(labels={RuleLabel.PROCEDURAL_STATEMENT, RuleLabel.CONDITIONAL, RuleLabel.DEAD_CODE, RuleLabel.IF})
@CheckTitle(value="Related if/else if statements should not have the same condition")
@CheckDescription(value="A chain of if/else if statements is evaluated from top to bottom. At most, only one branch will be executed: the first one with a condition that evaluates to true.\n\nTherefore, duplicating a condition automatically leads to dead code. Usually, this is due to a copy/paste error.\nAt best, it's simply dead code and at worst, it's a bug that is likely to induce further bugs as the code is maintained, and obviously it could lead to unexpected behavior.\n\nExamples:\nif (a == 1) begin\n\tend\nelse if (a == 1) begin // not allowed \n\tend\nelse if (a == 5) begin // allowed\n\tend\n\nCheck supports pre-waiving.")
public class Check_R_1046
extends OVMComplianceCheck
implements IWhitespaceParserCheck {
    private static final String IF = "if";
    private static final String ELSE = "else";
    private Set<String> nonSymmetricOperators = new HashSet<String>(Arrays.asList("-", "/", "%", "**", "<", "<=", ">", ">=", "&", "|", "^", "^~", "~^", ">>", "<<", ">>>", "<<<", "->"));
    private Set<DVTPair<String, String>> revertedRelationalPairs = new HashSet<DVTPair>(Arrays.asList(new DVTPair((Object)"<", (Object)">"), new DVTPair((Object)">", (Object)"<"), new DVTPair((Object)"<=", (Object)">="), new DVTPair((Object)">=", (Object)"<=")));

    public Check_R_1046(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void performCheckImpl() {
        documentManager = new DocumentManager(true);
        actionBlocks = this.fOVMProject.getRfProject().getAllActionBlocks();
        if (actionBlocks == null) {
            return;
        }
        for (RfActionBlock actionBlock : actionBlocks) {
            if (actionBlock == null || actionBlock.getFile() == null) continue;
            parserPath = actionBlock.getFile().getParserPath();
            if (this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this)) continue;
            this.notifyCheckAlive();
            document = documentManager.getDocument(parserPath, this.fOVMProject.getProject());
            if (!actionBlock.isIf()) continue;
            conditions = new HashSet<IHidObject>();
            hidHolder = actionBlock.getHidHolder();
            if (hidHolder == null || (objectsMap = hidHolder.getHidObjectsMap()) == null) continue;
            ifHidValues = (ListContainer)objectsMap.get(parserPath);
            if (ifHidValues != null && !ifHidValues.isEmpty()) {
                ifHid = (IHidObject)ifHidValues.get(0);
                if (!(ifHid instanceof RfHidOperator) || (ifCondition = ((RfHidOperator)ifHid).getLHValue()) == null) continue;
                conditions.add(ifCondition);
            }
            if ((nextElseIfBlock = this.findNextElseIfBlock(parserPath, document, actionBlock.getEndOffset())) instanceof RfActionBlock) ** GOTO lbl59
            continue;
lbl-1000:
            // 1 sources

            {
                isSameExpresion = false;
                this.notifyCheckAlive();
                hidHolder = nextElseIfBlock.getHidHolder();
                if (hidHolder == null) {
                    nextElseIfBlock = this.findNextElseIfBlock(parserPath, document, nextElseIfBlock.getEndOffset());
                    continue;
                }
                hidObjectsMap = hidHolder.getHidObjectsMap();
                if (hidObjectsMap == null) {
                    nextElseIfBlock = this.findNextElseIfBlock(parserPath, document, nextElseIfBlock.getEndOffset());
                    continue;
                }
                elseIfHidValues = (ListContainer)hidObjectsMap.get(parserPath);
                if (elseIfHidValues == null || elseIfHidValues.isEmpty()) {
                    nextElseIfBlock = this.findNextElseIfBlock(parserPath, document, nextElseIfBlock.getEndOffset());
                    continue;
                }
                elseIfHid = (IHidObject)elseIfHidValues.get(0);
                if (!(elseIfHid instanceof RfHidOperator)) {
                    nextElseIfBlock = this.findNextElseIfBlock(parserPath, document, nextElseIfBlock.getEndOffset());
                    continue;
                }
                elseIfCondition = ((RfHidOperator)elseIfHid).getLHValue();
                if (!(elseIfCondition instanceof RfHidOperator)) {
                    nextElseIfBlock = this.findNextElseIfBlock(parserPath, document, nextElseIfBlock.getEndOffset());
                    continue;
                }
                for (IHidObject condition : conditions) {
                    if (!(condition instanceof RfHidOperator)) continue;
                    prevConditionHidOperator = (RfHidOperator)condition;
                    elseIfConditionHidOperator = (RfHidOperator)elseIfCondition;
                    isSameExpresion = LintUtils.compareOperatorTrees(prevConditionHidOperator, elseIfConditionHidOperator, this.revertedRelationalPairs, this.nonSymmetricOperators, this.nonSymmetricOperators.contains(((RfHidOperator)condition).getOperatorText()) == false);
                    if (isSameExpresion) break;
                }
                if (isSameExpresion) {
                    this.addHit(nextElseIfBlock, "This branch can not be reached because the condition duplicates a previous condition in the same sequence of \"if/else if\" statements!");
                } else {
                    conditions.add(elseIfCondition);
                }
                nextElseIfBlock = this.findNextElseIfBlock(parserPath, document, nextElseIfBlock.getEndOffset());
lbl59:
                // 7 sources

                ** while (nextElseIfBlock instanceof RfActionBlock)
            }
lbl60:
            // 1 sources

        }
    }

    private RfNamedElement findNextElseIfBlock(ParserPath parserPath, IDocument document, int actionBlockEndOffset) {
        int nextElseIfOffset = this.computeCorespondingElseIfStatementOffset(parserPath, actionBlockEndOffset, document);
        if (nextElseIfOffset == -1) {
            return null;
        }
        RfWNamedElementAndScope namedElementAndScope = RfBatchUtils.getRfElement(this.fOVMProject.getRfProject(), parserPath, document, nextElseIfOffset);
        IRfScopeElement nextElseIfBlockDef = namedElementAndScope.getScope();
        if (!(nextElseIfBlockDef instanceof RfActionBlockDef)) {
            return null;
        }
        return ((RfActionBlockDef)nextElseIfBlockDef).getNamedElement();
    }

    private int computeCorespondingElseIfStatementOffset(ParserPath parserPath, int endOffset, IDocument document) {
        LiteralToken token = this.getWSParser().getTokenByEnding(endOffset, parserPath);
        if (token == null) {
            return -1;
        }
        if ((token = this.getNextTokenWithSkipComments(parserPath, token)) == null || !ELSE.equals(token.getStringToken())) {
            return -1;
        }
        LiteralToken ifToken = this.getNextTokenWithSkipComments(parserPath, token);
        if (ifToken == null || !ifToken.getStringToken().startsWith(IF)) {
            return -1;
        }
        LiteralToken openParenthesisToken = null;
        if (IF.equals(ifToken.getStringToken()) && (openParenthesisToken = this.getNextTokenWithSkipComments(parserPath, ifToken)) == null) {
            return -1;
        }
        int rightParenthesisOffset = this.getMatchingRightParenthesesOffset(document, openParenthesisToken != null ? openParenthesisToken.getOffsetFile() : ifToken.getOffsetFile() + 2, document.getLength());
        return rightParenthesisOffset + 1;
    }

    private LiteralToken getNextTokenWithSkipComments(ParserPath parserPath, LiteralToken token) {
        token = this.getWSParser().getNextToken(token, parserPath);
        while (token != null && token.getZone() != SVTBWhitespaceParser.ZoneType.CODE) {
            token = this.getWSParser().getNextToken(token, parserPath);
        }
        return token;
    }

    public int getMatchingRightParenthesesOffset(IDocument document, int leftParanthesesOffset, int maxOffset) {
        int counter = 1;
        int currentOffset = 0;
        try {
            String text = document.get(leftParanthesesOffset + 1, maxOffset - leftParanthesesOffset - 1);
            while (counter > 0 && currentOffset < text.length()) {
                char c;
                String content = ((IDocumentExtension3)document).getContentType("__vlog_partitioning", leftParanthesesOffset + currentOffset + 1, false);
                if (!"__dftl_partition_content_type".equals(content)) {
                    ++currentOffset;
                    continue;
                }
                if ((c = text.charAt(currentOffset++)) == '(') {
                    ++counter;
                    continue;
                }
                if (c != ')') continue;
                --counter;
            }
        }
        catch (BadLocationException | BadPartitioningException e) {
            DVTLogger.INSTANCE.logError(e);
        }
        if (counter == 0) {
            return leftParanthesesOffset + currentOffset;
        }
        return -1;
    }

    @Override
    public boolean requiresLineEndings() {
        return true;
    }
}

