/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.Set;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifierCache;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperatorConstants;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="21.1.42")
@CheckID(value="R.1047")
@CheckName(value="R.1047")
@CheckLabel(labels={RuleLabel.OPERATOR, RuleLabel.CONDITIONAL, RuleLabel.DEAD_CODE})
@CheckTitle(value="Do not use identical expressions on both sides of a binary operator")
@CheckDescription(value="This rule flags binary operators that have the same expresion on both sides.\n\nExamples:\nif ( a == a ) begin // always true\nend\nif ( a != a ) begin // always false\nend\nif ( a == b && a == b ) begin // if the first one is true, the second one is too\nend\nif ( a == b || a == b ) begin // if the first one is true, the second one is too\nend\n\nint j = 5 / 5; //always 1\nint k = 5 - 5; //always 0\n\nCheck supports pre-waiving.")
public class Check_R_1047
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="+,-,*,/,%,==,!=,===,!==,==?,!=,!=?,?,&&,||,**,<,<=,>,>=,&,|,^,^~,~^,>>,<<,>>>,<<<,->,<->", description="Comma separated list of binary operators which are checked.", name="checkedOperators", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private Set<String> pCheckedOperators;

    public Check_R_1047(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.fOVMProject.getRfProject().visitHidObject(null, new OperatorVisior());
    }

    public boolean checkPrewaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    private class OperatorVisior
    implements IHidVisitor<RfHidOperator> {
        ParserPath parserPath;

        private OperatorVisior() {
        }

        public boolean visit(RfHidOperator hidObject) {
            if (Check_R_1047.this.checkPrewaivers(this.parserPath)) {
                return true;
            }
            Check_R_1047.this.notifyCheckAlive();
            if (Check_R_1047.this.fOVMProject.isOVMFile(LintUtils.getFileShortName(this.parserPath.path))) {
                return true;
            }
            if (hidObject.getOperatorKind() != IHidOperatorConstants.OperatorKind.BINARY_OPERATOR) {
                return true;
            }
            if (hidObject.hasQualifier(HidQualifierCache.IS_CASE_ITEM_EXPRESSION_QUALIFIER)) {
                return true;
            }
            if (hidObject.getReparseInfo() != null) {
                return true;
            }
            if (!Check_R_1047.this.pCheckedOperators.contains(hidObject.getOperatorText())) {
                return true;
            }
            if (hidObject.isAssignment()) {
                return true;
            }
            IHidObject lhValue = hidObject.getLHValue();
            ListContainer rhValues = hidObject.getRHValues();
            if (rhValues == null || rhValues.size() != 1) {
                return true;
            }
            IHidObject rhValue = (IHidObject)rhValues.get(0);
            if (LintUtils.compareExpressions(lhValue, rhValue)) {
                Check_R_1047.this.addHit(this.parserPath, (HidOccurrence)hidObject.getOccurrence(), "Binary operator '" + hidObject.getOperatorText() + "' has the same expresion on both sides!");
            }
            return true;
        }

        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }

        public Class<RfHidOperator> getType() {
            return RfHidOperator.class;
        }
    }
}

